/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.DelegatingSerializationFilter;
import org.keycloak.common.util.KerberosJdkProvider;

public class KerberosSerializationUtils {
    public static final String JAVA_INFO;

    private KerberosSerializationUtils() {
    }

    public static String serializeCredential(KerberosTicket kerberosTicket, GSSCredential gssCredential) throws KerberosSerializationException {
        try {
            if (gssCredential == null) {
                throw new KerberosSerializationException("Null credential given as input");
            }
            kerberosTicket = KerberosJdkProvider.getProvider().gssCredentialToKerberosTicket(kerberosTicket, gssCredential);
            return KerberosSerializationUtils.serialize(kerberosTicket);
        }
        catch (IOException e) {
            throw new KerberosSerializationException("Unexpected exception when serialize GSSCredential", e);
        }
    }

    public static GSSCredential deserializeCredential(String serializedCred) throws KerberosSerializationException {
        if (serializedCred == null) {
            throw new KerberosSerializationException("Null credential given as input. Did you enable kerberos credential delegation for your web browser and mapping of gss credential to access token?");
        }
        try {
            Object deserializedCred = KerberosSerializationUtils.deserialize(serializedCred);
            if (!(deserializedCred instanceof KerberosTicket)) {
                throw new KerberosSerializationException("Deserialized object is not KerberosTicket! Type is: " + deserializedCred);
            }
            KerberosTicket ticket = (KerberosTicket)deserializedCred;
            return KerberosJdkProvider.getProvider().kerberosTicketToGSSCredential(ticket);
        }
        catch (KerberosSerializationException ke) {
            throw ke;
        }
        catch (Exception ioe) {
            throw new KerberosSerializationException("Unexpected exception when deserialize GSSCredential", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            byte[] objBytes = bos.toByteArray();
            String string = Base64.encodeBytes(objBytes);
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserialize(String serialized) throws ClassNotFoundException, IOException {
        byte[] bytes = Base64.decode(serialized);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            DelegatingSerializationFilter.builder().addAllowedClass(KerberosTicket.class).addAllowedClass(KerberosPrincipal.class).addAllowedClass(InetAddress.class).addAllowedPattern("javax.security.auth.kerberos.KeyImpl").setFilter(in);
            Object object = in.readObject();
            return object;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        String javaVersion = System.getProperty("java.version");
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        String javaVendor = System.getProperty("java.vendor");
        String os = System.getProperty("os.version");
        JAVA_INFO = "Java version: " + javaVersion + ", runtime version: " + javaRuntimeVersion + ", vendor: " + javaVendor + ", os: " + os;
    }

    public static class KerberosSerializationException
    extends RuntimeException {
        public KerberosSerializationException(String message, Throwable cause) {
            super(message + ", " + JAVA_INFO, cause);
        }

        public KerberosSerializationException(String message) {
            super(message + ", " + JAVA_INFO);
        }
    }
}

