/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapCrudOperations;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.storage.SearchableModelField;

public class ConcurrentHashMapKeycloakTransaction<K, V extends AbstractEntity & UpdatableEntity, M>
implements MapKeycloakTransaction<V, M> {
    private static final Logger log = Logger.getLogger(ConcurrentHashMapKeycloakTransaction.class);
    protected boolean active;
    protected boolean rollback;
    protected final Map<String, MapTaskWithValue> tasks = new LinkedHashMap<String, MapTaskWithValue>();
    protected final ConcurrentHashMapCrudOperations<V, M> map;
    protected final StringKeyConverter<K> keyConverter;
    protected final DeepCloner cloner;
    protected final Map<SearchableModelField<? super M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<K, V, M>> fieldPredicates;

    public ConcurrentHashMapKeycloakTransaction(ConcurrentHashMapCrudOperations<V, M> map, StringKeyConverter<K> keyConverter, DeepCloner cloner, Map<SearchableModelField<? super M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<K, V, M>> fieldPredicates) {
        this.map = map;
        this.keyConverter = keyConverter;
        this.cloner = cloner;
        this.fieldPredicates = fieldPredicates;
    }

    public void begin() {
        this.active = true;
    }

    public void commit() {
        if (this.rollback) {
            throw new RuntimeException("Rollback only!");
        }
        if (!this.tasks.isEmpty()) {
            log.tracef("Commit - %s", this.map);
            for (MapTaskWithValue value : this.tasks.values()) {
                value.execute();
            }
        }
    }

    public void rollback() {
        this.tasks.clear();
    }

    public void setRollbackOnly() {
        this.rollback = true;
    }

    public boolean getRollbackOnly() {
        return this.rollback;
    }

    public boolean isActive() {
        return this.active;
    }

    private MapModelCriteriaBuilder<K, V, M> createCriteriaBuilder() {
        return new MapModelCriteriaBuilder<K, V, M>(this.keyConverter, this.fieldPredicates);
    }

    protected void addTask(String key, MapTaskWithValue task) {
        log.tracef("Adding operation %s for %s @ %08x", (Object)task.getOperation(), (Object)key, (Object)System.identityHashCode(task.getValue()));
        this.tasks.merge(key, task, (x$0, x$1) -> new MapTaskCompose((MapTaskWithValue)x$0, (MapTaskWithValue)x$1));
    }

    public V registerEntityForChanges(V origEntity) {
        String key = origEntity.getId();
        if (this.tasks.containsKey(key)) {
            MapTaskWithValue current = this.tasks.get(key);
            return current.getValue();
        }
        AbstractEntity res = (AbstractEntity)this.cloner.from(origEntity);
        return (V)this.updateIfChanged(res, e -> ((UpdatableEntity)((Object)e)).isUpdated());
    }

    @Override
    public V read(String sKey) {
        try {
            AbstractEntity entity = this.read(sKey, this.map::read);
            return (V)this.registerEntityForChanges(entity);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public V read(String key, Function<String, V> defaultValueFunc) {
        MapTaskWithValue current = this.tasks.get(key);
        if (this.tasks.containsKey(key)) {
            return current.getValue();
        }
        AbstractEntity value = (AbstractEntity)defaultValueFunc.apply(key);
        for (MapTaskWithValue val : this.tasks.values()) {
            BulkDeleteOperation delOp;
            if (!(val instanceof BulkDeleteOperation) || (delOp = (BulkDeleteOperation)val).getFilterForNonDeletedObjects().test(value)) continue;
            return null;
        }
        return (V)value;
    }

    @Override
    public Stream<V> read(QueryParameters<M> queryParameters) {
        Stream<AbstractEntity> res;
        DefaultModelCriteria<M> mcb = queryParameters.getModelCriteriaBuilder();
        MapModelCriteriaBuilder<K, V, M> mapMcb = mcb.flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        Predicate<AbstractEntity> filterOutAllBulkDeletedObjects = this.tasks.values().stream().filter(BulkDeleteOperation.class::isInstance).map(BulkDeleteOperation.class::cast).map(BulkDeleteOperation::getFilterForNonDeletedObjects).reduce(Predicate::and).orElse(v -> true);
        Stream<AbstractEntity> updatedAndNotRemovedObjectsStream = this.map.read(queryParameters).filter(filterOutAllBulkDeletedObjects).map(x$0 -> this.getUpdated((AbstractEntity)x$0)).filter(x$0 -> Objects.nonNull(x$0)).map(x$0 -> this.registerEntityForChanges((AbstractEntity)x$0));
        Stream<AbstractEntity> stream = res = mapMcb == null ? updatedAndNotRemovedObjectsStream : Stream.concat(this.createdValuesStream(mapMcb.getKeyFilter(), mapMcb.getEntityFilter()), updatedAndNotRemovedObjectsStream);
        if (!queryParameters.getOrderBy().isEmpty()) {
            res = res.sorted(MapFieldPredicates.getComparator(queryParameters.getOrderBy().stream()));
        }
        return res;
    }

    @Override
    public long getCount(QueryParameters<M> queryParameters) {
        return this.read(queryParameters).count();
    }

    private V getUpdated(V orig) {
        MapTaskWithValue current = orig == null ? null : this.tasks.get(orig.getId());
        return current == null ? orig : current.getValue();
    }

    @Override
    public V create(V value) {
        String key = value.getId();
        if (key == null) {
            K newKey = this.keyConverter.yieldNewUniqueKey();
            key = this.keyConverter.keyToString(newKey);
            value = this.cloner.from(key, value);
        } else {
            value = (AbstractEntity)this.cloner.from(value);
        }
        this.addTask(key, new CreateOperation(this, value));
        return value;
    }

    public V updateIfChanged(V value, final Predicate<V> shouldPut) {
        String key = value.getId();
        log.tracef("Adding operation UPDATE_IF_CHANGED for %s @ %08x", (Object)key, (Object)System.identityHashCode(value));
        String taskKey = key;
        MapTaskWithValue op = new MapTaskWithValue((AbstractEntity)value){

            @Override
            public void execute() {
                if (shouldPut.test(this.getValue())) {
                    ConcurrentHashMapKeycloakTransaction.this.map.update(this.getValue());
                }
            }

            @Override
            public MapOperation getOperation() {
                return MapOperation.UPDATE;
            }
        };
        return this.tasks.merge(taskKey, op, this::merge).getValue();
    }

    @Override
    public boolean delete(String key) {
        this.tasks.merge(key, new DeleteOperation(key), this::merge);
        return true;
    }

    @Override
    public long delete(QueryParameters<M> queryParameters) {
        log.tracef("Adding operation DELETE_BULK", new Object[0]);
        K artificialKey = this.keyConverter.yieldNewUniqueKey();
        BulkDeleteOperation bdo = new BulkDeleteOperation(queryParameters);
        Predicate filterForNonDeletedObjects = bdo.getFilterForNonDeletedObjects();
        long res = 0L;
        Iterator<Map.Entry<String, MapTaskWithValue>> it = this.tasks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MapTaskWithValue> me = it.next();
            if (filterForNonDeletedObjects.test(me.getValue().getValue())) continue;
            log.tracef(" [DELETE_BULK] removing %s", (Object)me.getKey());
            it.remove();
            ++res;
        }
        this.tasks.put(this.keyConverter.keyToString(artificialKey), bdo);
        return res + bdo.getCount();
    }

    private Stream<V> createdValuesStream(Predicate<? super K> keyFilter, Predicate<? super V> entityFilter) {
        return this.tasks.entrySet().stream().filter(me -> keyFilter.test((K)this.keyConverter.fromStringSafe((String)me.getKey()))).map(Map.Entry::getValue).filter(v -> v.containsCreate() && !v.isReplace()).map(MapTaskWithValue::getValue).filter(x$0 -> Objects.nonNull(x$0)).filter(entityFilter).collect(Collectors.toList()).stream();
    }

    private MapTaskWithValue merge(MapTaskWithValue oldValue, MapTaskWithValue newValue) {
        switch (newValue.getOperation()) {
            case DELETE: {
                return oldValue.containsCreate() ? null : newValue;
            }
        }
        return new MapTaskCompose(oldValue, newValue);
    }

    protected static abstract class MapTaskWithValue {
        protected final V value;
        final /* synthetic */ ConcurrentHashMapKeycloakTransaction this$0;

        public MapTaskWithValue(V value) {
            this.this$0 = this$0;
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public boolean containsCreate() {
            return MapOperation.CREATE == this.getOperation();
        }

        public boolean containsRemove() {
            return MapOperation.DELETE == this.getOperation();
        }

        public boolean isReplace() {
            return false;
        }

        public abstract MapOperation getOperation();

        public abstract void execute();
    }

    static enum MapOperation {
        CREATE,
        UPDATE,
        DELETE;

    }

    private class BulkDeleteOperation
    extends MapTaskWithValue {
        private final QueryParameters<M> queryParameters;

        public BulkDeleteOperation(QueryParameters<M> queryParameters) {
            super(ConcurrentHashMapKeycloakTransaction.this, null);
            this.queryParameters = queryParameters;
        }

        @Override
        public void execute() {
            ConcurrentHashMapKeycloakTransaction.this.map.delete(this.queryParameters);
        }

        public Predicate<V> getFilterForNonDeletedObjects() {
            DefaultModelCriteria mcb = this.queryParameters.getModelCriteriaBuilder();
            MapModelCriteriaBuilder mmcb = mcb.flashToModelCriteriaBuilder(ConcurrentHashMapKeycloakTransaction.this.createCriteriaBuilder());
            Predicate entityFilter = mmcb.getEntityFilter();
            Predicate keyFilter = mmcb.getKeyFilter();
            return v -> v == null || !keyFilter.test(ConcurrentHashMapKeycloakTransaction.this.keyConverter.fromStringSafe(v.getId())) || !entityFilter.test(v);
        }

        @Override
        public MapOperation getOperation() {
            return MapOperation.DELETE;
        }

        private long getCount() {
            return ConcurrentHashMapKeycloakTransaction.this.map.getCount(this.queryParameters);
        }
    }

    private static class CreateOperation
    extends MapTaskWithValue {
        final /* synthetic */ ConcurrentHashMapKeycloakTransaction this$0;

        public CreateOperation(V value) {
            this.this$0 = var1_1;
            super((ConcurrentHashMapKeycloakTransaction)var1_1, value);
        }

        @Override
        public void execute() {
            this.this$0.map.create(this.getValue());
        }

        @Override
        public MapOperation getOperation() {
            return MapOperation.CREATE;
        }
    }

    private class DeleteOperation
    extends MapTaskWithValue {
        private final String key;

        public DeleteOperation(String key) {
            super(ConcurrentHashMapKeycloakTransaction.this, null);
            this.key = key;
        }

        @Override
        public void execute() {
            ConcurrentHashMapKeycloakTransaction.this.map.delete(this.key);
        }

        @Override
        public MapOperation getOperation() {
            return MapOperation.DELETE;
        }
    }

    private class MapTaskCompose
    extends MapTaskWithValue {
        private final MapTaskWithValue oldValue;
        private final MapTaskWithValue newValue;

        public MapTaskCompose(MapTaskWithValue oldValue, MapTaskWithValue newValue) {
            super(ConcurrentHashMapKeycloakTransaction.this, null);
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void execute() {
            this.oldValue.execute();
            this.newValue.execute();
        }

        @Override
        public V getValue() {
            return this.newValue.getValue();
        }

        @Override
        public MapOperation getOperation() {
            return null;
        }

        @Override
        public boolean containsCreate() {
            return this.oldValue.containsCreate() || this.newValue.containsCreate();
        }

        @Override
        public boolean containsRemove() {
            return this.oldValue.containsRemove() || this.newValue.containsRemove();
        }

        @Override
        public boolean isReplace() {
            return this.newValue.getOperation() == MapOperation.CREATE && this.oldValue.containsRemove() || this.oldValue instanceof MapTaskCompose && ((MapTaskCompose)this.oldValue).isReplace();
        }
    }
}

