/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.AutogeneratedCloners;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.common.delegate.EntityFieldDelegate;

public class DeepCloner {
    public static final DeepCloner DUMB_CLONER = new Builder().build();
    private static final Logger LOG = Logger.getLogger(DeepCloner.class);
    private final Map<Class<?>, Function<DeepCloner, ?>> constructors;
    private final Map<Class<?>, Cloner<?>> clonersWithId;
    private final Map<Class<?>, Cloner<?>> clonersWithoutId;
    private final Map<Class<?>, DelegateCreator<?>> delegateCreators;
    private final Map<Class<?>, EntityFieldDelegateCreator<?>> entityFieldDelegateCreators;
    private final Cloner<?> genericCloner;
    private final Map<Class<?>, Object> emptyInstances = new HashMap(AutogeneratedCloners.EMPTY_INSTANCES);

    private DeepCloner(Map<Class<?>, Function<DeepCloner, ?>> constructors, Map<Class<?>, DelegateCreator<?>> delegateCreators, Map<Class<?>, EntityFieldDelegateCreator<?>> entityFieldDelegateCreators, Map<Class<?>, Cloner<?>> clonersWithId, Map<Class<?>, Cloner<?>> clonersWithoutId, Cloner<?> genericCloner) {
        this.constructors = constructors;
        this.clonersWithId = clonersWithId;
        this.clonersWithoutId = clonersWithoutId;
        this.delegateCreators = delegateCreators;
        this.genericCloner = genericCloner;
        this.entityFieldDelegateCreators = entityFieldDelegateCreators;
    }

    private <V> V getFromClassRespectingHierarchy(Map<Class<?>, V> map, Class<?> clazz) {
        V res = map.get(clazz);
        if (res != null) {
            return res;
        }
        LinkedList ll = new LinkedList();
        ll.push(clazz.getSuperclass());
        for (Class<?> iface : clazz.getInterfaces()) {
            ll.push(iface);
        }
        while (!ll.isEmpty()) {
            Class cl = (Class)ll.pollFirst();
            if (cl == null) continue;
            res = map.get(cl);
            if (res != null) {
                map.put(clazz, res);
                return res;
            }
            ll.push(cl.getSuperclass());
            ll.addAll(Arrays.asList(cl.getInterfaces()));
        }
        return null;
    }

    public <D, V extends D> D delegate(V delegate, DelegateProvider<D> delegateProvider) {
        return this.delegate(delegate.getClass(), delegateProvider);
    }

    public <D, V extends D> D delegate(Class<V> delegateClass, DelegateProvider<D> delegateProvider) {
        DelegateCreator<?> delegateCreator = this.getFromClassRespectingHierarchy(this.delegateCreators, delegateClass);
        if (delegateCreator != null) {
            return (D)delegateCreator.create(delegateProvider);
        }
        throw new IllegalStateException("Cannot create delegate for " + delegateClass);
    }

    public <V> V entityFieldDelegate(V delegate, EntityFieldDelegate<V> delegateProvider) {
        return (V)this.entityFieldDelegate(delegate.getClass(), delegateProvider);
    }

    public <V> V entityFieldDelegate(Class<V> delegateClass, EntityFieldDelegate<V> delegateProvider) {
        EntityFieldDelegateCreator<?> delegateCreator = this.getFromClassRespectingHierarchy(this.entityFieldDelegateCreators, delegateClass);
        if (delegateCreator != null) {
            return (V)delegateCreator.create(delegateProvider);
        }
        throw new IllegalStateException("Cannot create delegate for " + delegateClass);
    }

    public <V> V emptyInstance(Class<V> instanceClass) {
        Object emptyInstance = this.getFromClassRespectingHierarchy(this.emptyInstances, instanceClass);
        if (emptyInstance != null) {
            return (V)emptyInstance;
        }
        throw new IllegalStateException("Cannot create empty instance for " + instanceClass);
    }

    public <V> V newInstance(Class<V> clazz) {
        Object res;
        if (clazz == null) {
            return null;
        }
        Function<DeepCloner, ?> c = this.getFromClassRespectingHierarchy(this.constructors, clazz);
        if (c == null) {
            try {
                res = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                res = null;
            }
        } else {
            res = c.apply(this);
        }
        if (res == null) {
            throw new IllegalStateException("Cannot instantiate " + clazz);
        }
        return res;
    }

    public <V> Class<? extends V> newInstanceType(Class<V> valueType) {
        if (valueType == null) {
            return null;
        }
        try {
            V v = this.newInstance(valueType);
            return v == null ? null : v.getClass();
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    public <V> V deepClone(V from, V to) {
        return this.deepClone(from, to, this.clonersWithId);
    }

    public <V> V deepCloneNoId(V from, V to) {
        return this.deepClone(from, to, this.clonersWithoutId);
    }

    private <V> V deepClone(V from, V to, Map<Class<?>, Cloner<?>> cloners) {
        Cloner<?> cloner = this.getFromClassRespectingHierarchy(cloners, from.getClass());
        if (cloner != null) {
            return (V)cloner.clone(from, to);
        }
        if (this.genericCloner != null) {
            LOG.debugf("Using generic cloner for %s", from.getClass());
            Object res = this.genericCloner.clone(from, to);
            if (res instanceof UpdatableEntity) {
                ((UpdatableEntity)res).clearUpdatedFlag();
            }
            return (V)res;
        }
        return DeepCloner.warnCloneNotSupported(from);
    }

    public <V extends AbstractEntity> V from(String newId, V from) {
        if (from == null) {
            return null;
        }
        AbstractEntity res = (AbstractEntity)this.newInstance(from.getClass());
        if (newId != null) {
            res.setId(newId);
        }
        return (V)this.deepCloneNoId(from, res);
    }

    public <V> V from(V from) {
        return from == null ? null : (V)this.deepClone(from, this.newInstance(from.getClass()));
    }

    public static <T> T warnCloneNotSupported(T o) {
        if (o != null) {
            LOG.warnf("Cloning not supported for %s, returning the same instance!", o.getClass());
        }
        return o;
    }

    @FunctionalInterface
    public static interface Cloner<V> {
        public V clone(V var1, V var2);
    }

    @FunctionalInterface
    public static interface DelegateCreator<V> {
        public V create(DelegateProvider<V> var1);
    }

    @FunctionalInterface
    public static interface EntityFieldDelegateCreator<V> {
        public V create(EntityFieldDelegate<V> var1);
    }

    public static class Builder {
        private final Map<Class<?>, Function<DeepCloner, ?>> constructors = new HashMap();
        private final Map<Class<?>, Cloner<?>> clonersWithId = new HashMap(AutogeneratedCloners.CLONERS_WITH_ID);
        private final Map<Class<?>, Cloner<?>> clonersWithoutId = new HashMap(AutogeneratedCloners.CLONERS_WITHOUT_ID);
        private final Map<Class<?>, DelegateCreator<?>> delegateCreators = new HashMap(AutogeneratedCloners.DELEGATE_CREATORS);
        private final Map<Class<?>, EntityFieldDelegateCreator<?>> entityFieldDelegateCreators = new HashMap(AutogeneratedCloners.ENTITY_FIELD_DELEGATE_CREATORS);
        private Cloner<?> genericCloner = (from, to) -> {
            throw new IllegalStateException("Cloner not found for class " + (from == null ? "<null>" : from.getClass()));
        };

        public DeepCloner build() {
            return new DeepCloner(this.constructors, this.delegateCreators, this.entityFieldDelegateCreators, this.clonersWithId, this.clonersWithoutId, this.genericCloner);
        }

        private <V> void forThisClassAndAllMarkedParentsAndInterfaces(Class<V> rootClazz, Consumer<Class<?>> action) {
            action.accept(rootClazz);
            Stack c = new Stack();
            c.push(rootClazz);
            while (!c.isEmpty()) {
                Class cl = (Class)c.pop();
                if (cl == null) continue;
                c.push(cl.getSuperclass());
                for (Class<?> iface : cl.getInterfaces()) {
                    c.push(iface);
                }
                if (cl.getAnnotation(Root.class) == null) continue;
                action.accept(cl);
            }
        }

        public <V> Builder constructor(Class<V> clazz, Function<DeepCloner, ? extends V> constructor) {
            if (constructor != null) {
                this.forThisClassAndAllMarkedParentsAndInterfaces(clazz, cl -> this.constructors.put((Class<?>)cl, constructor));
            }
            return this;
        }

        public <V> Builder delegateCreator(Class<V> clazz, EntityFieldDelegateCreator<V> delegateCreator) {
            if (delegateCreator != null) {
                this.forThisClassAndAllMarkedParentsAndInterfaces(clazz, cl -> this.entityFieldDelegateCreators.put((Class<?>)cl, delegateCreator));
            }
            return this;
        }

        public <V> Builder delegateCreator(Class<V> clazz, DelegateCreator<V> delegateCreator) {
            if (delegateCreator != null) {
                this.forThisClassAndAllMarkedParentsAndInterfaces(clazz, cl -> this.delegateCreators.put((Class<?>)cl, delegateCreator));
            }
            return this;
        }

        public <V> Builder cloner(Class<? extends V> clazz, Cloner<?> cloner) {
            if (cloner != null) {
                this.forThisClassAndAllMarkedParentsAndInterfaces(clazz, cl -> this.clonersWithId.put((Class<?>)cl, cloner));
            }
            return this;
        }

        public <V> Builder cloner(Class<? extends V> clazz, Cloner<?> clonerWithId, Cloner<?> clonerWithoutId) {
            if (clonerWithId != null) {
                this.forThisClassAndAllMarkedParentsAndInterfaces(clazz, cl -> this.clonersWithId.put((Class<?>)cl, clonerWithId));
            }
            if (clonerWithoutId != null) {
                this.forThisClassAndAllMarkedParentsAndInterfaces(clazz, cl -> this.clonersWithoutId.put((Class<?>)cl, clonerWithoutId));
            }
            return this;
        }

        public <V> Builder genericCloner(Cloner<V> genericCloner) {
            this.genericCloner = genericCloner;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Root {
    }
}

