/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.EventImpl;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.arc.impl.Scopes;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.logging.Logger;

class RequestContext
implements ManagedContext {
    private static final Logger LOG = Logger.getLogger((String)"io.quarkus.arc.requestContext");
    private final CurrentContext<RequestContextState> currentContext;
    private final LazyValue<EventImpl.Notifier<Object>> initializedNotifier;
    private final LazyValue<EventImpl.Notifier<Object>> beforeDestroyedNotifier;
    private final LazyValue<EventImpl.Notifier<Object>> destroyedNotifier;

    public RequestContext(CurrentContext<RequestContextState> currentContext) {
        this.currentContext = currentContext;
        this.initializedNotifier = new LazyValue<EventImpl.Notifier>(RequestContext::createInitializedNotifier);
        this.beforeDestroyedNotifier = new LazyValue<EventImpl.Notifier>(RequestContext::createBeforeDestroyedNotifier);
        this.destroyedNotifier = new LazyValue<EventImpl.Notifier>(RequestContext::createDestroyedNotifier);
    }

    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    public <T> T getIfActive(Contextual<T> contextual, Function<Contextual<T>, CreationalContext<T>> creationalContextFun) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        Objects.requireNonNull(creationalContextFun, "CreationalContext supplier must not be null");
        InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        RequestContextState ctxState = this.currentContext.get();
        if (ctxState == null) {
            return null;
        }
        ContextInstanceHandle<?> instance = ctxState.map.get(contextual);
        if (instance == null) {
            CreationalContext<T> creationalContext = creationalContextFun.apply(contextual);
            instance = new ContextInstanceHandleImpl<Object>((InjectableBean)contextual, contextual.create(creationalContext), creationalContext);
            ctxState.map.put(contextual, instance);
        }
        return instance.get();
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T result = this.getIfActive(contextual, CreationalContextImpl.unwrap(Objects.requireNonNull(creationalContext, "CreationalContext must not be null")));
        if (result == null) {
            throw this.notActive();
        }
        return result;
    }

    public <T> T get(Contextual<T> contextual) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        RequestContextState state = this.currentContext.get();
        if (state == null) {
            throw this.notActive();
        }
        ContextInstanceHandle<?> instance = state.map.get(contextual);
        return instance == null ? null : (T)instance.get();
    }

    public boolean isActive() {
        return this.currentContext.get() != null;
    }

    public void destroy(Contextual<?> contextual) {
        RequestContextState state = this.currentContext.get();
        if (state == null) {
            throw this.notActive();
        }
        ContextInstanceHandle<?> instance = state.map.remove(contextual);
        if (instance != null) {
            instance.destroy();
        }
    }

    @Override
    public void activate(InjectableContext.ContextState initialState) {
        if (LOG.isTraceEnabled()) {
            String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
            LOG.tracef("Activate %s %s\n\t...", (Object)(initialState != null ? Integer.toHexString(initialState.hashCode()) : "new"), (Object)stack);
        }
        if (initialState == null) {
            this.currentContext.set(new RequestContextState(new ConcurrentHashMap()));
            this.fireIfNotEmpty(this.initializedNotifier);
        } else if (initialState instanceof RequestContextState) {
            this.currentContext.set((RequestContextState)initialState);
        } else {
            throw new IllegalArgumentException("Invalid initial state: " + initialState.getClass().getName());
        }
    }

    @Override
    public InjectableContext.ContextState getState() {
        RequestContextState state = this.currentContext.get();
        if (state == null) {
            throw this.notActive();
        }
        return state;
    }

    @Override
    public InjectableContext.ContextState getStateIfActive() {
        return this.currentContext.get();
    }

    @Override
    public void deactivate() {
        if (LOG.isTraceEnabled()) {
            String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
            LOG.tracef("Deactivate%s\n\t...", (Object)stack);
        }
        this.currentContext.remove();
    }

    @Override
    public void destroy() {
        this.destroy(this.currentContext.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(InjectableContext.ContextState state) {
        if (LOG.isTraceEnabled()) {
            String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
            LOG.tracef("Destroy %s%s\n\t...", (Object)(state != null ? Integer.toHexString(state.hashCode()) : ""), (Object)stack);
        }
        if (state == null) {
            return;
        }
        if (state instanceof RequestContextState) {
            RequestContextState reqState = (RequestContextState)state;
            reqState.isValid = false;
            InjectableContext.ContextState contextState = state;
            synchronized (contextState) {
                Map<Contextual<?>, ContextInstanceHandle<?>> map = ((RequestContextState)state).map;
                try {
                    this.fireIfNotEmpty(this.beforeDestroyedNotifier);
                }
                catch (Exception e) {
                    LOG.warn((Object)"An error occurred during delivery of the @BeforeDestroyed(RequestScoped.class) event", (Throwable)e);
                }
                map.forEach(this::destroyContextElement);
                try {
                    this.fireIfNotEmpty(this.destroyedNotifier);
                }
                catch (Exception e) {
                    LOG.warn((Object)"An error occurred during delivery of the @Destroyed(RequestScoped.class) event", (Throwable)e);
                }
                map.clear();
            }
        }
        throw new IllegalArgumentException("Invalid state implementation: " + state.getClass().getName());
    }

    private void destroyContextElement(Contextual<?> contextual, ContextInstanceHandle<?> contextInstanceHandle) {
        try {
            contextInstanceHandle.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to destroy instance" + contextInstanceHandle.get(), e);
        }
    }

    private void fireIfNotEmpty(LazyValue<EventImpl.Notifier<Object>> value) {
        EventImpl.Notifier<Object> notifier = value.get();
        if (!notifier.isEmpty()) {
            notifier.notify(this.toString());
        }
    }

    private ContextNotActiveException notActive() {
        String msg = "Request context is not active - you can activate the request context for a specific method using the @ActivateRequestContext interceptor binding";
        return new ContextNotActiveException(msg);
    }

    private static EventImpl.Notifier<Object> createInitializedNotifier() {
        return EventImpl.createNotifier(Object.class, Object.class, new HashSet<AnnotationLiteral>(Arrays.asList(Initialized.Literal.REQUEST, Any.Literal.INSTANCE)), ArcContainerImpl.instance(), false);
    }

    private static EventImpl.Notifier<Object> createBeforeDestroyedNotifier() {
        return EventImpl.createNotifier(Object.class, Object.class, new HashSet<AnnotationLiteral>(Arrays.asList(BeforeDestroyed.Literal.REQUEST, Any.Literal.INSTANCE)), ArcContainerImpl.instance(), false);
    }

    private static EventImpl.Notifier<Object> createDestroyedNotifier() {
        return EventImpl.createNotifier(Object.class, Object.class, new HashSet<AnnotationLiteral>(Arrays.asList(Destroyed.Literal.REQUEST, Any.Literal.INSTANCE)), ArcContainerImpl.instance(), false);
    }

    static class RequestContextState
    implements InjectableContext.ContextState {
        private final Map<Contextual<?>, ContextInstanceHandle<?>> map;
        private volatile boolean isValid;

        RequestContextState(ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>> value) {
            this.map = Objects.requireNonNull(value);
            this.isValid = true;
        }

        @Override
        public Map<InjectableBean<?>, Object> getContextualInstances() {
            return this.map.values().stream().collect(Collectors.toUnmodifiableMap(InstanceHandle::getBean, InstanceHandle::get));
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }
    }
}

