/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.Token;
import org.keycloak.common.util.Encode;
import org.keycloak.common.util.HtmlUtils;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.representations.AuthorizationResponseToken;
import org.keycloak.services.Urls;

public abstract class OIDCRedirectUriBuilder {
    protected final KeycloakUriBuilder uriBuilder;

    protected OIDCRedirectUriBuilder(KeycloakUriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
    }

    public abstract OIDCRedirectUriBuilder addParam(String var1, String var2);

    public abstract Response build();

    public static OIDCRedirectUriBuilder fromUri(String baseUri, OIDCResponseMode responseMode, KeycloakSession session, AuthenticatedClientSessionModel clientSession) {
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)baseUri);
        switch (responseMode) {
            case QUERY: {
                return new QueryRedirectUriBuilder(uriBuilder);
            }
            case FRAGMENT: {
                return new FragmentRedirectUriBuilder(uriBuilder);
            }
            case FORM_POST: {
                return new FormPostRedirectUriBuilder(uriBuilder);
            }
            case QUERY_JWT: 
            case FRAGMENT_JWT: 
            case FORM_POST_JWT: {
                return new JWTRedirectUriBuilder(uriBuilder, responseMode, session, clientSession);
            }
        }
        throw new IllegalStateException("Not possible to end here");
    }

    private static class QueryRedirectUriBuilder
    extends OIDCRedirectUriBuilder {
        protected QueryRedirectUriBuilder(KeycloakUriBuilder uriBuilder) {
            super(uriBuilder);
        }

        @Override
        public OIDCRedirectUriBuilder addParam(String paramName, String paramValue) {
            this.uriBuilder.queryParam(paramName, new Object[]{paramValue});
            return this;
        }

        @Override
        public Response build() {
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            Response.ResponseBuilder location = Response.status((int)302).location(redirectUri);
            return location.build();
        }
    }

    private static class FragmentRedirectUriBuilder
    extends OIDCRedirectUriBuilder {
        private StringBuilder fragment;

        protected FragmentRedirectUriBuilder(KeycloakUriBuilder uriBuilder) {
            super(uriBuilder);
            String fragment = uriBuilder.getFragment();
            if (fragment != null) {
                this.fragment = new StringBuilder(fragment);
            }
        }

        @Override
        public OIDCRedirectUriBuilder addParam(String paramName, String paramValue) {
            String param = paramName + "=" + Encode.encodeQueryParamAsIs((String)paramValue);
            if (this.fragment == null) {
                this.fragment = new StringBuilder(param);
            } else {
                this.fragment.append("&").append(param);
            }
            return this;
        }

        @Override
        public Response build() {
            if (this.fragment != null) {
                this.uriBuilder.encodedFragment(this.fragment.toString());
            }
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            Response.ResponseBuilder location = Response.status((int)302).location(redirectUri);
            return location.build();
        }
    }

    private static class FormPostRedirectUriBuilder
    extends OIDCRedirectUriBuilder {
        private Map<String, String> params = new HashMap<String, String>();

        protected FormPostRedirectUriBuilder(KeycloakUriBuilder uriBuilder) {
            super(uriBuilder);
        }

        @Override
        public OIDCRedirectUriBuilder addParam(String paramName, String paramValue) {
            this.params.put(paramName, paramValue);
            return this;
        }

        @Override
        public Response build() {
            StringBuilder builder = new StringBuilder();
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            builder.append("<HTML>");
            builder.append("  <HEAD>");
            builder.append("    <TITLE>OIDC Form_Post Response</TITLE>");
            builder.append("  </HEAD>");
            builder.append("  <BODY Onload=\"document.forms[0].submit()\">");
            builder.append("    <FORM METHOD=\"POST\" ACTION=\"" + redirectUri.toString() + "\">");
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                builder.append("  <INPUT TYPE=\"HIDDEN\" NAME=\"").append(param.getKey()).append("\" VALUE=\"").append(HtmlUtils.escapeAttribute((String)param.getValue())).append("\" />");
            }
            builder.append("      <NOSCRIPT>");
            builder.append("        <P>JavaScript is disabled. We strongly recommend to enable it. Click the button below to continue .</P>");
            builder.append("        <INPUT name=\"continue\" TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
            builder.append("      </NOSCRIPT>");
            builder.append("    </FORM>");
            builder.append("  </BODY>");
            builder.append("</HTML>");
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.TEXT_HTML_TYPE).entity((Object)builder.toString()).build();
        }
    }

    private static class JWTRedirectUriBuilder
    extends OIDCRedirectUriBuilder {
        private final OIDCResponseMode responseMode;
        private final AuthorizationResponseToken responseJWT;
        private final KeycloakSession session;
        private final AuthenticatedClientSessionModel clientSession;

        public JWTRedirectUriBuilder(KeycloakUriBuilder uriBuilder, OIDCResponseMode responseMode, KeycloakSession session, AuthenticatedClientSessionModel clientSession) {
            super(uriBuilder);
            this.responseMode = responseMode;
            this.session = session;
            this.clientSession = clientSession;
            this.responseJWT = new AuthorizationResponseToken();
        }

        @Override
        public OIDCRedirectUriBuilder addParam(String paramName, String paramValue) {
            this.responseJWT.getOtherClaims().put(paramName, paramValue);
            return this;
        }

        @Override
        public Response build() {
            KeycloakContext context = this.session.getContext();
            ClientModel client = context.getClient();
            RealmModel realm = client.getRealm();
            this.responseJWT.issuer(Urls.realmIssuer(context.getUri().getBaseUri(), realm.getName()));
            this.responseJWT.audience(new String[]{client.getClientId()});
            this.responseJWT.exp(Long.valueOf(Time.currentTime() + realm.getAccessCodeLifespan()));
            if (this.clientSession != null) {
                this.responseJWT.issuer(this.clientSession.getNote("iss"));
                String responseType = this.clientSession.getNote("response_type");
                if ("token".equals(responseType)) {
                    this.responseJWT.setOtherClaims("scope", (Object)this.clientSession.getNote("scope"));
                }
            }
            switch (this.responseMode) {
                case QUERY_JWT: {
                    return this.buildQueryResponse();
                }
                case FRAGMENT_JWT: {
                    return this.buildFragmentResponse();
                }
                case FORM_POST_JWT: {
                    return this.buildFormPostResponse();
                }
            }
            throw new IllegalStateException("Not possible to end here");
        }

        private Response buildQueryResponse() {
            this.uriBuilder.queryParam("response", new Object[]{this.session.tokens().encodeAndEncrypt((Token)this.responseJWT)});
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            Response.ResponseBuilder location = Response.status((int)302).location(redirectUri);
            return location.build();
        }

        private Response buildFragmentResponse() {
            this.uriBuilder.encodedFragment("response=" + Encode.encodeQueryParamAsIs((String)this.session.tokens().encodeAndEncrypt((Token)this.responseJWT)));
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            Response.ResponseBuilder location = Response.status((int)302).location(redirectUri);
            return location.build();
        }

        private Response buildFormPostResponse() {
            StringBuilder builder = new StringBuilder();
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            builder.append("<HTML>");
            builder.append("  <HEAD>");
            builder.append("    <TITLE>OIDC Form_Post Response</TITLE>");
            builder.append("  </HEAD>");
            builder.append("  <BODY Onload=\"document.forms[0].submit()\">");
            builder.append("    <FORM METHOD=\"POST\" ACTION=\"" + redirectUri.toString() + "\">");
            builder.append("  <INPUT TYPE=\"HIDDEN\" NAME=\"response\" VALUE=\"").append(HtmlUtils.escapeAttribute((String)this.session.tokens().encodeAndEncrypt((Token)this.responseJWT))).append("\" />");
            builder.append("      <NOSCRIPT>");
            builder.append("        <P>JavaScript is disabled. We strongly recommend to enable it. Click the button below to continue .</P>");
            builder.append("        <INPUT name=\"continue\" TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
            builder.append("      </NOSCRIPT>");
            builder.append("    </FORM>");
            builder.append("  </BODY>");
            builder.append("</HTML>");
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.TEXT_HTML_TYPE).entity((Object)builder.toString()).build();
        }
    }
}

