/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.globalstate.impl.GlobalConfigurationManagerImpl;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;

@Listener(observation=Listener.Observation.BOTH)
public class GlobalConfigurationStateListener {
    private final GlobalConfigurationManagerImpl gcm;

    GlobalConfigurationStateListener(GlobalConfigurationManagerImpl gcm) {
        this.gcm = gcm;
    }

    @CacheEntryCreated
    public CompletionStage<Void> handleCreate(CacheEntryCreatedEvent<ScopedState, CacheState> event) {
        if (event.isPre()) {
            return CompletableFutures.completedNull();
        }
        String scope = ((ScopedState)event.getKey()).getScope();
        if (!GlobalConfigurationManagerImpl.isKnownScope(scope)) {
            return CompletableFutures.completedNull();
        }
        String name = ((ScopedState)event.getKey()).getName();
        CacheState state = event.getValue();
        return "cache".equals(scope) ? this.gcm.createCacheLocally(name, state) : this.gcm.createTemplateLocally(name, state);
    }

    @CacheEntryModified
    public CompletionStage<Void> handleUpdate(CacheEntryModifiedEvent<ScopedState, CacheState> event) {
        String scope = ((ScopedState)event.getKey()).getScope();
        if (!GlobalConfigurationManagerImpl.isKnownScope(scope)) {
            return CompletableFutures.completedNull();
        }
        String name = ((ScopedState)event.getKey()).getName();
        CacheState state = event.getNewValue();
        if (event.isPre()) {
            return event.isOriginLocal() ? this.gcm.validateConfigurationUpdateLocally(name, state) : CompletableFutures.completedNull();
        }
        return this.gcm.updateConfigurationLocally(name, state);
    }

    @CacheEntryRemoved
    public CompletionStage<Void> handleRemove(CacheEntryRemovedEvent<ScopedState, CacheState> event) {
        if (event.isPre()) {
            return CompletableFutures.completedNull();
        }
        String scope = ((ScopedState)event.getKey()).getScope();
        if (!GlobalConfigurationManagerImpl.isKnownScope(scope)) {
            return CompletableFutures.completedNull();
        }
        String name = ((ScopedState)event.getKey()).getName();
        if ("cache".equals(scope)) {
            Log.CONTAINER.debugf("Stopping cache %s because it was removed from global state", name);
            return this.gcm.removeCacheLocally(name);
        }
        Log.CONTAINER.debugf("Removing template %s because it was removed from global state", name);
        return this.gcm.removeTemplateLocally(name);
    }
}

