/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.device.DeviceActivityManager;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntityImpl;
import org.keycloak.models.map.userSession.MapUserSessionAdapter;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntityImpl;
import org.keycloak.models.map.userSession.SessionExpiration;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapUserSessionProvider
implements UserSessionProvider {
    private static final Logger LOG = Logger.getLogger(MapUserSessionProvider.class);
    private final KeycloakSession session;
    protected final MapKeycloakTransaction<MapUserSessionEntity, UserSessionModel> userSessionTx;
    private final Map<String, MapUserSessionEntity> transientUserSessions = new HashMap<String, MapUserSessionEntity>();

    public MapUserSessionProvider(KeycloakSession session, MapStorage<MapUserSessionEntity, UserSessionModel> userSessionStore) {
        this.session = session;
        this.userSessionTx = userSessionStore.createTransaction(session);
        session.getTransactionManager().enlistAfterCompletion(this.userSessionTx);
    }

    private Function<MapUserSessionEntity, UserSessionModel> userEntityToAdapterFunc(RealmModel realm) {
        return origEntity -> {
            if (origEntity == null) {
                return null;
            }
            if (ExpirationUtils.isExpired(origEntity, false)) {
                if (UserSessionModel.SessionPersistenceState.TRANSIENT == origEntity.getPersistenceState()) {
                    this.transientUserSessions.remove(origEntity.getId());
                } else {
                    this.userSessionTx.delete(origEntity.getId());
                }
                return null;
            }
            return new MapUserSessionAdapter(this.session, realm, (MapUserSessionEntity)origEntity);
        };
    }

    public KeycloakSession getKeycloakSession() {
        return this.session;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        MapAuthenticatedClientSessionEntity entity;
        LOG.tracef("createClientSession(%s, %s, %s)%s", new Object[]{realm, client, userSession, StackUtil.getShortStackTrace()});
        MapUserSessionEntity userSessionEntity = this.getUserSessionById(userSession.getId());
        if (userSessionEntity == null) {
            throw new IllegalStateException("User session entity does not exist: " + userSession.getId());
        }
        if (userSessionEntity.getAuthenticatedClientSession(client.getId()).isPresent()) {
            userSessionEntity.removeAuthenticatedClientSession(client.getId());
        }
        String started = (entity = this.createAuthenticatedClientSessionEntityInstance(null, userSession.getId(), realm.getId(), client.getId(), false)).getTimestamp() != null ? String.valueOf(TimeAdapter.fromMilliSecondsToSeconds(entity.getTimestamp())) : String.valueOf(0);
        entity.setNote("startedAt", started);
        SessionExpiration.setClientSessionExpiration(entity, realm, client);
        userSessionEntity.addAuthenticatedClientSession(entity);
        UserSessionModel userSessionModel = this.userEntityToAdapterFunc(realm).apply(userSessionEntity);
        return userSessionModel == null ? null : userSessionModel.getAuthenticatedClientSessionByClient(client.getId());
    }

    public AuthenticatedClientSessionModel getClientSession(UserSessionModel userSession, ClientModel client, String clientSessionId, boolean offline) {
        LOG.tracef("getClientSession(%s, %s, %s, %s)%s", new Object[]{userSession, client, clientSessionId, offline, StackUtil.getShortStackTrace()});
        return userSession.getAuthenticatedClientSessionByClient(client.getId());
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        return this.createUserSession(null, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId, UserSessionModel.SessionPersistenceState.PERSISTENT);
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, UserSessionModel.SessionPersistenceState persistenceState) {
        LOG.tracef("createUserSession(%s, %s, %s, %s)%s", new Object[]{id, realm, loginUsername, persistenceState, StackUtil.getShortStackTrace()});
        MapUserSessionEntity entity = this.createUserSessionEntityInstance(id, realm.getId(), user.getId(), loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId, false);
        if (UserSessionModel.SessionPersistenceState.TRANSIENT == persistenceState) {
            if (id == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.transientUserSessions.put(entity.getId(), entity);
        } else {
            if (id != null && this.userSessionTx.read(id) != null) {
                throw new ModelDuplicateException("User session exists: " + id);
            }
            entity = this.userSessionTx.create(entity);
        }
        entity.setPersistenceState(persistenceState);
        SessionExpiration.setUserSessionExpiration(entity, realm);
        UserSessionModel userSession = this.userEntityToAdapterFunc(realm).apply(entity);
        if (userSession != null) {
            DeviceActivityManager.attachDevice((UserSessionModel)userSession, (KeycloakSession)this.session);
        }
        return userSession;
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        LOG.tracef("getUserSession(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        if (id == null) {
            return null;
        }
        MapUserSessionEntity userSessionEntity = this.transientUserSessions.get(id);
        if (userSessionEntity != null) {
            return this.userEntityToAdapterFunc(realm).apply(userSessionEntity);
        }
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare(UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id});
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).findFirst().map(this.userEntityToAdapterFunc(realm)).orElse(null);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserModel user) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare(UserSessionModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{user.getId()});
        LOG.tracef("getUserSessionsStream(%s, %s)%s", (Object)realm, (Object)user, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare(UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        LOG.tracef("getUserSessionsStream(%s, %s)%s", (Object)realm, (Object)client, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        LOG.tracef("getUserSessionsStream(%s, %s, %s, %s)%s", new Object[]{realm, client, firstResult, maxResults, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare(UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, UserSessionModel.SearchableFields.LAST_SESSION_REFRESH)).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare(UserSessionModel.SearchableFields.BROKER_USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{brokerUserId});
        LOG.tracef("getUserSessionByBrokerUserIdStream(%s, %s)%s", (Object)realm, (Object)brokerUserId, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare(UserSessionModel.SearchableFields.BROKER_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{brokerSessionId});
        LOG.tracef("getUserSessionByBrokerSessionId(%s, %s)%s", (Object)realm, (Object)brokerSessionId, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).findFirst().map(this.userEntityToAdapterFunc(realm)).orElse(null);
    }

    public UserSessionModel getUserSessionWithPredicate(RealmModel realm, String id, boolean offline, Predicate<UserSessionModel> predicate) {
        UserSessionModel userSession;
        LOG.tracef("getUserSessionWithPredicate(%s, %s, %s)%s", new Object[]{realm, id, offline, StackUtil.getShortStackTrace()});
        Stream<Object> userSessionEntityStream = offline ? this.getOfflineUserSessionEntityStream(realm, id).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull) : ((userSession = this.getUserSession(realm, id)) != null ? Stream.of(userSession) : Stream.empty());
        return userSessionEntityStream.filter(predicate).findFirst().orElse(null);
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare(UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        LOG.tracef("getActiveUserSessions(%s, %s)%s", (Object)realm, (Object)client, StackUtil.getShortStackTrace());
        return this.userSessionTx.getCount(QueryParameters.withCriteria(mcb));
    }

    public Map<String, Long> getActiveClientSessionStats(RealmModel realm, boolean offline) {
        DefaultModelCriteria<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, offline);
        LOG.tracef("getActiveClientSessionStats(%s, %s)%s", (Object)realm, (Object)offline, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull).map(UserSessionModel::getAuthenticatedClientSessions).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        Objects.requireNonNull(session, "The provided user session can't be null!");
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare(UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{session.getId()});
        LOG.tracef("removeUserSession(%s, %s)%s", (Object)realm, (Object)session, StackUtil.getShortStackTrace());
        this.userSessionTx.delete(QueryParameters.withCriteria(mcb));
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserSessionModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{user.getId()});
        LOG.tracef("removeUserSessions(%s, %s)%s", (Object)realm, (Object)user, StackUtil.getShortStackTrace());
        this.userSessionTx.delete(QueryParameters.withCriteria(mcb));
    }

    public void removeAllExpired() {
        LOG.tracef("removeAllExpired()%s", StackUtil.getShortStackTrace());
    }

    public void removeExpired(RealmModel realm) {
        LOG.tracef("removeExpired(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
    }

    public void removeUserSessions(RealmModel realm) {
        DefaultModelCriteria<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false);
        LOG.tracef("removeUserSessions(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.userSessionTx.delete(QueryParameters.withCriteria(mcb));
    }

    public void onRealmRemoved(RealmModel realm) {
        LOG.tracef("onRealmRemoved(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        LOG.tracef("createOfflineUserSession(%s)%s", (Object)userSession, StackUtil.getShortStackTrace());
        MapUserSessionEntity offlineUserSession = this.createUserSessionEntityInstance(userSession, true);
        offlineUserSession = this.userSessionTx.create(offlineUserSession);
        userSession.setNote("correspondingSessionId", offlineUserSession.getId());
        long currentTime = Time.currentTimeMillis();
        offlineUserSession.setTimestamp(currentTime);
        offlineUserSession.setLastSessionRefresh(currentTime);
        SessionExpiration.setUserSessionExpiration(offlineUserSession, userSession.getRealm());
        return this.userEntityToAdapterFunc(userSession.getRealm()).apply(offlineUserSession);
    }

    public UserSessionModel getOfflineUserSession(RealmModel realm, String userSessionId) {
        LOG.tracef("getOfflineUserSession(%s, %s)%s", (Object)realm, (Object)userSessionId, StackUtil.getShortStackTrace());
        return this.getOfflineUserSessionEntityStream(realm, userSessionId).findFirst().map(this.userEntityToAdapterFunc(realm)).orElse(null);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        Objects.requireNonNull(userSession, "The provided user session can't be null!");
        LOG.tracef("removeOfflineUserSession(%s, %s)%s", (Object)realm, (Object)userSession, StackUtil.getShortStackTrace());
        if (userSession.isOffline()) {
            this.userSessionTx.delete(userSession.getId());
        } else if (userSession.getNote("correspondingSessionId") != null) {
            String uk = userSession.getNote("correspondingSessionId");
            ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare(UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{uk});
            this.userSessionTx.delete(QueryParameters.withCriteria(mcb));
            userSession.removeNote("correspondingSessionId");
        }
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        LOG.tracef("createOfflineClientSession(%s, %s)%s", (Object)clientSession, (Object)offlineUserSession, StackUtil.getShortStackTrace());
        MapAuthenticatedClientSessionEntity clientSessionEntity = this.createAuthenticatedClientSessionInstance(clientSession, offlineUserSession, true);
        int currentTime = Time.currentTime();
        clientSessionEntity.setNote("startedAt", String.valueOf(currentTime));
        clientSessionEntity.setTimestamp(Time.currentTimeMillis());
        RealmModel realm = clientSession.getRealm();
        SessionExpiration.setClientSessionExpiration(clientSessionEntity, realm, clientSession.getClient());
        Optional<MapUserSessionEntity> userSessionEntity = this.getOfflineUserSessionEntityStream(realm, offlineUserSession.getId()).findFirst();
        if (userSessionEntity.isPresent()) {
            String clientId;
            MapUserSessionEntity userSession = userSessionEntity.get();
            if (userSession.getAuthenticatedClientSession(clientId = clientSession.getClient().getId()).isPresent()) {
                userSession.removeAuthenticatedClientSession(clientId);
            }
            userSession.addAuthenticatedClientSession(clientSessionEntity);
            UserSessionModel userSessionModel = this.userEntityToAdapterFunc(realm).apply(userSession);
            return userSessionModel == null ? null : userSessionModel.getAuthenticatedClientSessionByClient(clientId);
        }
        return null;
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, UserModel user) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare(UserSessionModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{user.getId()});
        LOG.tracef("getOfflineUserSessionsStream(%s, %s)%s", (Object)realm, (Object)user, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public UserSessionModel getOfflineUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare(UserSessionModel.SearchableFields.BROKER_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{brokerSessionId});
        LOG.tracef("getOfflineUserSessionByBrokerSessionId(%s, %s)%s", (Object)realm, (Object)brokerSessionId, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).findFirst().map(this.userEntityToAdapterFunc(realm)).orElse(null);
    }

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare(UserSessionModel.SearchableFields.BROKER_USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{brokerUserId});
        LOG.tracef("getOfflineUserSessionByBrokerUserIdStream(%s, %s)%s", (Object)realm, (Object)brokerUserId, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb)).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare(UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        LOG.tracef("getOfflineSessionsCount(%s, %s)%s", (Object)realm, (Object)client, StackUtil.getShortStackTrace());
        return this.userSessionTx.getCount(QueryParameters.withCriteria(mcb));
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        ModelCriteriaBuilder mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare(UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        LOG.tracef("getOfflineUserSessionsStream(%s, %s, %s, %s)%s", new Object[]{realm, client, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.userSessionTx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, UserSessionModel.SearchableFields.LAST_SESSION_REFRESH)).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public void importUserSessions(Collection<UserSessionModel> persistentUserSessions, boolean offline) {
        if (persistentUserSessions == null || persistentUserSessions.isEmpty()) {
            return;
        }
        persistentUserSessions.stream().map(pus -> {
            MapUserSessionEntity userSessionEntity = this.createUserSessionEntityInstance(null, pus.getRealm().getId(), pus.getUser().getId(), pus.getLoginUsername(), pus.getIpAddress(), pus.getAuthMethod(), pus.isRememberMe(), pus.getBrokerSessionId(), pus.getBrokerUserId(), offline);
            for (Map.Entry entry : pus.getAuthenticatedClientSessions().entrySet()) {
                MapAuthenticatedClientSessionEntity clientSession = this.createAuthenticatedClientSessionInstance((AuthenticatedClientSessionModel)entry.getValue(), ((AuthenticatedClientSessionModel)entry.getValue()).getUserSession(), offline);
                clientSession.setTimestamp(userSessionEntity.getLastSessionRefresh());
                userSessionEntity.addAuthenticatedClientSession(clientSession);
            }
            return userSessionEntity;
        }).forEach(this.userSessionTx::create);
    }

    public void close() {
    }

    public int getStartupTime(RealmModel realm) {
        return realm.getNotBefore();
    }

    protected void removeAllUserSessions(RealmModel realm) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(UserSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        LOG.tracef("removeAllUserSessions(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.userSessionTx.delete(QueryParameters.withCriteria(mcb));
    }

    private Stream<MapUserSessionEntity> getOfflineUserSessionEntityStream(RealmModel realm, String userSessionId) {
        if (userSessionId == null) {
            return Stream.empty();
        }
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        MapUserSessionEntity userSessionEntity = this.userSessionTx.read(QueryParameters.withCriteria(mcb = ((DefaultModelCriteria)mcb.compare(UserSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userSessionId}))).findFirst().orElse(null);
        if (userSessionEntity != null) {
            if (Boolean.TRUE.equals(userSessionEntity.isOffline())) {
                return Stream.of(userSessionEntity);
            }
        } else {
            mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare(UserSessionModel.SearchableFields.CORRESPONDING_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userSessionId});
            return this.userSessionTx.read(QueryParameters.withCriteria(mcb));
        }
        String offlineUserSessionId = userSessionEntity.getNote("correspondingSessionId");
        if (offlineUserSessionId != null) {
            mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare(UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{offlineUserSessionId});
            return this.userSessionTx.read(QueryParameters.withCriteria(mcb));
        }
        return Stream.empty();
    }

    private DefaultModelCriteria<UserSessionModel> realmAndOfflineCriteriaBuilder(RealmModel realm, boolean offline) {
        return ((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(UserSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserSessionModel.SearchableFields.IS_OFFLINE, ModelCriteriaBuilder.Operator.EQ, new Object[]{offline});
    }

    private MapUserSessionEntity getUserSessionById(String id) {
        if (id == null) {
            return null;
        }
        MapUserSessionEntity userSessionEntity = this.transientUserSessions.get(id);
        if (userSessionEntity == null) {
            MapUserSessionEntity userSession = this.userSessionTx.read(id);
            return userSession;
        }
        return userSessionEntity;
    }

    private MapUserSessionEntity createUserSessionEntityInstance(UserSessionModel userSession, boolean offline) {
        MapUserSessionEntity entity = this.createUserSessionEntityInstance(null, userSession.getRealm().getId(), userSession.getUser().getId(), userSession.getLoginUsername(), userSession.getIpAddress(), userSession.getAuthMethod(), userSession.isRememberMe(), userSession.getBrokerSessionId(), userSession.getBrokerUserId(), offline);
        entity.setNotes(new ConcurrentHashMap<String, String>(userSession.getNotes()));
        entity.setNote("correspondingSessionId", userSession.getId());
        entity.setState(userSession.getState());
        entity.setTimestamp(TimeAdapter.fromSecondsToMilliseconds(userSession.getStarted()));
        entity.setLastSessionRefresh(TimeAdapter.fromSecondsToMilliseconds(userSession.getLastSessionRefresh()));
        return entity;
    }

    private MapAuthenticatedClientSessionEntity createAuthenticatedClientSessionInstance(AuthenticatedClientSessionModel clientSession, UserSessionModel userSession, boolean offline) {
        MapAuthenticatedClientSessionEntity entity = this.createAuthenticatedClientSessionEntityInstance(null, userSession.getId(), clientSession.getRealm().getId(), clientSession.getClient().getId(), offline);
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(new ConcurrentHashMap<String, String>(clientSession.getNotes()));
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setTimestamp(TimeAdapter.fromSecondsToMilliseconds(clientSession.getTimestamp()));
        return entity;
    }

    private MapUserSessionEntity createUserSessionEntityInstance(String id, String realmId, String userId, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, boolean offline) {
        MapUserSessionEntityImpl userSessionEntity = new MapUserSessionEntityImpl();
        userSessionEntity.setId(id);
        userSessionEntity.setRealmId(realmId);
        userSessionEntity.setUserId(userId);
        userSessionEntity.setLoginUsername(loginUsername);
        userSessionEntity.setIpAddress(ipAddress);
        userSessionEntity.setAuthMethod(authMethod);
        userSessionEntity.setRememberMe(rememberMe);
        userSessionEntity.setBrokerSessionId(brokerSessionId);
        userSessionEntity.setBrokerUserId(brokerUserId);
        userSessionEntity.setOffline(offline);
        userSessionEntity.setTimestamp(Time.currentTimeMillis());
        userSessionEntity.setLastSessionRefresh(userSessionEntity.getTimestamp());
        return userSessionEntity;
    }

    private MapAuthenticatedClientSessionEntity createAuthenticatedClientSessionEntityInstance(String id, String userSessionId, String realmId, String clientId, boolean offline) {
        MapAuthenticatedClientSessionEntityImpl clientSessionEntity = new MapAuthenticatedClientSessionEntityImpl();
        clientSessionEntity.setId(id == null ? KeycloakModelUtils.generateId() : id);
        clientSessionEntity.setRealmId(realmId);
        clientSessionEntity.setClientId(clientId);
        clientSessionEntity.setOffline(offline);
        clientSessionEntity.setTimestamp(Time.currentTimeMillis());
        return clientSessionEntity;
    }
}

