/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.hibernate.listeners;

import java.util.Objects;
import javax.persistence.LockModeType;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.keycloak.models.map.storage.jpa.JpaChildEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;

public class JpaOptimisticLockingListener
implements PreInsertEventListener,
PreDeleteEventListener,
PreUpdateEventListener {
    public static final JpaOptimisticLockingListener INSTANCE = new JpaOptimisticLockingListener();

    public void lockRootEntity(Session session, Object entity) throws HibernateException {
        if (entity instanceof JpaChildEntity) {
            Object root = entity;
            while (root instanceof JpaChildEntity) {
                root = ((JpaChildEntity)entity).getParent();
                Objects.requireNonNull(root, "children must always return their parent, never null");
            }
            if (!(root instanceof JpaRootVersionedEntity)) {
                return;
            }
            if (session.contains(root)) {
                session.lock(root, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            }
        }
    }

    public boolean onPreInsert(PreInsertEvent event) {
        this.lockRootEntity((Session)event.getSession(), event.getEntity());
        return false;
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        this.lockRootEntity((Session)event.getSession(), event.getEntity());
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        this.lockRootEntity((Session)event.getSession(), event.getEntity());
        return false;
    }
}

