/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.jpa;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventType;
import org.keycloak.events.jpa.EventEntity;
import org.keycloak.events.jpa.JpaEventStoreProvider;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.utils.StreamsUtil;

public class JpaEventQuery
implements EventQuery {
    private final EntityManager em;
    private final CriteriaBuilder cb;
    private final CriteriaQuery<EventEntity> cq;
    private final Root<EventEntity> root;
    private final ArrayList<Predicate> predicates;
    private Integer firstResult;
    private Integer maxResults;

    public JpaEventQuery(EntityManager em) {
        this.em = em;
        this.cb = em.getCriteriaBuilder();
        this.cq = this.cb.createQuery(EventEntity.class);
        this.root = this.cq.from(EventEntity.class);
        this.predicates = new ArrayList(4);
    }

    public EventQuery type(EventType ... types) {
        LinkedList<String> eventStrings = new LinkedList<String>();
        for (EventType e : types) {
            eventStrings.add(e.toString());
        }
        this.predicates.add(this.root.get("type").in(eventStrings));
        return this;
    }

    public EventQuery realm(String realmId) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("realmId"), (Object)realmId));
        return this;
    }

    public EventQuery client(String clientId) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("clientId"), (Object)clientId));
        return this;
    }

    public EventQuery user(String userId) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("userId"), (Object)userId));
        return this;
    }

    public EventQuery fromDate(Date fromDate) {
        this.predicates.add(this.cb.greaterThanOrEqualTo((Expression)this.root.get("time"), (Comparable)Long.valueOf(fromDate.getTime())));
        return this;
    }

    public EventQuery toDate(Date toDate) {
        this.predicates.add(this.cb.lessThanOrEqualTo((Expression)this.root.get("time"), (Comparable)Long.valueOf(toDate.getTime())));
        return this;
    }

    public EventQuery ipAddress(String ipAddress) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("ipAddress"), (Object)ipAddress));
        return this;
    }

    public EventQuery firstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public EventQuery maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public Stream<Event> getResultStream() {
        if (!this.predicates.isEmpty()) {
            this.cq.where((Expression)this.cb.and(this.predicates.toArray(new Predicate[this.predicates.size()])));
        }
        this.cq.orderBy(new Order[]{this.cb.desc((Expression)this.root.get("time"))});
        TypedQuery query = this.em.createQuery(this.cq);
        return StreamsUtil.closing(PaginationUtils.paginateQuery(query, this.firstResult, this.maxResults).getResultStream().map(JpaEventStoreProvider::convertEvent));
    }
}

