/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Set;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.persistence.remote.RemoteStore;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Environment;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.events.AbstractUserSessionClusterListener;
import org.keycloak.models.sessions.infinispan.events.ClientRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.initializer.CacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.DBLockBasedCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.InfinispanCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.OfflinePersistentUserSessionLoader;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionListener;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionsLoader;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.ResetTimeOffsetEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory,
EnvironmentDependentProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProviderFactory.class);
    public static final String PROVIDER_ID = "infinispan";
    public static final String REALM_REMOVED_SESSION_EVENT = "REALM_REMOVED_EVENT_SESSIONS";
    public static final String CLIENT_REMOVED_SESSION_EVENT = "CLIENT_REMOVED_SESSION_SESSIONS";
    public static final String REMOVE_USER_SESSIONS_EVENT = "REMOVE_USER_SESSIONS_EVENT";
    private boolean preloadOfflineSessionsFromDatabase;
    private Config.Scope config;
    private RemoteCacheInvoker remoteCacheInvoker;
    private CrossDCLastSessionRefreshStore lastSessionRefreshStore;
    private CrossDCLastSessionRefreshStore offlineLastSessionRefreshStore;
    private PersisterLastSessionRefreshStore persisterLastSessionRefreshStore;
    private InfinispanKeyGenerator keyGenerator;

    public InfinispanUserSessionProvider create(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = connections.getCache("sessions");
        Cache offlineSessionsCache = connections.getCache("offlineSessions");
        Cache clientSessionCache = connections.getCache("clientSessions");
        Cache offlineClientSessionsCache = connections.getCache("offlineClientSessions");
        return new InfinispanUserSessionProvider(session, this.remoteCacheInvoker, this.lastSessionRefreshStore, this.offlineLastSessionRefreshStore, this.persisterLastSessionRefreshStore, this.keyGenerator, cache, offlineSessionsCache, clientSessionCache, offlineClientSessionsCache, !this.preloadOfflineSessionsFromDatabase);
    }

    public void init(Config.Scope config) {
        this.config = config;
        this.preloadOfflineSessionsFromDatabase = config.getBoolean("preloadOfflineSessionsFromDatabase", Boolean.valueOf(false));
    }

    public void postInit(final KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof PostMigrationEvent) {
                    int preloadTransactionTimeout = InfinispanUserSessionProviderFactory.this.getTimeoutForPreloadingSessionsSeconds();
                    log.debugf("Will preload sessions with transaction timeout %d seconds", preloadTransactionTimeout);
                    KeycloakModelUtils.runJobInTransactionWithTimeout((KeycloakSessionFactory)factory, session -> {
                        InfinispanUserSessionProviderFactory.this.keyGenerator = new InfinispanKeyGenerator();
                        InfinispanUserSessionProviderFactory.this.checkRemoteCaches(session);
                        InfinispanUserSessionProviderFactory.this.loadPersistentSessions(factory, InfinispanUserSessionProviderFactory.this.getMaxErrors(), InfinispanUserSessionProviderFactory.this.getSessionsPerSegment());
                        InfinispanUserSessionProviderFactory.this.registerClusterListeners(session);
                        InfinispanUserSessionProviderFactory.this.loadSessionsFromRemoteCaches(session);
                    }, (int)preloadTransactionTimeout);
                } else if (event instanceof UserModel.UserRemovedEvent) {
                    UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
                    InfinispanUserSessionProvider provider = (InfinispanUserSessionProvider)userRemovedEvent.getKeycloakSession().getProvider(UserSessionProvider.class, InfinispanUserSessionProviderFactory.this.getId());
                    provider.onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                } else if (event instanceof ResetTimeOffsetEvent) {
                    if (InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore != null) {
                        InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore.reset();
                    }
                    if (InfinispanUserSessionProviderFactory.this.lastSessionRefreshStore != null) {
                        InfinispanUserSessionProviderFactory.this.lastSessionRefreshStore.reset();
                    }
                    if (InfinispanUserSessionProviderFactory.this.offlineLastSessionRefreshStore != null) {
                        InfinispanUserSessionProviderFactory.this.offlineLastSessionRefreshStore.reset();
                    }
                }
            }
        });
    }

    private int getMaxErrors() {
        return this.config.getInt("maxErrors", Integer.valueOf(20));
    }

    private int getSessionsPerSegment() {
        return this.config.getInt("sessionsPerSegment", Integer.valueOf(64));
    }

    private int getTimeoutForPreloadingSessionsSeconds() {
        Integer timeout = this.config.getInt("sessionsPreloadTimeoutInSeconds", null);
        return timeout != null ? timeout : Environment.getServerStartupTimeout();
    }

    public void loadPersistentSessions(final KeycloakSessionFactory sessionFactory, final int maxErrors, final int sessionsPerSegment) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                if (InfinispanUserSessionProviderFactory.this.preloadOfflineSessionsFromDatabase) {
                    log.debug((Object)"Start pre-loading userSessions from persistent storage");
                    InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                    Cache workCache = connections.getCache("work");
                    InfinispanCacheInitializer ispnInitializer = new InfinispanCacheInitializer(sessionFactory, workCache, new OfflinePersistentUserSessionLoader(sessionsPerSegment), "offlineUserSessions", sessionsPerSegment, maxErrors);
                    DBLockBasedCacheInitializer initializer = new DBLockBasedCacheInitializer(session, ispnInitializer);
                    ((CacheInitializer)initializer).initCache();
                    initializer.loadSessions();
                    log.debug((Object)"Pre-loading userSessions from persistent storage finished");
                } else {
                    log.debug((Object)"Skipping pre-loading of userSessions from persistent storage");
                }
                InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore = new PersisterLastSessionRefreshStoreFactory().createAndInit(session, true);
            }
        });
    }

    protected void registerClusterListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(REALM_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RealmRemovedSessionEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(KeycloakSession session, UserSessionProvider provider, RealmRemovedSessionEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onRealmRemovedEvent(sessionEvent.getRealmId());
                }
            }
        });
        cluster.registerListener(CLIENT_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<ClientRemovedSessionEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(KeycloakSession session, UserSessionProvider provider, ClientRemovedSessionEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onClientRemovedEvent(sessionEvent.getRealmId(), sessionEvent.getClientUuid());
                }
            }
        });
        cluster.registerListener(REMOVE_USER_SESSIONS_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RemoveUserSessionsEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(KeycloakSession session, UserSessionProvider provider, RemoveUserSessionsEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onRemoveUserSessionsEvent(sessionEvent.getRealmId());
                }
            }
        });
        log.debug((Object)"Registered cluster listeners");
    }

    protected void checkRemoteCaches(KeycloakSession session) {
        this.remoteCacheInvoker = new RemoteCacheInvoker();
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache sessionsCache = ispn.getCache("sessions");
        RemoteCache sessionsRemoteCache = this.checkRemoteCache(session, sessionsCache, realm -> Time.toMillis((long)realm.getSsoSessionMaxLifespan()), SessionTimeouts::getUserSessionLifespanMs, SessionTimeouts::getUserSessionMaxIdleMs);
        if (sessionsRemoteCache != null) {
            this.lastSessionRefreshStore = new CrossDCLastSessionRefreshStoreFactory().createAndInit(session, sessionsCache, false);
        }
        Cache clientSessionsCache = ispn.getCache("clientSessions");
        this.checkRemoteCache(session, clientSessionsCache, realm -> Time.toMillis((long)realm.getSsoSessionMaxLifespan()), SessionTimeouts::getClientSessionLifespanMs, SessionTimeouts::getClientSessionMaxIdleMs);
        Cache offlineSessionsCache = ispn.getCache("offlineSessions");
        RemoteCache offlineSessionsRemoteCache = this.checkRemoteCache(session, offlineSessionsCache, realm -> Time.toMillis((long)realm.getOfflineSessionIdleTimeout()), SessionTimeouts::getOfflineSessionLifespanMs, SessionTimeouts::getOfflineSessionMaxIdleMs);
        if (offlineSessionsRemoteCache != null) {
            this.offlineLastSessionRefreshStore = new CrossDCLastSessionRefreshStoreFactory().createAndInit(session, offlineSessionsCache, true);
        }
        Cache offlineClientSessionsCache = ispn.getCache("offlineClientSessions");
        this.checkRemoteCache(session, offlineClientSessionsCache, realm -> Time.toMillis((long)realm.getOfflineSessionIdleTimeout()), SessionTimeouts::getOfflineClientSessionLifespanMs, SessionTimeouts::getOfflineClientSessionMaxIdleMs);
    }

    private <K, V extends SessionEntity> RemoteCache checkRemoteCache(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> ispnCache, RemoteCacheInvoker.MaxIdleTimeLoader maxIdleLoader, BiFunction<RealmModel, V, Long> lifespanMsLoader, BiFunction<RealmModel, V, Long> maxIdleTimeMsLoader) {
        Set<RemoteStore> remoteStores = InfinispanUtil.getRemoteStores(ispnCache);
        if (remoteStores.isEmpty()) {
            log.debugf("No remote store configured for cache '%s'", (Object)ispnCache.getName());
            return null;
        }
        log.infof("Remote store configured for cache '%s'", (Object)ispnCache.getName());
        RemoteCache remoteCache = remoteStores.iterator().next().getRemoteCache();
        if (remoteCache == null) {
            throw new IllegalStateException("No remote cache available for the infinispan cache: " + ispnCache.getName());
        }
        this.remoteCacheInvoker.addRemoteCache(ispnCache.getName(), remoteCache, maxIdleLoader);
        RemoteCacheSessionListener hotrodListener = RemoteCacheSessionListener.createListener(session, ispnCache, remoteCache, lifespanMsLoader, maxIdleTimeMsLoader);
        remoteCache.addClientListener((Object)hotrodListener);
        return remoteCache;
    }

    private void loadSessionsFromRemoteCaches(KeycloakSession session) {
        for (String cacheName : this.remoteCacheInvoker.getRemoteCacheNames()) {
            this.loadSessionsFromRemoteCache(session.getKeycloakSessionFactory(), cacheName, this.getSessionsPerSegment(), this.getMaxErrors());
        }
    }

    private void loadSessionsFromRemoteCache(final KeycloakSessionFactory sessionFactory, final String cacheName, final int sessionsPerSegment, final int maxErrors) {
        log.debugf("Check pre-loading sessions from remote cache '%s'", (Object)cacheName);
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                Cache workCache = connections.getCache("work");
                InfinispanCacheInitializer initializer = new InfinispanCacheInitializer(sessionFactory, workCache, new RemoteCacheSessionsLoader(cacheName, sessionsPerSegment), "remoteCacheLoad::" + cacheName, sessionsPerSegment, maxErrors);
                initializer.initCache();
                initializer.loadSessions();
            }
        });
        log.debugf("Pre-loading sessions from remote cache '%s' finished", (Object)cacheName);
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public int order() {
        return 1;
    }

    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

