/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.config;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class VaultMapConfigParser<C> {
    private Pattern pattern;
    private Stream<ConfigSource> configSourceStream;
    private Function<String, C> buildConfigObject;

    public VaultMapConfigParser(Pattern pattern, Function<String, C> buildConfigObject, Stream<ConfigSource> configSourceStream) {
        this.pattern = pattern;
        this.configSourceStream = configSourceStream;
        this.buildConfigObject = buildConfigObject;
    }

    public Map<String, C> getConfig() {
        return this.configSourceStream.flatMap(configSource -> configSource.getPropertyNames().stream()).map(this::getKey).filter(Objects::nonNull).distinct().map(this::createKeyValuePair).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private AbstractMap.SimpleEntry<String, C> createKeyValuePair(String name) {
        return new AbstractMap.SimpleEntry<String, C>(name, this.buildConfigObject.apply(name));
    }

    private String getKey(String propertyName) {
        Matcher matcher = this.pattern.matcher(propertyName);
        return matcher.find() ? matcher.group(1) : null;
    }
}

