/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.device.endpoints;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.models.OAuth2DeviceUserCodeModel;
import org.keycloak.models.OAuth2DeviceUserCodeProvider;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpointChecker;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequestParserProcessor;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.protocol.oidc.grants.device.clientpolicy.context.DeviceAuthorizationRequestContext;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.OAuth2DeviceAuthorizationResponse;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;

public class DeviceEndpoint
extends AuthorizationEndpointBase
implements RealmResourceProvider {
    protected static final Logger logger = Logger.getLogger(DeviceEndpoint.class);
    @Context
    private HttpRequest request;
    private Cors cors;

    public DeviceEndpoint(RealmModel realm, EventBuilder event) {
        super(realm, event);
    }

    @Path(value="")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response handleDeviceRequest() {
        this.cors = Cors.add(this.request).auth().allowedMethods("POST").auth().exposedHeaders("Access-Control-Allow-Methods");
        logger.trace((Object)"Processing @POST request");
        this.event.event(EventType.OAUTH2_DEVICE_AUTH);
        this.checkSsl();
        this.checkRealm();
        ClientModel client = this.authenticateClient();
        AuthorizationEndpointRequest request = AuthorizationEndpointRequestParserProcessor.parseRequest(this.event, this.session, client, (MultivaluedMap<String, String>)this.httpRequest.getDecodedFormParameters());
        if (request.getInvalidRequestMessage() != null) {
            this.event.error("invalid_request");
            throw new ErrorResponseException("invalid_grant", request.getInvalidRequestMessage(), Response.Status.BAD_REQUEST);
        }
        if (!TokenUtil.isOIDCRequest((String)request.getScope())) {
            ServicesLogger.LOGGER.oidcScopeMissing();
        }
        CacheControlUtil.noBackButtonCacheControlHeader();
        if (!this.realm.getOAuth2DeviceConfig().isOAuth2DeviceAuthorizationGrantEnabled(client)) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("invalid_grant", "Client not allowed for OAuth 2.0 Device Authorization Grant", Response.Status.BAD_REQUEST);
        }
        AuthorizationEndpointChecker checker = new AuthorizationEndpointChecker().event(this.event).client(client).request(request);
        try {
            checker.checkPKCEParams();
        }
        catch (AuthorizationEndpointChecker.AuthorizationCheckException ex) {
            throw new ErrorResponseException(ex.getError(), ex.getErrorDescription(), Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new DeviceAuthorizationRequestContext(request, (MultivaluedMap<String, String>)this.httpRequest.getDecodedFormParameters()));
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        int expiresIn = this.realm.getOAuth2DeviceConfig().getLifespan(client);
        int interval = this.realm.getOAuth2DeviceConfig().getPoolingInterval(client);
        OAuth2DeviceCodeModel deviceCode = OAuth2DeviceCodeModel.create((RealmModel)this.realm, (ClientModel)client, (String)Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes()), (String)request.getScope(), (String)request.getNonce(), (int)expiresIn, (int)interval, null, null, request.getAdditionalReqParams(), (String)request.getCodeChallenge(), (String)request.getCodeChallengeMethod());
        OAuth2DeviceUserCodeProvider userCodeProvider = (OAuth2DeviceUserCodeProvider)this.session.getProvider(OAuth2DeviceUserCodeProvider.class);
        String secret = userCodeProvider.generate();
        OAuth2DeviceUserCodeModel userCode = new OAuth2DeviceUserCodeModel(this.realm, deviceCode.getDeviceCode(), secret);
        int lifespanSeconds = expiresIn + interval + 10;
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)this.session.getProvider(SingleUseObjectProvider.class);
        singleUseStore.put(deviceCode.serializeKey(), (long)lifespanSeconds, deviceCode.toMap());
        singleUseStore.put(userCode.serializeKey(), (long)lifespanSeconds, userCode.serializeValue());
        try {
            String deviceUrl = DeviceGrantType.oauth2DeviceVerificationUrl((UriInfo)this.session.getContext().getUri()).build(new Object[]{this.realm.getName()}).toString();
            OAuth2DeviceAuthorizationResponse response = new OAuth2DeviceAuthorizationResponse();
            response.setDeviceCode(deviceCode.getDeviceCode());
            response.setUserCode(userCodeProvider.display(secret));
            response.setExpiresIn((long)expiresIn);
            response.setInterval((long)interval);
            response.setVerificationUri(deviceUrl);
            response.setVerificationUriComplete(deviceUrl + "?user_code=" + response.getUserCode());
            return this.cors.builder(Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)response)).type(MediaType.APPLICATION_JSON_TYPE)).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating OAuth 2.0 Device Authorization Response.", e);
        }
    }

    @OPTIONS
    public Response preflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("CORS preflight from: {0}", this.headers.getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.add(this.request, Response.ok()).auth().preflight().allowedMethods("POST", "OPTIONS").build();
    }

    @GET
    public Response verifyUserCode(@QueryParam(value="user_code") String userCode) {
        this.event.event(EventType.OAUTH2_DEVICE_VERIFY_USER_CODE);
        this.checkSsl();
        this.checkRealm();
        CacheControlUtil.noBackButtonCacheControlHeader();
        if (StringUtil.isNullOrEmpty((String)userCode)) {
            return this.createVerificationPage(null);
        }
        OAuth2DeviceUserCodeProvider userCodeProvider = (OAuth2DeviceUserCodeProvider)this.session.getProvider(OAuth2DeviceUserCodeProvider.class);
        String formattedUserCode = userCodeProvider.format(userCode);
        OAuth2DeviceCodeModel deviceCode = DeviceEndpoint.getDeviceByUserCode(this.session, this.realm, formattedUserCode);
        if (deviceCode == null) {
            return this.invalidUserCodeResponse("oauth2DeviceInvalidUserCodeMessage", "device code not found (it may already have been used)");
        }
        if (!deviceCode.isPending()) {
            this.event.detail("device_code_user_session_id", deviceCode.getUserSessionId());
            return this.invalidUserCodeResponse("oauth2DeviceInvalidUserCodeMessage", "device code already used and not yet deleted");
        }
        if (deviceCode.isDenied()) {
            return this.invalidUserCodeResponse("oauth2DeviceInvalidUserCodeMessage", "device code denied");
        }
        if (deviceCode.isExpired()) {
            return this.invalidUserCodeResponse("oauth2DeviceExpiredUserCodeMessage", "device code expired");
        }
        return this.processVerification(deviceCode, formattedUserCode);
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response verifyUserCode() {
        MultivaluedMap formData = this.httpRequest.getDecodedFormParameters();
        return this.verifyUserCode((String)formData.getFirst((Object)"device_user_code"));
    }

    @Path(value="status")
    @GET
    public Response status(@QueryParam(value="error") String error) {
        if (!StringUtil.isNullOrEmpty((String)error)) {
            String message;
            switch (error) {
                case "access_denied": {
                    message = "oauth2DeviceConsentDeniedMessage";
                    break;
                }
                case "expired_token": {
                    message = "oauth2DeviceExpiredUserCodeMessage";
                    break;
                }
                default: {
                    message = "oauth2DeviceVerificationFailedMessage";
                }
            }
            LoginFormsProvider forms = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
            String restartUri = DeviceGrantType.oauth2DeviceVerificationUrl((UriInfo)this.session.getContext().getUri()).build(new Object[]{this.realm.getName()}).toString();
            return forms.setAttribute("messageHeader", (Object)forms.getMessage("oauth2DeviceVerificationFailedHeader")).setAttribute("actionUri", (Object)restartUri).setError(message, new Object[0]).createInfoPage();
        }
        LoginFormsProvider forms = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
        return forms.setAttribute("messageHeader", (Object)forms.getMessage("oauth2DeviceVerificationCompleteHeader")).setAttribute("skipLink", (Object)true).setSuccess("oauth2DeviceVerificationCompleteMessage", new Object[0]).createInfoPage();
    }

    public static OAuth2DeviceCodeModel getDeviceByUserCode(KeycloakSession session, RealmModel realm, String userCode) {
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        Map notes = singleUseStore.get(OAuth2DeviceUserCodeModel.createKey((RealmModel)realm, (String)userCode));
        if (notes != null) {
            OAuth2DeviceUserCodeModel data = OAuth2DeviceUserCodeModel.fromCache((RealmModel)realm, (String)userCode, (Map)notes);
            String deviceCode = data.getDeviceCode();
            return (notes = singleUseStore.get(OAuth2DeviceCodeModel.createKey((String)deviceCode))) != null ? OAuth2DeviceCodeModel.fromCache((RealmModel)realm, (String)deviceCode, (Map)notes) : null;
        }
        return null;
    }

    private Response invalidUserCodeResponse(String errorMessage, String reason) {
        this.event.error("invalid_oauth2_user_code");
        this.event.detail("reason", reason);
        logger.debugf("invalid user code: %s", (Object)reason);
        return this.createVerificationPage(errorMessage);
    }

    private Response createVerificationPage(String errorMessage) {
        String execution = CommonClientSessionModel.Action.USER_CODE_VERIFICATION.name();
        LoginFormsProvider provider = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setExecution(execution);
        if (errorMessage != null) {
            provider = provider.setError(errorMessage, new Object[0]);
        }
        return provider.createOAuth2DeviceVerifyUserCodePage();
    }

    private Response processVerification(OAuth2DeviceCodeModel deviceCode, String userCode) {
        ClientModel client = this.realm.getClientByClientId(deviceCode.getClientId());
        AuthenticationSessionModel authenticationSession = this.createAuthenticationSession(client, deviceCode.getScope());
        authenticationSession.setClientNote("OAUTH2_DEVICE_VERIFIED_USER_CODE", userCode);
        this.event.client(deviceCode.getClientId()).detail("scope", deviceCode.getScope()).success();
        OIDCLoginProtocol protocol = new OIDCLoginProtocol(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.headers, this.event);
        return this.handleBrowserAuthenticationRequest(authenticationSession, protocol, false, true);
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    private ClientModel authenticateClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.cors);
        ClientModel client = clientAuth.getClient();
        if (client == null) {
            this.event.error("invalid_request");
            throw new ErrorResponseException("invalid_request", "Missing parameters:client_id", Response.Status.BAD_REQUEST);
        }
        this.checkClient(client.getClientId());
        return client;
    }

    private ClientModel checkClient(String clientId) {
        if (clientId == null) {
            this.event.error("invalid_request");
            throw new ErrorResponseException("invalid_request", "Missing parameters:client_id", Response.Status.BAD_REQUEST);
        }
        this.event.client(clientId);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            this.event.error("client_not_found");
            throw new ErrorResponseException("invalid_client", "Client not found.", Response.Status.BAD_REQUEST);
        }
        if (!client.isEnabled()) {
            this.event.error("client_disabled");
            throw new ErrorResponseException("invalid_client", "Client disabled.", Response.Status.BAD_REQUEST);
        }
        if (!this.realm.getOAuth2DeviceConfig().isOAuth2DeviceAuthorizationGrantEnabled(client)) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("unauthorized_client", "Client is not allowed to initiate OAuth 2.0 Device Authorization Grant. The flow is disabled for the client.", Response.Status.BAD_REQUEST);
        }
        if (client.isBearerOnly()) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("unauthorized_client", "Bearer-only applications are not allowed to initiate browser login.", Response.Status.FORBIDDEN);
        }
        String protocol = client.getProtocol();
        if (protocol == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)clientId);
            protocol = "openid-connect";
        }
        if (!protocol.equals("openid-connect")) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Wrong client protocol.", Response.Status.BAD_REQUEST);
        }
        this.session.getContext().setClient(client);
        return client;
    }

    @Override
    protected AuthenticationSessionModel createAuthenticationSession(ClientModel client, String scope) {
        AuthenticationSessionModel authenticationSession = super.createAuthenticationSession(client, null);
        authenticationSession.setProtocol("openid-connect");
        authenticationSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authenticationSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        if (scope != null) {
            authenticationSession.setClientNote("scope", scope);
        }
        return authenticationSession;
    }
}

