/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.Futures;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class UserTagSectionHelper
implements SectionHelper {
    private static final String NESTED_CONTENT = "nested-content";
    private final Supplier<Template> templateSupplier;
    private final Map<String, Expression> parameters;
    private final boolean isEmpty;
    private final boolean isIsolated;

    UserTagSectionHelper(Supplier<Template> templateSupplier, Map<String, Expression> parameters, boolean isEmpty, boolean isIsolated) {
        this.templateSupplier = templateSupplier;
        this.parameters = parameters;
        this.isEmpty = isEmpty;
        this.isIsolated = isIsolated;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        Futures.evaluateParams(this.parameters, context.resolutionContext()).whenComplete((evaluatedParams, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                if (!this.isEmpty) {
                    evaluatedParams.put(NESTED_CONTENT, context.execute(context.resolutionContext().createChild(Mapper.wrap(evaluatedParams), null)));
                }
                try {
                    Mapper data = Mapper.wrap(evaluatedParams);
                    ResolutionContext resolutionContext = this.isIsolated ? context.newResolutionContext(data, null) : context.resolutionContext().createChild(data, null);
                    TemplateImpl tagTemplate = (TemplateImpl)this.templateSupplier.get();
                    tagTemplate.root.resolve(resolutionContext).whenComplete((resultNode, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)resultNode);
                        }
                    });
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    public static class Factory
    implements SectionHelperFactory<UserTagSectionHelper> {
        private static final String IT = "it";
        private static final String ISOLATED = "_isolated";
        private static final String ISOLATED_DEFAULT_VALUE = "false";
        private final String name;
        private final String templateId;

        public Factory(String name, String templateId) {
            this.name = name;
            this.templateId = templateId;
        }

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(this.name);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(Parameter.builder(IT).defaultValue(IT)).addParameter(Parameter.builder(ISOLATED).defaultValue(ISOLATED_DEFAULT_VALUE).optional().valuePredicate(v -> ISOLATED.equals(v))).build();
        }

        @Override
        public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                for (Map.Entry<String, String> entry : block.getParameters().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key.equals(ISOLATED) || value.equals(ISOLATED) || key.equals(IT) && value.equals(IT)) continue;
                    if (this.useDefaultedKey(key, value)) {
                        key = value;
                    }
                    block.addExpression(key, value);
                }
                return outerScope;
            }
            return outerScope;
        }

        @Override
        public UserTagSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            HashMap<String, Expression> params = new HashMap<String, Expression>();
            boolean isolatedValue = false;
            for (Map.Entry<String, String> entry : context.getParameters().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value.equals(ISOLATED)) {
                    isolatedValue = true;
                    continue;
                }
                if (key.equals(ISOLATED)) continue;
                if (key.equals(IT)) {
                    if (value.equals(IT)) continue;
                    if (this.isSinglePart(value)) {
                        params.put(value, context.getExpression(key));
                    }
                } else if (this.useDefaultedKey(key, value)) {
                    key = value;
                }
                params.put(key, context.getExpression(key));
            }
            boolean isEmpty = context.getBlocks().size() == 1 && context.getBlocks().get(0).isEmpty();
            final Engine engine = context.getEngine();
            return new UserTagSectionHelper(new Supplier<Template>(){

                @Override
                public Template get() {
                    Template template = engine.getTemplate(templateId);
                    if (template == null) {
                        throw new TemplateException("Tag template not found: " + templateId);
                    }
                    return template;
                }
            }, params, isEmpty, isolatedValue ? true : Boolean.parseBoolean(context.getParameterOrDefault(ISOLATED, ISOLATED_DEFAULT_VALUE)));
        }

        private boolean useDefaultedKey(String key, String value) {
            return LiteralSupport.INTEGER_LITERAL_PATTERN.matcher(key).matches() && this.isSinglePart(value);
        }

        private boolean isSinglePart(String value) {
            return Expressions.splitParts(value).size() == 1;
        }
    }
}

