/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

class RedisPoolHolder {
    private static final RedisPoolHolder INSTANCE = new RedisPoolHolder();
    private final Map<String, JedisPoolProxy> standalonePools = new ConcurrentHashMap<String, JedisPoolProxy>();
    private final Object mutex = new Object();

    RedisPoolHolder() {
    }

    public static RedisPoolHolder getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pool<Jedis> getJedisPool(URI hostURI, int configuredPort) {
        Object object = this.mutex;
        synchronized (object) {
            String cleanConnectionString;
            String lowerCasedConnectionString = hostURI.toString().toLowerCase();
            String string = cleanConnectionString = hostURI.getFragment() != null ? lowerCasedConnectionString.substring(0, lowerCasedConnectionString.length() - hostURI.getFragment().length()) : lowerCasedConnectionString;
            if (this.standalonePools.containsKey(cleanConnectionString)) {
                JedisPoolProxy poolProxy = this.standalonePools.get(cleanConnectionString);
                poolProxy.incrementRefCnt();
                return poolProxy;
            }
            Pool<Jedis> jedisPool = JedisPoolFactory.createJedisPool(hostURI, configuredPort, 2000);
            JedisPoolProxy proxy = new JedisPoolProxy(jedisPool, new Runnable(){

                @Override
                public void run() {
                    RedisPoolHolder.this.standalonePools.remove(cleanConnectionString);
                }
            });
            this.standalonePools.put(cleanConnectionString, proxy);
            return proxy;
        }
    }

    private class JedisPoolProxy
    extends Pool<Jedis> {
        private final AtomicLong refCnt = new AtomicLong(1L);
        private final Runnable onDestroy;
        private final Pool<Jedis> delegate;

        private JedisPoolProxy(Pool<Jedis> delegate, Runnable onDestroy) {
            this.onDestroy = onDestroy;
            this.delegate = delegate;
        }

        public void close() {
            this.delegate.close();
        }

        public void incrementRefCnt() {
            this.refCnt.incrementAndGet();
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        public void initPool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<Jedis> factory) {
            this.delegate.initPool(poolConfig, factory);
        }

        public Jedis getResource() {
            return (Jedis)this.delegate.getResource();
        }

        public void returnResourceObject(Jedis resource) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = RedisPoolHolder.this.mutex;
            synchronized (object) {
                long val = this.refCnt.decrementAndGet();
                if (val == 0L) {
                    this.onDestroy.run();
                    this.delegate.destroy();
                }
            }
        }

        public int getNumActive() {
            return this.delegate.getNumActive();
        }

        public int getNumIdle() {
            return this.delegate.getNumIdle();
        }

        public int getNumWaiters() {
            return this.delegate.getNumWaiters();
        }

        public long getMeanBorrowWaitTimeMillis() {
            return this.delegate.getMeanBorrowWaitTimeMillis();
        }

        public long getMaxBorrowWaitTimeMillis() {
            return this.delegate.getMaxBorrowWaitTimeMillis();
        }

        public void addObjects(int count) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum JedisPoolFactory {
        STANDALONE{

            @Override
            public String getScheme() {
                return "redis";
            }

            @Override
            public Pool<Jedis> createPool(URI hostURI, int configuredPort, int timeoutMs) {
                String password = hostURI.getUserInfo() != null ? hostURI.getUserInfo().split(":", 2)[1] : null;
                int database = 0;
                if (hostURI.getPath() != null && hostURI.getPath().length() > 1) {
                    database = Integer.parseInt(hostURI.getPath().split("/", 2)[1]);
                }
                int port = hostURI.getPort() > 0 ? hostURI.getPort() : configuredPort;
                return new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hostURI.getHost(), port, timeoutMs, password, database);
            }
        }
        ,
        SENTINEL{
            public static final String MASTER_ID = "masterId";

            @Override
            public String getScheme() {
                return "redis-sentinel";
            }

            @Override
            public Pool<Jedis> createPool(URI hostURI, int configuredPort, int timeoutMs) {
                Set<String> sentinels = this.getSentinels(hostURI);
                String masterName = this.getMasterName(hostURI);
                Logger.getLogger(JedisSentinelPool.class.getName()).setLevel(Level.OFF);
                String password = hostURI.getUserInfo() != null ? hostURI.getUserInfo().split(":", 2)[1] : null;
                int database = 0;
                if (hostURI.getPath() != null && hostURI.getPath().length() > 1) {
                    database = Integer.parseInt(hostURI.getPath().split("/", 2)[1]);
                }
                return new JedisSentinelPool(masterName, sentinels, (GenericObjectPoolConfig)new JedisPoolConfig(), timeoutMs, password, database);
            }

            protected String getMasterName(URI hostURI) {
                String masterName = "master";
                if (hostURI.getQuery() != null) {
                    String[] keyValues;
                    for (String keyValue : keyValues = hostURI.getQuery().split("\\&")) {
                        String[] parts = keyValue.split("\\=");
                        if (parts.length != 2 || !parts[0].equals(MASTER_ID)) continue;
                        masterName = parts[1].trim();
                    }
                }
                return masterName;
            }

            protected Set<String> getSentinels(URI hostURI) {
                String[] sentinelHostNames;
                HashSet<String> sentinels = new HashSet<String>();
                for (String sentinelHostName : sentinelHostNames = hostURI.getHost().split("\\,")) {
                    if (sentinelHostName.contains(":")) {
                        sentinels.add(sentinelHostName);
                        continue;
                    }
                    if (hostURI.getPort() <= 0) continue;
                    sentinels.add(sentinelHostName + ":" + hostURI.getPort());
                }
                return sentinels;
            }
        };


        public abstract String getScheme();

        abstract Pool<Jedis> createPool(URI var1, int var2, int var3);

        public static Pool<Jedis> createJedisPool(URI hostURI, int configuredPort, int timeoutMs) {
            for (JedisPoolFactory provider : JedisPoolFactory.values()) {
                if (!provider.getScheme().equals(hostURI.getScheme())) continue;
                return provider.createPool(hostURI, configuredPort, timeoutMs);
            }
            throw new IllegalArgumentException("Scheme " + hostURI.getScheme() + " not supported");
        }
    }
}

