/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.ConfigurationSchemaVersion;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.configuration.io.ConfigurationWriterException;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.URLConfigurationResourceResolver;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.NamespaceMappingParser;
import org.infinispan.configuration.parsing.Schema;
import org.infinispan.configuration.parsing.SecurityActions;
import org.infinispan.configuration.serializing.ConfigurationHolder;
import org.infinispan.configuration.serializing.CoreConfigurationSerializer;
import org.infinispan.util.logging.Log;

public class ParserRegistry
implements NamespaceMappingParser {
    private final WeakReference<ClassLoader> cl;
    private final ConcurrentMap<QName, NamespaceParserPair> parserMappings = new ConcurrentHashMap<QName, NamespaceParserPair>();
    private final Properties properties;

    public ParserRegistry() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ParserRegistry(ClassLoader classLoader) {
        this(classLoader, false, SecurityActions.getSystemProperties());
    }

    public ParserRegistry(ClassLoader classLoader, boolean defaultOnly, Properties properties) {
        this.cl = new WeakReference<ClassLoader>(classLoader);
        this.properties = properties;
        Collection parsers = ServiceFinder.load(ConfigurationParser.class, (ClassLoader[])new ClassLoader[]{(ClassLoader)this.cl.get(), ParserRegistry.class.getClassLoader()});
        for (ConfigurationParser parser : parsers) {
            Namespace[] namespaces = parser.getNamespaces();
            if (namespaces == null) {
                throw Log.CONFIG.parserDoesNotDeclareNamespaces(parser.getClass().getName());
            }
            boolean skipParser = defaultOnly;
            if (skipParser) {
                for (Namespace ns : namespaces) {
                    if (!"".equals(ns.uri())) continue;
                    skipParser = false;
                }
            }
            if (skipParser) continue;
            for (Namespace ns : namespaces) {
                QName qName = new QName(ns.uri(), ns.root());
                NamespaceParserPair existing = this.parserMappings.putIfAbsent(qName, new NamespaceParserPair(ns, parser));
                if (existing == null || parser.getClass().equals(existing.parser.getClass())) continue;
                Log.CONFIG.parserRootElementAlreadyRegistered(qName.toString(), parser.getClass().getName(), existing.parser.getClass().getName());
            }
        }
    }

    public ConfigurationBuilderHolder parse(Path path) throws IOException {
        return this.parse(path.toUri().toURL());
    }

    public ConfigurationBuilderHolder parse(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is, (ConfigurationResourceResolver)new URLConfigurationResourceResolver(url), MediaType.fromExtension((String)url.getFile()));
            return configurationBuilderHolder;
        }
    }

    public ConfigurationBuilderHolder parseFile(String filename) throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        URL url = fileLookup.lookupFileLocation(filename, (ClassLoader)this.cl.get());
        if (url == null) {
            throw new FileNotFoundException(filename);
        }
        try (InputStream is = url.openStream();){
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is, (ConfigurationResourceResolver)new URLConfigurationResourceResolver(url), MediaType.fromExtension((String)url.getFile()));
            return configurationBuilderHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parseFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        if (is == null) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        try {
            URL url = file.toURI().toURL();
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is, (ConfigurationResourceResolver)new URLConfigurationResourceResolver(url), MediaType.fromExtension((String)url.getFile()));
            return configurationBuilderHolder;
        }
        finally {
            Util.close((AutoCloseable)is);
        }
    }

    public ConfigurationBuilderHolder parse(String s) {
        return this.parse(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)), null, MediaType.APPLICATION_XML);
    }

    public ConfigurationBuilderHolder parse(String s, MediaType mediaType) {
        return this.parse(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)), null, mediaType);
    }

    public ConfigurationBuilderHolder parse(InputStream is, ConfigurationResourceResolver resourceResolver, MediaType mediaType) {
        try {
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder((ClassLoader)this.cl.get());
            this.parse(is, holder, resourceResolver, mediaType);
            holder.validate();
            return holder;
        }
        catch (CacheConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    public ConfigurationBuilderHolder parse(URL url, ConfigurationBuilderHolder holder) throws IOException {
        try (InputStream is = url.openStream();){
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is, holder, (ConfigurationResourceResolver)new URLConfigurationResourceResolver(url), MediaType.fromExtension((String)url.getFile()));
            return configurationBuilderHolder;
        }
    }

    public ConfigurationBuilderHolder parse(InputStream is, ConfigurationBuilderHolder holder, ConfigurationResourceResolver resourceResolver, MediaType mediaType) {
        ConfigurationReader reader = ConfigurationReader.from((InputStream)is).withResolver(resourceResolver).withType(mediaType).withProperties(this.properties).withNamingStrategy(NamingStrategy.KEBAB_CASE).build();
        this.parse(reader, holder);
        holder.fireParserListeners();
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parse(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        try {
            holder.setNamespaceMappingParser(this);
            reader.require(ConfigurationReader.ElementType.START_DOCUMENT);
            ConfigurationReader.ElementType elementType = reader.nextElement();
            if (elementType == ConfigurationReader.ElementType.START_ELEMENT) {
                this.parseElement(reader, holder);
            }
            while (elementType != ConfigurationReader.ElementType.END_DOCUMENT) {
                elementType = reader.nextElement();
            }
            ConfigurationBuilderHolder configurationBuilderHolder = holder;
            return configurationBuilderHolder;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void parseElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        String namespace = reader.getNamespace();
        String name = reader.getLocalName();
        NamespaceParserPair parser = this.findNamespaceParser(namespace, name);
        ConfigurationSchemaVersion oldSchema = reader.getSchema();
        reader.setSchema((ConfigurationSchemaVersion)Schema.fromNamespaceURI(namespace));
        parser.parser.readElement(reader, holder);
        reader.setSchema(oldSchema);
    }

    @Override
    public void parseAttribute(ConfigurationReader reader, int i, ConfigurationBuilderHolder holder) throws ConfigurationReaderException {
        String namespace = reader.getAttributeNamespace(i);
        String name = reader.getLocalName();
        NamespaceParserPair parser = this.findNamespaceParser(namespace, name);
        ConfigurationSchemaVersion oldSchema = reader.getSchema();
        reader.setSchema((ConfigurationSchemaVersion)Schema.fromNamespaceURI(namespace));
        parser.parser.readAttribute(reader, name, i, holder);
        reader.setSchema(oldSchema);
    }

    private NamespaceParserPair findNamespaceParser(String namespace, String name) {
        int lastColon;
        String baseUri;
        NamespaceParserPair parser = (NamespaceParserPair)this.parserMappings.get(new QName(namespace, name));
        if (!(parser != null || (parser = (NamespaceParserPair)this.parserMappings.get(new QName(baseUri = namespace.substring(0, (lastColon = namespace.lastIndexOf(58)) + 1) + "*", name))) != null && this.isSupportedNamespaceVersion(parser.namespace, namespace.substring(lastColon + 1)))) {
            throw Log.CONFIG.unsupportedConfiguration(name, namespace, Version.getVersion());
        }
        return parser;
    }

    private boolean isSupportedNamespaceVersion(Namespace namespace, String version) {
        short reqVersion = Version.getVersionShort((String)version);
        if (reqVersion < Version.getVersionShort((String)namespace.since())) {
            return false;
        }
        short untilVersion = namespace.until().length() > 0 ? Version.getVersionShort((String)namespace.until()) : Version.getVersionShort();
        return reqVersion <= untilVersion;
    }

    @Deprecated
    public void serialize(OutputStream os, GlobalConfiguration globalConfiguration, Map<String, Configuration> configurations) {
        ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)os).build();
        this.serialize(writer, globalConfiguration, configurations);
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new ConfigurationWriterException((Throwable)e);
        }
    }

    public void serialize(ConfigurationWriter writer, GlobalConfiguration globalConfiguration, Map<String, Configuration> configurations) {
        writer.writeStartDocument();
        CoreConfigurationSerializer serializer = new CoreConfigurationSerializer();
        serializer.serialize(writer, new ConfigurationHolder(globalConfiguration, configurations));
        writer.writeEndDocument();
    }

    @Deprecated
    public void serialize(OutputStream os, String name, Configuration configuration) {
        this.serialize(os, null, Collections.singletonMap(name, configuration));
    }

    @Deprecated
    public String serialize(String name, Configuration configuration) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.serialize((OutputStream)os, name, configuration);
            return os.toString("UTF-8");
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    public String toString() {
        return "ParserRegistry{}";
    }

    public void serialize(ConfigurationWriter writer, String name, Configuration configuration) {
        writer.writeStartDocument();
        CoreConfigurationSerializer serializer = new CoreConfigurationSerializer();
        serializer.writeCache(writer, name, configuration, true);
        writer.writeEndDocument();
    }

    public static class QName {
        final String namespace;
        final String name;

        public QName(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QName qName = (QName)o;
            return Objects.equals(this.namespace, qName.namespace) && Objects.equals(this.name, qName.name);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.name);
        }

        public String toString() {
            return this.namespace.equals("") ? this.name : "{" + this.namespace + "}" + this.name;
        }
    }

    public static class NamespaceParserPair {
        Namespace namespace;
        ConfigurationParser parser;

        NamespaceParserPair(Namespace namespace, ConfigurationParser parser) {
            this.namespace = namespace;
            this.parser = parser;
        }

        public String toString() {
            return "NamespaceParserPair{namespace=" + this.namespace + ", parser=" + this.parser + '}';
        }
    }
}

