/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import org.keycloak.config.HttpOptions;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;

final class HttpPropertyMappers {
    private HttpPropertyMappers() {
    }

    public static PropertyMapper[] getHttpPropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(HttpOptions.HTTP_ENABLED).to("quarkus.http.insecure-requests").transformer(HttpPropertyMappers::getHttpEnabledTransformer).paramLabel(Boolean.TRUE + "|" + Boolean.FALSE).build(), PropertyMapper.fromOption(HttpOptions.HTTP_HOST).to("quarkus.http.host").paramLabel("host").build(), PropertyMapper.fromOption(HttpOptions.HTTP_RELATIVE_PATH).to("quarkus.http.root-path").paramLabel("path").build(), PropertyMapper.fromOption(HttpOptions.HTTP_PORT).to("quarkus.http.port").paramLabel("port").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_PORT).to("quarkus.http.ssl-port").paramLabel("port").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_CLIENT_AUTH).to("quarkus.http.ssl.client-auth").paramLabel("auth").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_CIPHER_SUITES).to("quarkus.http.ssl.cipher-suites").paramLabel("ciphers").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_PROTOCOLS).to("quarkus.http.ssl.protocols").paramLabel("protocols").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_CERTIFICATE_FILE).to("quarkus.http.ssl.certificate.file").paramLabel("file").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_CERTIFICATE_KEY_FILE).to("quarkus.http.ssl.certificate.key-file").paramLabel("file").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_KEY_STORE_FILE.withRuntimeSpecificDefault((Object)HttpPropertyMappers.getDefaultKeystorePathValue())).to("quarkus.http.ssl.certificate.key-store-file").paramLabel("file").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_KEY_STORE_PASSWORD).to("quarkus.http.ssl.certificate.key-store-password").paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(HttpOptions.HTTPS_KEY_STORE_TYPE).to("quarkus.http.ssl.certificate.key-store-file-type").paramLabel("type").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_TRUST_STORE_FILE).to("quarkus.http.ssl.certificate.trust-store-file").paramLabel("file").build(), PropertyMapper.fromOption(HttpOptions.HTTPS_TRUST_STORE_PASSWORD).to("quarkus.http.ssl.certificate.trust-store-password").paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(HttpOptions.HTTPS_TRUST_STORE_TYPE).to("quarkus.http.ssl.certificate.trust-store-file-type").paramLabel("type").build()};
    }

    private static Optional<String> getHttpEnabledTransformer(Optional<String> value, ConfigSourceInterceptorContext context) {
        boolean enabled = Boolean.parseBoolean(value.get());
        ConfigValue proxy = context.proceed("kc.proxy");
        if (Environment.isDevMode() || Environment.isImportExportMode() || proxy != null && "edge".equalsIgnoreCase(proxy.getValue())) {
            enabled = true;
        }
        if (!enabled) {
            ConfigValue proceed = context.proceed("kc.https-certificate-file");
            if (proceed == null || proceed.getValue() == null) {
                proceed = PropertyMappers.getMapper("quarkus.http.ssl.certificate.key-store-file").getConfigValue(context);
            }
            if (proceed == null || proceed.getValue() == null) {
                QuarkusPlatform.addInitializationException(Messages.httpsConfigurationNotSet());
            }
        }
        return Optional.of(enabled ? "enabled" : "disabled");
    }

    private static String getDefaultKeystorePathValue() {
        File file;
        String homeDir = Environment.getHomeDir();
        if (homeDir != null && (file = Paths.get(homeDir, "conf", "server.keystore").toFile()).exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }
}

