/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.IndefiniteWaitOneShotStartupCheckStrategy;
import org.testcontainers.shaded.com.google.common.base.Joiner;
import org.testcontainers.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;
import org.testcontainers.shaded.org.apache.commons.lang.SystemUtils;
import org.testcontainers.utility.AuditLogger;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.PathUtils;

class ContainerisedDockerCompose
extends GenericContainer<ContainerisedDockerCompose>
implements DockerCompose {
    public static final char UNIX_PATH_SEPERATOR = ':';
    public static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse("docker/compose:1.29.2");

    public ContainerisedDockerCompose(List<File> composeFiles, String identifier) {
        super(DEFAULT_IMAGE_NAME);
        this.addEnv("COMPOSE_PROJECT_NAME", identifier);
        File dockerComposeBaseFile = composeFiles.get(0);
        String pwd = dockerComposeBaseFile.getAbsoluteFile().getParentFile().getAbsolutePath();
        String containerPwd = this.convertToUnixFilesystemPath(pwd);
        List absoluteDockerComposeFiles = composeFiles.stream().map(File::getAbsolutePath).map(MountableFile::forHostPath).map(MountableFile::getFilesystemPath).map(this::convertToUnixFilesystemPath).collect(Collectors.toList());
        String composeFileEnvVariableValue = Joiner.on(':').join(absoluteDockerComposeFiles);
        this.logger().debug("Set env COMPOSE_FILE={}", (Object)composeFileEnvVariableValue);
        this.addEnv("COMPOSE_FILE", composeFileEnvVariableValue);
        this.addFileSystemBind(pwd, containerPwd, BindMode.READ_WRITE);
        this.addFileSystemBind(DockerClientFactory.instance().getRemoteDockerUnixSocketPath(), "/docker.sock", BindMode.READ_WRITE);
        this.addEnv("DOCKER_HOST", "unix:///docker.sock");
        this.setStartupCheckStrategy(new IndefiniteWaitOneShotStartupCheckStrategy());
        this.setWorkingDirectory(containerPwd);
    }

    @Override
    public void invoke() {
        super.start();
        this.followOutput(new Slf4jLogConsumer(this.logger()));
        this.logger().info("Docker Compose container is running for command: {}", (Object)Joiner.on(" ").join(this.getCommandParts()));
        while (this.isRunning()) {
            this.logger().trace("Compose container is still running");
            Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
        }
        this.logger().info("Docker Compose has finished running");
        AuditLogger.doComposeLog(this.getCommandParts(), this.getEnv());
        Integer exitCode = this.dockerClient.inspectContainerCmd(this.getContainerId()).exec().getState().getExitCode();
        if (exitCode == null || exitCode != 0) {
            throw new ContainerLaunchException("Containerised Docker Compose exited abnormally with code " + exitCode + " whilst running command: " + StringUtils.join((Object[])this.getCommandParts(), ' '));
        }
    }

    private String convertToUnixFilesystemPath(String path) {
        return SystemUtils.IS_OS_WINDOWS ? PathUtils.createMinGWPath(path).substring(1) : path;
    }
}

