/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Nationalized;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.jpa.entities.ClientAttributeEntity;
import org.keycloak.models.jpa.entities.ProtocolMapperEntity;

@Entity
@Table(name="CLIENT", uniqueConstraints={@UniqueConstraint(columnNames={"REALM_ID", "CLIENT_ID"})})
@NamedQueries(value={@NamedQuery(name="getClientsByRealm", query="select client from ClientEntity client where client.realmId = :realm"), @NamedQuery(name="getClientById", query="select client from ClientEntity client where client.id = :id and client.realmId = :realm"), @NamedQuery(name="getClientIdsByRealm", query="select client.id from ClientEntity client where client.realmId = :realm order by client.clientId"), @NamedQuery(name="getAlwaysDisplayInConsoleClients", query="select client.id from ClientEntity client where client.alwaysDisplayInConsole = true and client.realmId = :realm order by client.clientId"), @NamedQuery(name="findClientIdByClientId", query="select client.id from ClientEntity client where client.clientId = :clientId and client.realmId = :realm"), @NamedQuery(name="searchClientsByClientId", query="select client.id from ClientEntity client where lower(client.clientId) like lower(concat('%',:clientId,'%')) and client.realmId = :realm order by client.clientId"), @NamedQuery(name="getRealmClientsCount", query="select count(client) from ClientEntity client where client.realmId = :realm"), @NamedQuery(name="findClientByClientId", query="select client from ClientEntity client where client.clientId = :clientId and client.realmId = :realm"), @NamedQuery(name="getAllRedirectUrisOfEnabledClients", query="select new map(client as client, r as redirectUri) from ClientEntity client join client.redirectUris r where client.realmId = :realm and client.enabled = true")})
public class ClientEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Nationalized
    @Column(name="NAME")
    private String name;
    @Nationalized
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CLIENT_ID")
    private String clientId;
    @Column(name="ENABLED")
    private boolean enabled;
    @Column(name="ALWAYS_DISPLAY_IN_CONSOLE")
    private boolean alwaysDisplayInConsole;
    @Column(name="SECRET")
    private String secret;
    @Column(name="REGISTRATION_TOKEN")
    private String registrationToken;
    @Column(name="CLIENT_AUTHENTICATOR_TYPE")
    private String clientAuthenticatorType;
    @Column(name="NOT_BEFORE")
    private int notBefore;
    @Column(name="PUBLIC_CLIENT")
    private boolean publicClient;
    @Column(name="PROTOCOL")
    private String protocol;
    @Column(name="FRONTCHANNEL_LOGOUT")
    private boolean frontchannelLogout;
    @Column(name="FULL_SCOPE_ALLOWED")
    private boolean fullScopeAllowed;
    @Column(name="REALM_ID")
    protected String realmId;
    @ElementCollection
    @Column(name="VALUE")
    @CollectionTable(name="WEB_ORIGINS", joinColumns={@JoinColumn(name="CLIENT_ID")})
    protected Set<String> webOrigins;
    @ElementCollection
    @Column(name="VALUE")
    @CollectionTable(name="REDIRECT_URIS", joinColumns={@JoinColumn(name="CLIENT_ID")})
    protected Set<String> redirectUris;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="client")
    protected Collection<ClientAttributeEntity> attributes;
    @ElementCollection
    @MapKeyColumn(name="BINDING_NAME")
    @Column(name="FLOW_ID", length=4000)
    @CollectionTable(name="CLIENT_AUTH_FLOW_BINDINGS", joinColumns={@JoinColumn(name="CLIENT_ID")})
    protected Map<String, String> authFlowBindings;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="client")
    Collection<ProtocolMapperEntity> protocolMappers;
    @Column(name="SURROGATE_AUTH_REQUIRED")
    private boolean surrogateAuthRequired;
    @Column(name="ROOT_URL")
    private String rootUrl;
    @Column(name="BASE_URL")
    private String baseUrl;
    @Column(name="MANAGEMENT_URL")
    private String managementUrl;
    @Column(name="BEARER_ONLY")
    private boolean bearerOnly;
    @Column(name="CONSENT_REQUIRED")
    private boolean consentRequired;
    @Column(name="STANDARD_FLOW_ENABLED")
    private boolean standardFlowEnabled;
    @Column(name="IMPLICIT_FLOW_ENABLED")
    private boolean implicitFlowEnabled;
    @Column(name="DIRECT_ACCESS_GRANTS_ENABLED")
    private boolean directAccessGrantsEnabled;
    @Column(name="SERVICE_ACCOUNTS_ENABLED")
    private boolean serviceAccountsEnabled;
    @Column(name="NODE_REREG_TIMEOUT")
    private int nodeReRegistrationTimeout;
    @ElementCollection
    @Column(name="ROLE_ID")
    @CollectionTable(name="SCOPE_MAPPING", joinColumns={@JoinColumn(name="CLIENT_ID")})
    private Set<String> scopeMappingIds;
    @ElementCollection
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE")
    @CollectionTable(name="CLIENT_NODE_REGISTRATIONS", joinColumns={@JoinColumn(name="CLIENT_ID")})
    Map<String, Integer> registeredNodes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public String getRealmId() {
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_write_realmId(realmId);
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getDescription() {
        return this.$$_hibernate_read_description();
    }

    public void setDescription(String description) {
        this.$$_hibernate_write_description(description);
    }

    public boolean isEnabled() {
        return this.$$_hibernate_read_enabled();
    }

    public void setEnabled(boolean enabled) {
        this.$$_hibernate_write_enabled(enabled);
    }

    public boolean isAlwaysDisplayInConsole() {
        return this.$$_hibernate_read_alwaysDisplayInConsole();
    }

    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        this.$$_hibernate_write_alwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    public String getClientId() {
        return this.$$_hibernate_read_clientId();
    }

    public void setClientId(String clientId) {
        this.$$_hibernate_write_clientId(clientId);
    }

    public Set<String> getWebOrigins() {
        if (this.$$_hibernate_read_webOrigins() == null) {
            this.$$_hibernate_write_webOrigins(new HashSet());
        }
        return this.$$_hibernate_read_webOrigins();
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.$$_hibernate_write_webOrigins(webOrigins);
    }

    public Set<String> getRedirectUris() {
        if (this.$$_hibernate_read_redirectUris() == null) {
            this.$$_hibernate_write_redirectUris(new HashSet());
        }
        return this.$$_hibernate_read_redirectUris();
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.$$_hibernate_write_redirectUris(redirectUris);
    }

    public String getClientAuthenticatorType() {
        return this.$$_hibernate_read_clientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.$$_hibernate_write_clientAuthenticatorType(clientAuthenticatorType);
    }

    public String getSecret() {
        return this.$$_hibernate_read_secret();
    }

    public void setSecret(String secret) {
        this.$$_hibernate_write_secret(secret);
    }

    public String getRegistrationToken() {
        return this.$$_hibernate_read_registrationToken();
    }

    public void setRegistrationToken(String registrationToken) {
        this.$$_hibernate_write_registrationToken(registrationToken);
    }

    public int getNotBefore() {
        return this.$$_hibernate_read_notBefore();
    }

    public void setNotBefore(int notBefore) {
        this.$$_hibernate_write_notBefore(notBefore);
    }

    public boolean isPublicClient() {
        return this.$$_hibernate_read_publicClient();
    }

    public void setPublicClient(boolean publicClient) {
        this.$$_hibernate_write_publicClient(publicClient);
    }

    public boolean isFullScopeAllowed() {
        return this.$$_hibernate_read_fullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean fullScopeAllowed) {
        this.$$_hibernate_write_fullScopeAllowed(fullScopeAllowed);
    }

    public Collection<ClientAttributeEntity> getAttributes() {
        if (this.$$_hibernate_read_attributes() == null) {
            this.$$_hibernate_write_attributes(new LinkedList());
        }
        return this.$$_hibernate_read_attributes();
    }

    public void setAttributes(Collection<ClientAttributeEntity> attributes) {
        this.$$_hibernate_write_attributes(attributes);
    }

    public Map<String, String> getAuthFlowBindings() {
        if (this.$$_hibernate_read_authFlowBindings() == null) {
            this.$$_hibernate_write_authFlowBindings(new HashMap());
        }
        return this.$$_hibernate_read_authFlowBindings();
    }

    public void setAuthFlowBindings(Map<String, String> authFlowBindings) {
        this.$$_hibernate_write_authFlowBindings(authFlowBindings);
    }

    public String getProtocol() {
        return this.$$_hibernate_read_protocol();
    }

    public void setProtocol(String protocol) {
        this.$$_hibernate_write_protocol(protocol);
    }

    public boolean isFrontchannelLogout() {
        return this.$$_hibernate_read_frontchannelLogout();
    }

    public void setFrontchannelLogout(boolean frontchannelLogout) {
        this.$$_hibernate_write_frontchannelLogout(frontchannelLogout);
    }

    public Collection<ProtocolMapperEntity> getProtocolMappers() {
        if (this.$$_hibernate_read_protocolMappers() == null) {
            this.$$_hibernate_write_protocolMappers(new LinkedList());
        }
        return this.$$_hibernate_read_protocolMappers();
    }

    public void setProtocolMappers(Collection<ProtocolMapperEntity> protocolMappers) {
        this.$$_hibernate_write_protocolMappers(protocolMappers);
    }

    public boolean isSurrogateAuthRequired() {
        return this.$$_hibernate_read_surrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.$$_hibernate_write_surrogateAuthRequired(surrogateAuthRequired);
    }

    public String getRootUrl() {
        return this.$$_hibernate_read_rootUrl();
    }

    public void setRootUrl(String rootUrl) {
        this.$$_hibernate_write_rootUrl(rootUrl);
    }

    public String getBaseUrl() {
        return this.$$_hibernate_read_baseUrl();
    }

    public void setBaseUrl(String baseUrl) {
        this.$$_hibernate_write_baseUrl(baseUrl);
    }

    public String getManagementUrl() {
        return this.$$_hibernate_read_managementUrl();
    }

    public void setManagementUrl(String managementUrl) {
        this.$$_hibernate_write_managementUrl(managementUrl);
    }

    public boolean isBearerOnly() {
        return this.$$_hibernate_read_bearerOnly();
    }

    public void setBearerOnly(boolean bearerOnly) {
        this.$$_hibernate_write_bearerOnly(bearerOnly);
    }

    public boolean isConsentRequired() {
        return this.$$_hibernate_read_consentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.$$_hibernate_write_consentRequired(consentRequired);
    }

    public boolean isStandardFlowEnabled() {
        return this.$$_hibernate_read_standardFlowEnabled();
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        this.$$_hibernate_write_standardFlowEnabled(standardFlowEnabled);
    }

    public boolean isImplicitFlowEnabled() {
        return this.$$_hibernate_read_implicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        this.$$_hibernate_write_implicitFlowEnabled(implicitFlowEnabled);
    }

    public boolean isDirectAccessGrantsEnabled() {
        return this.$$_hibernate_read_directAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        this.$$_hibernate_write_directAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public boolean isServiceAccountsEnabled() {
        return this.$$_hibernate_read_serviceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.$$_hibernate_write_serviceAccountsEnabled(serviceAccountsEnabled);
    }

    public int getNodeReRegistrationTimeout() {
        return this.$$_hibernate_read_nodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int nodeReRegistrationTimeout) {
        this.$$_hibernate_write_nodeReRegistrationTimeout(nodeReRegistrationTimeout);
    }

    public Map<String, Integer> getRegisteredNodes() {
        if (this.$$_hibernate_read_registeredNodes() == null) {
            this.$$_hibernate_write_registeredNodes(new HashMap());
        }
        return this.$$_hibernate_read_registeredNodes();
    }

    public void setRegisteredNodes(Map<String, Integer> registeredNodes) {
        this.$$_hibernate_write_registeredNodes(registeredNodes);
    }

    public Set<String> getScopeMappingIds() {
        if (this.$$_hibernate_read_scopeMappingIds() == null) {
            this.$$_hibernate_write_scopeMappingIds(new HashSet());
        }
        return this.$$_hibernate_read_scopeMappingIds();
    }

    public void setScopeMapping(Set<String> scopeMappingIds) {
        this.$$_hibernate_write_scopeMappingIds(scopeMappingIds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClientEntity)) {
            return false;
        }
        ClientEntity that = (ClientEntity)o;
        return this.$$_hibernate_read_id().equals(that.getId());
    }

    public int hashCode() {
        return this.$$_hibernate_read_id().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        ClientEntity clientEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block24: {
            int n2;
            block25: {
                int n3;
                int n4;
                int n5;
                int n6;
                ClientEntity clientEntity = this;
                ClientEntity clientEntity2 = clientEntity;
                ClientEntity clientEntity3 = clientEntity2;
                ClientEntity clientEntity4 = clientEntity3;
                ClientEntity clientEntity5 = clientEntity4;
                ClientEntity clientEntity6 = clientEntity5;
                ClientEntity clientEntity7 = clientEntity6;
                int n7 = 0;
                if (n7 == 0 && clientEntity6.$$_hibernate_collectionTracker != null) {
                    int n8 = clientEntity6.$$_hibernate_collectionTracker.getSize("webOrigins");
                    if (clientEntity6.webOrigins == null && n8 != -1) {
                        n7 = 1;
                    } else if (clientEntity6.webOrigins != null && (!(clientEntity6.webOrigins instanceof PersistentCollection) || ((PersistentCollection)clientEntity6.webOrigins).wasInitialized()) && n8 != clientEntity6.webOrigins.size()) {
                        n7 = 1;
                    }
                }
                if ((n6 = n7) == 0 && clientEntity5.$$_hibernate_collectionTracker != null) {
                    n7 = clientEntity5.$$_hibernate_collectionTracker.getSize("redirectUris");
                    if (clientEntity5.redirectUris == null && n7 != -1) {
                        n6 = 1;
                    } else if (clientEntity5.redirectUris != null && (!(clientEntity5.redirectUris instanceof PersistentCollection) || ((PersistentCollection)clientEntity5.redirectUris).wasInitialized()) && n7 != clientEntity5.redirectUris.size()) {
                        n6 = 1;
                    }
                }
                if ((n5 = n6) == 0 && clientEntity4.$$_hibernate_collectionTracker != null) {
                    n6 = clientEntity4.$$_hibernate_collectionTracker.getSize("attributes");
                    if (clientEntity4.attributes == null && n6 != -1) {
                        n5 = 1;
                    } else if (clientEntity4.attributes != null && (!(clientEntity4.attributes instanceof PersistentCollection) || ((PersistentCollection)clientEntity4.attributes).wasInitialized()) && n6 != clientEntity4.attributes.size()) {
                        n5 = 1;
                    }
                }
                if ((n4 = n5) == 0 && clientEntity3.$$_hibernate_collectionTracker != null) {
                    n5 = clientEntity3.$$_hibernate_collectionTracker.getSize("authFlowBindings");
                    if (clientEntity3.authFlowBindings == null && n5 != -1) {
                        n4 = 1;
                    } else if (clientEntity3.authFlowBindings != null && (!(clientEntity3.authFlowBindings instanceof PersistentCollection) || ((PersistentCollection)clientEntity3.authFlowBindings).wasInitialized()) && n5 != clientEntity3.authFlowBindings.size()) {
                        n4 = 1;
                    }
                }
                if ((n3 = n4) == 0 && clientEntity2.$$_hibernate_collectionTracker != null) {
                    n4 = clientEntity2.$$_hibernate_collectionTracker.getSize("protocolMappers");
                    if (clientEntity2.protocolMappers == null && n4 != -1) {
                        n3 = 1;
                    } else if (clientEntity2.protocolMappers != null && (!(clientEntity2.protocolMappers instanceof PersistentCollection) || ((PersistentCollection)clientEntity2.protocolMappers).wasInitialized()) && n4 != clientEntity2.protocolMappers.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && clientEntity.$$_hibernate_collectionTracker != null) {
                    n3 = clientEntity.$$_hibernate_collectionTracker.getSize("scopeMappingIds");
                    if (clientEntity.scopeMappingIds == null && n3 != -1) {
                        n2 = 1;
                    } else if (clientEntity.scopeMappingIds != null && (!(clientEntity.scopeMappingIds instanceof PersistentCollection) || ((PersistentCollection)clientEntity.scopeMappingIds).wasInitialized()) && n3 != clientEntity.scopeMappingIds.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block24;
                n2 = this.$$_hibernate_collectionTracker.getSize("registeredNodes");
                if (this.registeredNodes != null || n2 == -1) break block25;
                n = 1;
                break block24;
            }
            if (this.registeredNodes == null || this.registeredNodes instanceof PersistentCollection && !((PersistentCollection)this.registeredNodes).wasInitialized() || n2 == this.registeredNodes.size()) break block24;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block24: {
            int n;
            block25: {
                ClientEntity clientEntity = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                ClientEntity clientEntity2 = clientEntity;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                ClientEntity clientEntity3 = clientEntity2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                ClientEntity clientEntity4 = clientEntity3;
                DirtyTracker dirtyTracker5 = dirtyTracker4;
                ClientEntity clientEntity5 = clientEntity4;
                DirtyTracker dirtyTracker6 = dirtyTracker5;
                ClientEntity clientEntity6 = clientEntity5;
                DirtyTracker dirtyTracker7 = dirtyTracker6;
                ClientEntity clientEntity7 = clientEntity6;
                DirtyTracker dirtyTracker8 = dirtyTracker7;
                if (clientEntity6.$$_hibernate_collectionTracker != null) {
                    int n2 = clientEntity6.$$_hibernate_collectionTracker.getSize("webOrigins");
                    if (clientEntity6.webOrigins == null && n2 != -1) {
                        dirtyTracker7.add("webOrigins");
                    } else if (clientEntity6.webOrigins != null && (!(clientEntity6.webOrigins instanceof PersistentCollection) || ((PersistentCollection)clientEntity6.webOrigins).wasInitialized()) && n2 != clientEntity6.webOrigins.size()) {
                        dirtyTracker7.add("webOrigins");
                    }
                }
                if (clientEntity5.$$_hibernate_collectionTracker != null) {
                    int n3 = clientEntity5.$$_hibernate_collectionTracker.getSize("redirectUris");
                    if (clientEntity5.redirectUris == null && n3 != -1) {
                        dirtyTracker6.add("redirectUris");
                    } else if (clientEntity5.redirectUris != null && (!(clientEntity5.redirectUris instanceof PersistentCollection) || ((PersistentCollection)clientEntity5.redirectUris).wasInitialized()) && n3 != clientEntity5.redirectUris.size()) {
                        dirtyTracker6.add("redirectUris");
                    }
                }
                if (clientEntity4.$$_hibernate_collectionTracker != null) {
                    int n4 = clientEntity4.$$_hibernate_collectionTracker.getSize("attributes");
                    if (clientEntity4.attributes == null && n4 != -1) {
                        dirtyTracker5.add("attributes");
                    } else if (clientEntity4.attributes != null && (!(clientEntity4.attributes instanceof PersistentCollection) || ((PersistentCollection)clientEntity4.attributes).wasInitialized()) && n4 != clientEntity4.attributes.size()) {
                        dirtyTracker5.add("attributes");
                    }
                }
                if (clientEntity3.$$_hibernate_collectionTracker != null) {
                    int n5 = clientEntity3.$$_hibernate_collectionTracker.getSize("authFlowBindings");
                    if (clientEntity3.authFlowBindings == null && n5 != -1) {
                        dirtyTracker4.add("authFlowBindings");
                    } else if (clientEntity3.authFlowBindings != null && (!(clientEntity3.authFlowBindings instanceof PersistentCollection) || ((PersistentCollection)clientEntity3.authFlowBindings).wasInitialized()) && n5 != clientEntity3.authFlowBindings.size()) {
                        dirtyTracker4.add("authFlowBindings");
                    }
                }
                if (clientEntity2.$$_hibernate_collectionTracker != null) {
                    int n6 = clientEntity2.$$_hibernate_collectionTracker.getSize("protocolMappers");
                    if (clientEntity2.protocolMappers == null && n6 != -1) {
                        dirtyTracker3.add("protocolMappers");
                    } else if (clientEntity2.protocolMappers != null && (!(clientEntity2.protocolMappers instanceof PersistentCollection) || ((PersistentCollection)clientEntity2.protocolMappers).wasInitialized()) && n6 != clientEntity2.protocolMappers.size()) {
                        dirtyTracker3.add("protocolMappers");
                    }
                }
                if (clientEntity.$$_hibernate_collectionTracker != null) {
                    int n7 = clientEntity.$$_hibernate_collectionTracker.getSize("scopeMappingIds");
                    if (clientEntity.scopeMappingIds == null && n7 != -1) {
                        dirtyTracker2.add("scopeMappingIds");
                    } else if (clientEntity.scopeMappingIds != null && (!(clientEntity.scopeMappingIds instanceof PersistentCollection) || ((PersistentCollection)clientEntity.scopeMappingIds).wasInitialized()) && n7 != clientEntity.scopeMappingIds.size()) {
                        dirtyTracker2.add("scopeMappingIds");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block24;
                n = this.$$_hibernate_collectionTracker.getSize("registeredNodes");
                if (this.registeredNodes != null || n == -1) break block25;
                dirtyTracker.add("registeredNodes");
                break block24;
            }
            if (this.registeredNodes == null || this.registeredNodes instanceof PersistentCollection && !((PersistentCollection)this.registeredNodes).wasInitialized() || n == this.registeredNodes.size()) break block24;
            dirtyTracker.add("registeredNodes");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block21: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            ClientEntity clientEntity = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            ClientEntity clientEntity2 = clientEntity;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            ClientEntity clientEntity3 = clientEntity2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            ClientEntity clientEntity4 = clientEntity3;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor5 = lazyAttributeLoadingInterceptor4;
            ClientEntity clientEntity5 = clientEntity4;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor6 = lazyAttributeLoadingInterceptor5;
            ClientEntity clientEntity6 = clientEntity5;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor7 = lazyAttributeLoadingInterceptor6;
            ClientEntity clientEntity7 = clientEntity6;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor8 = lazyAttributeLoadingInterceptor7;
            if (lazyAttributeLoadingInterceptor7 == null || lazyAttributeLoadingInterceptor7.isAttributeLoaded("webOrigins")) {
                if (clientEntity6.webOrigins == null || clientEntity6.webOrigins instanceof PersistentCollection && !((PersistentCollection)clientEntity6.webOrigins).wasInitialized()) {
                    clientEntity6.$$_hibernate_collectionTracker.add("webOrigins", -1);
                } else {
                    clientEntity6.$$_hibernate_collectionTracker.add("webOrigins", clientEntity6.webOrigins.size());
                }
            }
            if (lazyAttributeLoadingInterceptor6 == null || lazyAttributeLoadingInterceptor6.isAttributeLoaded("redirectUris")) {
                if (clientEntity5.redirectUris == null || clientEntity5.redirectUris instanceof PersistentCollection && !((PersistentCollection)clientEntity5.redirectUris).wasInitialized()) {
                    clientEntity5.$$_hibernate_collectionTracker.add("redirectUris", -1);
                } else {
                    clientEntity5.$$_hibernate_collectionTracker.add("redirectUris", clientEntity5.redirectUris.size());
                }
            }
            if (lazyAttributeLoadingInterceptor5 == null || lazyAttributeLoadingInterceptor5.isAttributeLoaded("attributes")) {
                if (clientEntity4.attributes == null || clientEntity4.attributes instanceof PersistentCollection && !((PersistentCollection)clientEntity4.attributes).wasInitialized()) {
                    clientEntity4.$$_hibernate_collectionTracker.add("attributes", -1);
                } else {
                    clientEntity4.$$_hibernate_collectionTracker.add("attributes", clientEntity4.attributes.size());
                }
            }
            if (lazyAttributeLoadingInterceptor4 == null || lazyAttributeLoadingInterceptor4.isAttributeLoaded("authFlowBindings")) {
                if (clientEntity3.authFlowBindings == null || clientEntity3.authFlowBindings instanceof PersistentCollection && !((PersistentCollection)clientEntity3.authFlowBindings).wasInitialized()) {
                    clientEntity3.$$_hibernate_collectionTracker.add("authFlowBindings", -1);
                } else {
                    clientEntity3.$$_hibernate_collectionTracker.add("authFlowBindings", clientEntity3.authFlowBindings.size());
                }
            }
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("protocolMappers")) {
                if (clientEntity2.protocolMappers == null || clientEntity2.protocolMappers instanceof PersistentCollection && !((PersistentCollection)clientEntity2.protocolMappers).wasInitialized()) {
                    clientEntity2.$$_hibernate_collectionTracker.add("protocolMappers", -1);
                } else {
                    clientEntity2.$$_hibernate_collectionTracker.add("protocolMappers", clientEntity2.protocolMappers.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("scopeMappingIds")) {
                if (clientEntity.scopeMappingIds == null || clientEntity.scopeMappingIds instanceof PersistentCollection && !((PersistentCollection)clientEntity.scopeMappingIds).wasInitialized()) {
                    clientEntity.$$_hibernate_collectionTracker.add("scopeMappingIds", -1);
                } else {
                    clientEntity.$$_hibernate_collectionTracker.add("scopeMappingIds", clientEntity.scopeMappingIds.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("registeredNodes")) break block21;
            if (this.registeredNodes == null || this.registeredNodes instanceof PersistentCollection && !((PersistentCollection)this.registeredNodes).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("registeredNodes", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("registeredNodes", this.registeredNodes.size());
            }
        }
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!Objects.deepEquals(string, this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (!Objects.deepEquals(string, this.description)) {
            this.$$_hibernate_trackChange("description");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (!Objects.deepEquals(string, this.clientId)) {
            this.$$_hibernate_trackChange("clientId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public boolean $$_hibernate_read_enabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "enabled", this.enabled);
        }
        return this.enabled;
    }

    public void $$_hibernate_write_enabled(boolean bl) {
        if (bl - this.enabled != 0) {
            this.$$_hibernate_trackChange("enabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "enabled", this.enabled, bl);
            return;
        }
        this.enabled = bl;
    }

    public boolean $$_hibernate_read_alwaysDisplayInConsole() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.alwaysDisplayInConsole = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "alwaysDisplayInConsole", this.alwaysDisplayInConsole);
        }
        return this.alwaysDisplayInConsole;
    }

    public void $$_hibernate_write_alwaysDisplayInConsole(boolean bl) {
        if (bl - this.alwaysDisplayInConsole != 0) {
            this.$$_hibernate_trackChange("alwaysDisplayInConsole");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.alwaysDisplayInConsole = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "alwaysDisplayInConsole", this.alwaysDisplayInConsole, bl);
            return;
        }
        this.alwaysDisplayInConsole = bl;
    }

    public String $$_hibernate_read_secret() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.secret = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "secret", (Object)this.secret);
        }
        return this.secret;
    }

    public void $$_hibernate_write_secret(String string) {
        if (!Objects.deepEquals(string, this.secret)) {
            this.$$_hibernate_trackChange("secret");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.secret = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "secret", (Object)this.secret, (Object)string);
            return;
        }
        this.secret = string;
    }

    public String $$_hibernate_read_registrationToken() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registrationToken = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "registrationToken", (Object)this.registrationToken);
        }
        return this.registrationToken;
    }

    public void $$_hibernate_write_registrationToken(String string) {
        if (!Objects.deepEquals(string, this.registrationToken)) {
            this.$$_hibernate_trackChange("registrationToken");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registrationToken = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "registrationToken", (Object)this.registrationToken, (Object)string);
            return;
        }
        this.registrationToken = string;
    }

    public String $$_hibernate_read_clientAuthenticatorType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientAuthenticatorType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientAuthenticatorType", (Object)this.clientAuthenticatorType);
        }
        return this.clientAuthenticatorType;
    }

    public void $$_hibernate_write_clientAuthenticatorType(String string) {
        if (!Objects.deepEquals(string, this.clientAuthenticatorType)) {
            this.$$_hibernate_trackChange("clientAuthenticatorType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientAuthenticatorType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientAuthenticatorType", (Object)this.clientAuthenticatorType, (Object)string);
            return;
        }
        this.clientAuthenticatorType = string;
    }

    public int $$_hibernate_read_notBefore() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notBefore = this.$$_hibernate_getInterceptor().readInt((Object)this, "notBefore", this.notBefore);
        }
        return this.notBefore;
    }

    public void $$_hibernate_write_notBefore(int n) {
        if (n - this.notBefore != 0) {
            this.$$_hibernate_trackChange("notBefore");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notBefore = this.$$_hibernate_getInterceptor().writeInt((Object)this, "notBefore", this.notBefore, n);
            return;
        }
        this.notBefore = n;
    }

    public boolean $$_hibernate_read_publicClient() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.publicClient = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "publicClient", this.publicClient);
        }
        return this.publicClient;
    }

    public void $$_hibernate_write_publicClient(boolean bl) {
        if (bl - this.publicClient != 0) {
            this.$$_hibernate_trackChange("publicClient");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.publicClient = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "publicClient", this.publicClient, bl);
            return;
        }
        this.publicClient = bl;
    }

    public String $$_hibernate_read_protocol() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocol = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "protocol", (Object)this.protocol);
        }
        return this.protocol;
    }

    public void $$_hibernate_write_protocol(String string) {
        if (!Objects.deepEquals(string, this.protocol)) {
            this.$$_hibernate_trackChange("protocol");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocol = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "protocol", (Object)this.protocol, (Object)string);
            return;
        }
        this.protocol = string;
    }

    public boolean $$_hibernate_read_frontchannelLogout() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.frontchannelLogout = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "frontchannelLogout", this.frontchannelLogout);
        }
        return this.frontchannelLogout;
    }

    public void $$_hibernate_write_frontchannelLogout(boolean bl) {
        if (bl - this.frontchannelLogout != 0) {
            this.$$_hibernate_trackChange("frontchannelLogout");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.frontchannelLogout = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "frontchannelLogout", this.frontchannelLogout, bl);
            return;
        }
        this.frontchannelLogout = bl;
    }

    public boolean $$_hibernate_read_fullScopeAllowed() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.fullScopeAllowed = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "fullScopeAllowed", this.fullScopeAllowed);
        }
        return this.fullScopeAllowed;
    }

    public void $$_hibernate_write_fullScopeAllowed(boolean bl) {
        if (bl - this.fullScopeAllowed != 0) {
            this.$$_hibernate_trackChange("fullScopeAllowed");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.fullScopeAllowed = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "fullScopeAllowed", this.fullScopeAllowed, bl);
            return;
        }
        this.fullScopeAllowed = bl;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (!Objects.deepEquals(string, this.realmId)) {
            this.$$_hibernate_trackChange("realmId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public Set $$_hibernate_read_webOrigins() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.webOrigins = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "webOrigins", this.webOrigins);
        }
        return this.webOrigins;
    }

    public void $$_hibernate_write_webOrigins(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.webOrigins = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "webOrigins", this.webOrigins, (Object)set);
            return;
        }
        this.webOrigins = set;
    }

    public Set $$_hibernate_read_redirectUris() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.redirectUris = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "redirectUris", this.redirectUris);
        }
        return this.redirectUris;
    }

    public void $$_hibernate_write_redirectUris(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.redirectUris = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "redirectUris", this.redirectUris, (Object)set);
            return;
        }
        this.redirectUris = set;
    }

    public Collection $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)collection);
            return;
        }
        this.attributes = collection;
    }

    public Map $$_hibernate_read_authFlowBindings() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authFlowBindings = (Map)this.$$_hibernate_getInterceptor().readObject((Object)this, "authFlowBindings", this.authFlowBindings);
        }
        return this.authFlowBindings;
    }

    public void $$_hibernate_write_authFlowBindings(Map map) {
        if (!Objects.deepEquals(map, this.authFlowBindings)) {
            this.$$_hibernate_trackChange("authFlowBindings");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authFlowBindings = (Map)this.$$_hibernate_getInterceptor().writeObject((Object)this, "authFlowBindings", this.authFlowBindings, (Object)map);
            return;
        }
        this.authFlowBindings = map;
    }

    public Collection $$_hibernate_read_protocolMappers() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocolMappers = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "protocolMappers", this.protocolMappers);
        }
        return this.protocolMappers;
    }

    public void $$_hibernate_write_protocolMappers(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocolMappers = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "protocolMappers", this.protocolMappers, (Object)collection);
            return;
        }
        this.protocolMappers = collection;
    }

    public boolean $$_hibernate_read_surrogateAuthRequired() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.surrogateAuthRequired = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "surrogateAuthRequired", this.surrogateAuthRequired);
        }
        return this.surrogateAuthRequired;
    }

    public void $$_hibernate_write_surrogateAuthRequired(boolean bl) {
        if (bl - this.surrogateAuthRequired != 0) {
            this.$$_hibernate_trackChange("surrogateAuthRequired");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.surrogateAuthRequired = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "surrogateAuthRequired", this.surrogateAuthRequired, bl);
            return;
        }
        this.surrogateAuthRequired = bl;
    }

    public String $$_hibernate_read_rootUrl() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rootUrl = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "rootUrl", (Object)this.rootUrl);
        }
        return this.rootUrl;
    }

    public void $$_hibernate_write_rootUrl(String string) {
        if (!Objects.deepEquals(string, this.rootUrl)) {
            this.$$_hibernate_trackChange("rootUrl");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rootUrl = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "rootUrl", (Object)this.rootUrl, (Object)string);
            return;
        }
        this.rootUrl = string;
    }

    public String $$_hibernate_read_baseUrl() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.baseUrl = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "baseUrl", (Object)this.baseUrl);
        }
        return this.baseUrl;
    }

    public void $$_hibernate_write_baseUrl(String string) {
        if (!Objects.deepEquals(string, this.baseUrl)) {
            this.$$_hibernate_trackChange("baseUrl");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.baseUrl = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "baseUrl", (Object)this.baseUrl, (Object)string);
            return;
        }
        this.baseUrl = string;
    }

    public String $$_hibernate_read_managementUrl() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.managementUrl = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "managementUrl", (Object)this.managementUrl);
        }
        return this.managementUrl;
    }

    public void $$_hibernate_write_managementUrl(String string) {
        if (!Objects.deepEquals(string, this.managementUrl)) {
            this.$$_hibernate_trackChange("managementUrl");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.managementUrl = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "managementUrl", (Object)this.managementUrl, (Object)string);
            return;
        }
        this.managementUrl = string;
    }

    public boolean $$_hibernate_read_bearerOnly() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.bearerOnly = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "bearerOnly", this.bearerOnly);
        }
        return this.bearerOnly;
    }

    public void $$_hibernate_write_bearerOnly(boolean bl) {
        if (bl - this.bearerOnly != 0) {
            this.$$_hibernate_trackChange("bearerOnly");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.bearerOnly = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "bearerOnly", this.bearerOnly, bl);
            return;
        }
        this.bearerOnly = bl;
    }

    public boolean $$_hibernate_read_consentRequired() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.consentRequired = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "consentRequired", this.consentRequired);
        }
        return this.consentRequired;
    }

    public void $$_hibernate_write_consentRequired(boolean bl) {
        if (bl - this.consentRequired != 0) {
            this.$$_hibernate_trackChange("consentRequired");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.consentRequired = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "consentRequired", this.consentRequired, bl);
            return;
        }
        this.consentRequired = bl;
    }

    public boolean $$_hibernate_read_standardFlowEnabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.standardFlowEnabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "standardFlowEnabled", this.standardFlowEnabled);
        }
        return this.standardFlowEnabled;
    }

    public void $$_hibernate_write_standardFlowEnabled(boolean bl) {
        if (bl - this.standardFlowEnabled != 0) {
            this.$$_hibernate_trackChange("standardFlowEnabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.standardFlowEnabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "standardFlowEnabled", this.standardFlowEnabled, bl);
            return;
        }
        this.standardFlowEnabled = bl;
    }

    public boolean $$_hibernate_read_implicitFlowEnabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.implicitFlowEnabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "implicitFlowEnabled", this.implicitFlowEnabled);
        }
        return this.implicitFlowEnabled;
    }

    public void $$_hibernate_write_implicitFlowEnabled(boolean bl) {
        if (bl - this.implicitFlowEnabled != 0) {
            this.$$_hibernate_trackChange("implicitFlowEnabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.implicitFlowEnabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "implicitFlowEnabled", this.implicitFlowEnabled, bl);
            return;
        }
        this.implicitFlowEnabled = bl;
    }

    public boolean $$_hibernate_read_directAccessGrantsEnabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.directAccessGrantsEnabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "directAccessGrantsEnabled", this.directAccessGrantsEnabled);
        }
        return this.directAccessGrantsEnabled;
    }

    public void $$_hibernate_write_directAccessGrantsEnabled(boolean bl) {
        if (bl - this.directAccessGrantsEnabled != 0) {
            this.$$_hibernate_trackChange("directAccessGrantsEnabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.directAccessGrantsEnabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "directAccessGrantsEnabled", this.directAccessGrantsEnabled, bl);
            return;
        }
        this.directAccessGrantsEnabled = bl;
    }

    public boolean $$_hibernate_read_serviceAccountsEnabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceAccountsEnabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "serviceAccountsEnabled", this.serviceAccountsEnabled);
        }
        return this.serviceAccountsEnabled;
    }

    public void $$_hibernate_write_serviceAccountsEnabled(boolean bl) {
        if (bl - this.serviceAccountsEnabled != 0) {
            this.$$_hibernate_trackChange("serviceAccountsEnabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceAccountsEnabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "serviceAccountsEnabled", this.serviceAccountsEnabled, bl);
            return;
        }
        this.serviceAccountsEnabled = bl;
    }

    public int $$_hibernate_read_nodeReRegistrationTimeout() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.nodeReRegistrationTimeout = this.$$_hibernate_getInterceptor().readInt((Object)this, "nodeReRegistrationTimeout", this.nodeReRegistrationTimeout);
        }
        return this.nodeReRegistrationTimeout;
    }

    public void $$_hibernate_write_nodeReRegistrationTimeout(int n) {
        if (n - this.nodeReRegistrationTimeout != 0) {
            this.$$_hibernate_trackChange("nodeReRegistrationTimeout");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.nodeReRegistrationTimeout = this.$$_hibernate_getInterceptor().writeInt((Object)this, "nodeReRegistrationTimeout", this.nodeReRegistrationTimeout, n);
            return;
        }
        this.nodeReRegistrationTimeout = n;
    }

    public Set $$_hibernate_read_scopeMappingIds() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopeMappingIds = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "scopeMappingIds", this.scopeMappingIds);
        }
        return this.scopeMappingIds;
    }

    public void $$_hibernate_write_scopeMappingIds(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopeMappingIds = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "scopeMappingIds", this.scopeMappingIds, (Object)set);
            return;
        }
        this.scopeMappingIds = set;
    }

    public Map $$_hibernate_read_registeredNodes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registeredNodes = (Map)this.$$_hibernate_getInterceptor().readObject((Object)this, "registeredNodes", this.registeredNodes);
        }
        return this.registeredNodes;
    }

    public void $$_hibernate_write_registeredNodes(Map map) {
        if (!Objects.deepEquals(map, this.registeredNodes)) {
            this.$$_hibernate_trackChange("registeredNodes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registeredNodes = (Map)this.$$_hibernate_getInterceptor().writeObject((Object)this, "registeredNodes", this.registeredNodes, (Object)map);
            return;
        }
        this.registeredNodes = map;
    }
}

