/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.quarkus.vertx.core.runtime.VertxLocalsHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.future.FailedFuture;
import io.vertx.core.impl.future.PromiseImpl;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import java.util.List;

abstract class AbstractContext
implements ContextInternal {
    final boolean disableTCCL;

    public AbstractContext(boolean disableTCCL) {
        this.disableTCCL = disableTCCL;
    }

    public abstract boolean isEventLoopContext();

    public final boolean isRunningOnContext() {
        return Vertx.currentContext() == this && this.inThread();
    }

    abstract boolean inThread();

    public boolean isWorkerContext() {
        return !this.isEventLoopContext();
    }

    public void emit(Handler<Void> task) {
        this.emit(null, task);
    }

    public final void execute(Handler<Void> task) {
        this.execute(null, task);
    }

    public final void dispatch(Handler<Void> handler) {
        this.dispatch(null, handler);
    }

    public final ContextInternal beginDispatch() {
        VertxThread th = (VertxThread)Thread.currentThread();
        ContextInternal prev = th.beginEmission((ContextInternal)this);
        if (!this.disableTCCL) {
            th.setContextClassLoader(this.classLoader());
        }
        return prev;
    }

    public final void endDispatch(ContextInternal previous) {
        VertxThread th = (VertxThread)Thread.currentThread();
        if (!this.disableTCCL) {
            th.setContextClassLoader(previous != null ? previous.classLoader() : null);
        }
        th.endEmission(previous);
    }

    public long setPeriodic(long delay, Handler<Long> handler) {
        VertxImpl owner = (VertxImpl)this.owner();
        return owner.scheduleTimeout((ContextInternal)this, handler, delay, true);
    }

    public long setTimer(long delay, Handler<Long> handler) {
        VertxImpl owner = (VertxImpl)this.owner();
        return owner.scheduleTimeout((ContextInternal)this, handler, delay, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void dispatch(T event, Handler<T> handler) {
        ContextInternal prev = this.beginDispatch();
        try {
            handler.handle(event);
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatch(Runnable handler) {
        ContextInternal prev = this.beginDispatch();
        try {
            handler.run();
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    public final List<String> processArgs() {
        return VertxCommandLauncher.getProcessArguments();
    }

    public final <T> void executeBlockingInternal(Handler<Promise<T>> action, Handler<AsyncResult<T>> resultHandler) {
        Future fut = this.executeBlockingInternal(action);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    public <T> void executeBlockingInternal(Handler<Promise<T>> action, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future fut = this.executeBlockingInternal(action, ordered);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future fut = this.executeBlocking(blockingCodeHandler, ordered);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue, Handler<AsyncResult<T>> resultHandler) {
        Future fut = this.executeBlocking(blockingCodeHandler, queue);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    public final <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    public <T> PromiseInternal<T> promise() {
        return new PromiseImpl((ContextInternal)this);
    }

    public <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        PromiseInternal<T> promise;
        if (handler instanceof PromiseInternal && (promise = (PromiseInternal<T>)handler).context() != null) {
            return promise;
        }
        promise = this.promise();
        promise.future().onComplete(handler);
        return promise;
    }

    public <T> Future<T> succeededFuture() {
        return new SucceededFuture((ContextInternal)this, null);
    }

    public <T> Future<T> succeededFuture(T result) {
        return new SucceededFuture((ContextInternal)this, result);
    }

    public <T> Future<T> failedFuture(Throwable failure) {
        return new FailedFuture((ContextInternal)this, failure);
    }

    public <T> Future<T> failedFuture(String message) {
        return new FailedFuture((ContextInternal)this, message);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T get(Object object) {
        void key;
        VertxLocalsHelper.throwOnRootContextAccess();
        return (T)this.contextData().get(key);
    }

    /*
     * WARNING - void declaration
     */
    public final void put(Object object, Object object2) {
        void value;
        void key;
        VertxLocalsHelper.throwOnRootContextAccess();
        this.contextData().put(key, value);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(Object object) {
        void key;
        VertxLocalsHelper.throwOnRootContextAccess();
        return this.contextData().remove(key) != null;
    }

    public final <T> T getLocal(Object object) {
        return (T)VertxLocalsHelper.getLocal((ContextInternal)this, (Object)object);
    }

    public final void putLocal(Object object, Object object2) {
        VertxLocalsHelper.putLocal((ContextInternal)this, (Object)object, (Object)object2);
    }

    public final boolean removeLocal(Object object) {
        return VertxLocalsHelper.removeLocal((ContextInternal)this, (Object)object);
    }

    private static <T> void setResultHandler(ContextInternal ctx, Future<T> fut, Handler<AsyncResult<T>> resultHandler) {
        if (resultHandler != null) {
            fut.onComplete(resultHandler);
        } else {
            fut.onFailure(arg_0 -> ((ContextInternal)ctx).reportException(arg_0));
        }
    }
}

