/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.PKCSException;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.impl.ASN1Registry;

public class PKCS10Request {
    private X500Name subject;
    private SubjectPublicKeyInfo publicKeyInfo;
    private List<Attribute> attributes;
    private transient PKCS10CertificationRequest signedRequest;

    public PKCS10Request(X500Name subject2, SubjectPublicKeyInfo publicKeyInfo, List<Attribute> attrs) {
        this.subject = subject2;
        this.publicKeyInfo = publicKeyInfo;
        this.attributes = attrs;
    }

    public PKCS10Request(X500Name subject2, PublicKey publicKey, List<Attribute> attrs) {
        this.subject = subject2;
        this.publicKeyInfo = PKCS10Request.makePublicKeyInfo(publicKey);
        this.attributes = attrs;
    }

    public PKCS10Request(CertificationRequest req) {
        this.subject = req.getCertificationRequestInfo().getSubject();
        this.publicKeyInfo = req.getCertificationRequestInfo().getSubjectPublicKeyInfo();
        this.setAttributes(req.getCertificationRequestInfo().getAttributes());
        this.signedRequest = new PKCS10CertificationRequest(req);
    }

    public PKCS10Request(byte[] bytes) {
        this(CertificationRequest.getInstance((Object)bytes));
    }

    public PKCS10Request(ASN1Sequence sequence) {
        this(CertificationRequest.getInstance((Object)sequence));
    }

    private void resetSignedRequest() {
        if (this.signedRequest == null) {
            return;
        }
        CertificationRequest req = this.signedRequest.toASN1Structure();
        CertificationRequestInfo reqInfo = new CertificationRequestInfo(this.subject, this.publicKeyInfo, req.getCertificationRequestInfo().getAttributes());
        ASN1Sequence seq = (ASN1Sequence)req.toASN1Primitive();
        req = new CertificationRequest(reqInfo, (AlgorithmIdentifier)seq.getObjectAt(1), (DERBitString)seq.getObjectAt(2));
        this.signedRequest = new PKCS10CertificationRequest(req);
    }

    public PKCS10CertificationRequest sign(PrivateKey privateKey, AlgorithmIdentifier signatureAlg) throws NoSuchAlgorithmException, InvalidKeyException {
        PKCS10Signer signer = new PKCS10Signer(privateKey, signatureAlg);
        this.signedRequest = this.newBuilder().build((ContentSigner)signer);
        return this.signedRequest;
    }

    public PKCS10CertificationRequest sign(PrivateKey privateKey, String digestAlg) throws NoSuchAlgorithmException, InvalidKeyException {
        String sigAlg = digestAlg + "WITH" + this.getPublicKeyAlgorithm();
        return this.sign(privateKey, new DefaultSignatureAlgorithmIdentifierFinder().find(sigAlg));
    }

    public boolean verify(PublicKey publicKey) throws InvalidKeyException {
        if (this.signedRequest == null) {
            throw new IllegalStateException("no signed request");
        }
        try {
            PKCS10VerifierProvider verifier = new PKCS10VerifierProvider(publicKey);
            return this.signedRequest.isSignatureValid((ContentVerifierProvider)verifier);
        }
        catch (PKCSException e) {
            throw new InvalidKeyException(e);
        }
    }

    private PKCS10CertificationRequestBuilder newBuilder() {
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(this.subject, this.publicKeyInfo);
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                builder.addAttribute(attribute.getAttrType(), attribute.getAttributeValues());
            }
        }
        return builder;
    }

    private static SubjectPublicKeyInfo makePublicKeyInfo(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        return SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
    }

    public ASN1Sequence toASN1Structure() {
        if (this.signedRequest == null) {
            return new DLSequence();
        }
        return ASN1Sequence.getInstance((Object)this.signedRequest.toASN1Structure());
    }

    public void setSubject(X500Name subject2) {
        this.subject = subject2;
        this.resetSignedRequest();
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKeyInfo = PKCS10Request.makePublicKeyInfo(publicKey);
        this.resetSignedRequest();
    }

    private String getPublicKeyAlgorithm() {
        if (this.publicKeyInfo == null) {
            throw new IllegalStateException("no public key info");
        }
        AlgorithmIdentifier algId = this.publicKeyInfo.getAlgorithm();
        return ASN1Registry.oid2sym(algId.getAlgorithm());
    }

    public PublicKey generatePublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        AsymmetricKeyParameter keyParams = PublicKeyFactory.createKey((SubjectPublicKeyInfo)this.publicKeyInfo);
        if (keyParams instanceof RSAKeyParameters) {
            RSAKeyParameters rsa = (RSAKeyParameters)keyParams;
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsa.getModulus(), rsa.getExponent());
            KeyFactory keyFactory = SecurityHelper.getKeyFactory("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        if (keyParams instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dsa = (DSAPublicKeyParameters)keyParams;
            DSAParameters params2 = dsa.getParameters();
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(dsa.getY(), params2.getP(), params2.getQ(), params2.getG());
            KeyFactory keyFactory = SecurityHelper.getKeyFactory("DSA");
            return keyFactory.generatePublic(keySpec);
        }
        if (keyParams instanceof ECPublicKeyParameters) {
            ECPublicKeyParameters ec = (ECPublicKeyParameters)keyParams;
            ECDomainParameters ecParams = ec.getParameters();
            ECParameterSpec params3 = new ECParameterSpec(ecParams.getCurve(), ecParams.getG(), ecParams.getN(), ecParams.getH(), ecParams.getSeed());
            ECPublicKeySpec keySpec = new ECPublicKeySpec(ec.getQ(), params3);
            KeyFactory keyFactory = SecurityHelper.getKeyFactory("EC");
            return keyFactory.generatePublic((KeySpec)keySpec);
        }
        throw new IllegalStateException("could not generate public key for request, params type: " + keyParams);
    }

    public Attribute[] getAttributes() {
        return this.signedRequest != null ? this.signedRequest.getAttributes() : this.attributes.toArray(new Attribute[this.attributes.size()]);
    }

    public void setAttributes(List<Attribute> attrs) {
        this.attributes = attrs;
    }

    private void setAttributes(ASN1Set attrs) {
        this.attributes = new ArrayList<Attribute>();
        Enumeration e = attrs.getObjects();
        while (e.hasMoreElements()) {
            this.addAttribute(Attribute.getInstance(e.nextElement()));
        }
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public BigInteger getVersion() {
        if (this.signedRequest == null) {
            return null;
        }
        return this.signedRequest.toASN1Structure().getCertificationRequestInfo().getVersion().getValue();
    }

    private static class SignatureOutputStream
    extends OutputStream {
        private final Signature signature;

        SignatureOutputStream(Signature signature) {
            this.signature = signature;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.signature.update(bytes, off, len);
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.signature.update(bytes);
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.signature.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
        }
    }

    private static class PKCS10Verifier
    implements ContentVerifier {
        final AlgorithmIdentifier signatureAlg;
        final Signature signature;
        private final SignatureOutputStream out;

        public PKCS10Verifier(PublicKey publicKey, AlgorithmIdentifier signatureAlg) throws NoSuchAlgorithmException, InvalidKeyException {
            this.signatureAlg = signatureAlg;
            this.signature = SecurityHelper.getSignature(signatureAlg.getAlgorithm().getId());
            this.signature.initVerify(publicKey);
            this.out = new SignatureOutputStream(this.signature);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.signatureAlg;
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public boolean verify(byte[] expected) {
            try {
                return this.signature.verify(expected);
            }
            catch (SignatureException e) {
                throw new RuntimeException("Could not verify signature: " + e);
            }
        }
    }

    private static class PKCS10VerifierProvider
    implements ContentVerifierProvider {
        final PublicKey publicKey;

        PKCS10VerifierProvider(PublicKey key) {
            this.publicKey = key;
        }

        public ContentVerifier get(AlgorithmIdentifier sigAlg) {
            try {
                return new PKCS10Verifier(this.publicKey, sigAlg);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create content verifier: " + e);
            }
        }

        public boolean hasAssociatedCertificate() {
            return false;
        }

        public X509CertificateHolder getAssociatedCertificate() {
            return null;
        }
    }

    private static class PKCS10Signer
    implements ContentSigner {
        final AlgorithmIdentifier signatureAlg;
        final Signature signature;
        private final SignatureOutputStream out;

        PKCS10Signer(PrivateKey privateKey, AlgorithmIdentifier signatureAlg) throws NoSuchAlgorithmException, InvalidKeyException {
            this.signatureAlg = signatureAlg;
            this.signature = SecurityHelper.getSignature(signatureAlg.getAlgorithm().getId());
            this.signature.initSign(privateKey);
            this.out = new SignatureOutputStream(this.signature);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.signatureAlg;
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public byte[] getSignature() {
            try {
                return this.signature.sign();
            }
            catch (SignatureException e) {
                throw new RuntimeException("Could not read signature: " + e);
            }
        }
    }
}

