/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import org.GNOME.Accessibility.AtkComponent;
import org.GNOME.Accessibility.AtkUtil;

public class AtkImage {
    WeakReference<AccessibleContext> _ac;
    WeakReference<AccessibleIcon[]> _acc_icons;

    public AtkImage(AccessibleContext accessibleContext) {
        this._ac = new WeakReference<AccessibleContext>(accessibleContext);
        this._acc_icons = new WeakReference<AccessibleIcon[]>(accessibleContext.getAccessibleIcon());
    }

    public static AtkImage createAtkImage(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkImage(accessibleContext), null);
    }

    public Point get_image_position(int n) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
            if (accessibleComponent == null) {
                return null;
            }
            return AtkComponent.getComponentOrigin(accessibleContext, accessibleComponent, n);
        }, null);
    }

    public String get_image_description() {
        AccessibleIcon[] accessibleIconArray = (AccessibleIcon[])this._acc_icons.get();
        if (accessibleIconArray == null) {
            return "";
        }
        return AtkUtil.invokeInSwing(() -> {
            String string = "";
            if (accessibleIconArray != null && accessibleIconArray.length > 0 && (string = accessibleIconArray[0].getAccessibleIconDescription()) == null) {
                string = "";
            }
            return string;
        }, "");
    }

    public Dimension get_image_size() {
        Dimension dimension = new Dimension(0, 0);
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return dimension;
        }
        AccessibleIcon[] accessibleIconArray = (AccessibleIcon[])this._acc_icons.get();
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleIconArray != null && accessibleIconArray.length > 0) {
                dimension.height = accessibleIconArray[0].getAccessibleIconHeight();
                dimension.width = accessibleIconArray[0].getAccessibleIconWidth();
            } else {
                Rectangle rectangle;
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null && (rectangle = accessibleComponent.getBounds()) != null) {
                    dimension.height = rectangle.height;
                    dimension.width = rectangle.width;
                }
            }
            return dimension;
        }, dimension);
    }
}

