/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen.entry;

import jadx.core.utils.android.TextResMapFile;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.ProtoValue;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.RawValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesParser
extends ParserConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ValuesParser.class);
    private static Map<Integer, String> androidResMap;
    private final String[] strings;
    private final Map<Integer, String> resMap;

    public ValuesParser(String[] strings, Map<Integer, String> resMap) {
        this.strings = strings;
        this.resMap = resMap;
        ValuesParser.getAndroidResMap();
    }

    public static Map<Integer, String> getAndroidResMap() {
        if (androidResMap == null) {
            androidResMap = ValuesParser.loadAndroidResMap();
        }
        return androidResMap;
    }

    private static Map<Integer, String> loadAndroidResMap() {
        Map<Integer, String> map;
        block8: {
            InputStream is = ValuesParser.class.getResourceAsStream("/android/res-map.txt");
            try {
                map = TextResMapFile.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JadxRuntimeException("Failed to load android resource file", e);
                }
            }
            is.close();
        }
        return map;
    }

    @Nullable
    public String getSimpleValueString(ResourceEntry ri) {
        ProtoValue protoValue = ri.getProtoValue();
        if (protoValue != null) {
            return protoValue.getValue();
        }
        RawValue simpleValue = ri.getSimpleValue();
        if (simpleValue == null) {
            return null;
        }
        return this.decodeValue(simpleValue);
    }

    @Nullable
    public String getValueString(ResourceEntry ri) {
        ProtoValue protoValue = ri.getProtoValue();
        if (protoValue != null) {
            if (protoValue.getValue() != null) {
                return protoValue.getValue();
            }
            List<ProtoValue> values = protoValue.getNamedValues();
            ArrayList<String> strList = new ArrayList<String>(values.size());
            for (ProtoValue value : values) {
                if (value.getName() == null) {
                    strList.add(value.getValue());
                    continue;
                }
                strList.add(value.getName() + '=' + value.getValue());
            }
            return ((Object)strList).toString();
        }
        RawValue simpleValue = ri.getSimpleValue();
        if (simpleValue != null) {
            return this.decodeValue(simpleValue);
        }
        List<RawNamedValue> namedValues = ri.getNamedValues();
        ArrayList<String> strList = new ArrayList<String>(namedValues.size());
        for (RawNamedValue value : namedValues) {
            String nameStr = this.decodeNameRef(value.getNameRef());
            String valueStr = this.decodeValue(value.getRawValue());
            if (nameStr == null) {
                strList.add(valueStr);
                continue;
            }
            strList.add(nameStr + '=' + valueStr);
        }
        return ((Object)strList).toString();
    }

    @Nullable
    public String decodeValue(RawValue value) {
        int dataType = value.getDataType();
        int data = value.getData();
        return this.decodeValue(dataType, data);
    }

    @Nullable
    public String decodeValue(int dataType, int data) {
        switch (dataType) {
            case 0: {
                return null;
            }
            case 3: {
                return this.strings[data];
            }
            case 16: {
                return Integer.toString(data);
            }
            case 17: {
                return "0x" + Integer.toHexString(data);
            }
            case 18: {
                return data == 0 ? "false" : "true";
            }
            case 4: {
                return XmlGenUtils.floatToString(Float.intBitsToFloat(data));
            }
            case 28: {
                return String.format("#%08x", data);
            }
            case 29: {
                return String.format("#%06x", data & 0xFFFFFF);
            }
            case 30: {
                return String.format("#%04x", data & 0xFFFF);
            }
            case 31: {
                return String.format("#%03x", data & 0xFFF);
            }
            case 1: 
            case 7: {
                String ri = this.resMap.get(data);
                if (ri == null) {
                    String androidRi = androidResMap.get(data);
                    if (androidRi != null) {
                        return "@android:" + androidRi;
                    }
                    if (data == 0) {
                        return "0";
                    }
                    return "?unknown_ref: " + Integer.toHexString(data);
                }
                return '@' + ri;
            }
            case 2: {
                String ri = this.resMap.get(data);
                if (ri == null) {
                    String androidRi = androidResMap.get(data);
                    if (androidRi != null) {
                        return "?android:" + androidRi;
                    }
                    return "?unknown_attr_ref: " + Integer.toHexString(data);
                }
                return '?' + ri;
            }
            case 5: {
                return XmlGenUtils.decodeComplex(data, false);
            }
            case 6: {
                return XmlGenUtils.decodeComplex(data, true);
            }
            case 8: {
                LOG.warn("Data type TYPE_DYNAMIC_ATTRIBUTE not yet supported: {}", (Object)data);
                return "  TYPE_DYNAMIC_ATTRIBUTE: " + data;
            }
        }
        LOG.warn("Unknown data type: 0x{} {}", (Object)Integer.toHexString(dataType), (Object)data);
        return "  ?0x" + Integer.toHexString(dataType) + ' ' + data;
    }

    public String decodeNameRef(int nameRef) {
        int ref = nameRef;
        if (ValuesParser.isResInternalId(nameRef) && (ref = nameRef & 0xFFFF) == 0) {
            return null;
        }
        String ri = this.resMap.get(ref);
        if (ri != null) {
            return ri.replace('/', '.');
        }
        String androidRi = androidResMap.get(ref);
        if (androidRi != null) {
            return "android:" + androidRi.replace('/', '.');
        }
        return "?0x" + Integer.toHexString(nameRef);
    }
}

