/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jadx.api.CommentsLevel;
import jadx.api.DecompilationMode;
import jadx.api.JadxArgs;
import jadx.api.args.DeobfuscationMapFileMode;
import jadx.api.args.ResourceNameSource;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.api.plugins.options.OptionDescription;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorTheme;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.LafManager;
import jadx.gui.utils.LangLocale;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.codecache.CodeCacheMode;
import jadx.gui.utils.ui.DocumentUpdateListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import say.swing.JFontChooser;

public class JadxSettingsWindow
extends JDialog {
    private static final long serialVersionUID = -1804570470377354148L;
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettingsWindow.class);
    private final transient MainWindow mainWindow;
    private final transient JadxSettings settings;
    private final transient String startSettings;
    private final transient LangLocale prevLang;
    private transient boolean needReload = false;

    public JadxSettingsWindow(MainWindow mainWindow, JadxSettings settings) {
        this.mainWindow = mainWindow;
        this.settings = settings;
        this.startSettings = JadxSettingsAdapter.makeString(settings);
        this.prevLang = settings.getLangLocale();
        this.initUI();
        this.setTitle(NLS.str("preferences.title"));
        this.setSize(400, 550);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        UiUtils.setWindowIcons(this);
        this.setLocationRelativeTo(null);
    }

    private void initUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        rightPanel.setLayout(new BoxLayout(rightPanel, 3));
        panel.add(leftPanel);
        panel.add(rightPanel);
        leftPanel.add(this.makeDeobfuscationGroup());
        leftPanel.add(this.makeRenameGroup());
        leftPanel.add(this.makeProjectGroup());
        leftPanel.add(this.makeAppearanceGroup());
        leftPanel.add(this.makeOtherGroup());
        leftPanel.add(this.makeSearchResGroup());
        leftPanel.add(Box.createVerticalGlue());
        rightPanel.add(this.makeDecompilationGroup());
        rightPanel.add(this.makePluginOptionsGroup());
        rightPanel.add(Box.createVerticalGlue());
        JButton saveBtn = new JButton(NLS.str("preferences.save"));
        saveBtn.addActionListener(event -> {
            this.settings.sync();
            JadxSettingsWindow.enableComponents(this, false);
            SwingUtilities.invokeLater(() -> {
                if (this.needReload) {
                    this.mainWindow.reopen();
                }
                if (!this.settings.getLangLocale().equals(this.prevLang)) {
                    JOptionPane.showMessageDialog(this, NLS.str("msg.language_changed", this.settings.getLangLocale()), NLS.str("msg.language_changed_title", this.settings.getLangLocale()), 1);
                }
                this.dispose();
            });
        });
        JButton cancelButton = new JButton(NLS.str("preferences.cancel"));
        cancelButton.addActionListener(event -> this.cancel());
        JButton resetBtn = new JButton(NLS.str("preferences.reset"));
        resetBtn.addActionListener(event -> {
            int res = JOptionPane.showConfirmDialog(this, NLS.str("preferences.reset_message"), NLS.str("preferences.reset_title"), 0);
            if (res == 0) {
                String defaults = JadxSettingsAdapter.makeString(JadxSettings.makeDefault());
                JadxSettingsAdapter.fill(this.settings, defaults);
                this.mainWindow.loadSettings();
                this.needReload();
                this.getContentPane().removeAll();
                this.initUI();
                this.pack();
                this.repaint();
            }
        });
        JButton copyBtn = new JButton(NLS.str("preferences.copy"));
        copyBtn.addActionListener(event -> {
            JsonObject settingsJson = JadxSettingsAdapter.makeJsonObject(this.settings);
            settingsJson.remove("windowPos");
            settingsJson.remove("mainWindowExtendedState");
            settingsJson.remove("lastSaveProjectPath");
            settingsJson.remove("lastOpenFilePath");
            settingsJson.remove("lastSaveFilePath");
            settingsJson.remove("recentProjects");
            String settingsText = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)settingsJson);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection selection = new StringSelection(settingsText);
            clipboard.setContents(selection, selection);
            JOptionPane.showMessageDialog(this, NLS.str("preferences.copy_message"));
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPane.add(resetBtn);
        buttonPane.add(copyBtn);
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(saveBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.setHorizontalScrollBarPolicy(30);
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.getRootPane().setDefaultButton(saveBtn);
        KeyStroke strokeEsc = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(strokeEsc, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JadxSettingsWindow.this.cancel();
            }
        });
    }

    private void cancel() {
        JadxSettingsAdapter.fill(this.settings, this.startSettings);
        this.mainWindow.loadSettings();
        this.dispose();
    }

    private static void enableComponents(Container container, boolean enable) {
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                JadxSettingsWindow.enableComponents((Container)component, enable);
            }
            component.setEnabled(enable);
        }
    }

    private SettingsGroup makeDeobfuscationGroup() {
        JCheckBox deobfOn = new JCheckBox();
        deobfOn.setSelected(this.settings.isDeobfuscationOn());
        deobfOn.addItemListener(e -> {
            this.settings.setDeobfuscationOn(e.getStateChange() == 1);
            this.needReload();
        });
        SpinnerNumberModel minLenModel = new SpinnerNumberModel(this.settings.getDeobfuscationMinLength(), 0, Integer.MAX_VALUE, 1);
        JSpinner minLenSpinner = new JSpinner(minLenModel);
        minLenSpinner.addChangeListener(e -> {
            this.settings.setDeobfuscationMinLength((Integer)minLenSpinner.getValue());
            this.needReload();
        });
        SpinnerNumberModel maxLenModel = new SpinnerNumberModel(this.settings.getDeobfuscationMaxLength(), 0, Integer.MAX_VALUE, 1);
        JSpinner maxLenSpinner = new JSpinner(maxLenModel);
        maxLenSpinner.addChangeListener(e -> {
            this.settings.setDeobfuscationMaxLength((Integer)maxLenSpinner.getValue());
            this.needReload();
        });
        JCheckBox deobfSourceAlias = new JCheckBox();
        deobfSourceAlias.setSelected(this.settings.isDeobfuscationUseSourceNameAsAlias());
        deobfSourceAlias.addItemListener(e -> {
            this.settings.setDeobfuscationUseSourceNameAsAlias(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox deobfKotlinMetadata = new JCheckBox();
        deobfKotlinMetadata.setSelected(this.settings.isDeobfuscationParseKotlinMetadata());
        deobfKotlinMetadata.addItemListener(e -> {
            this.settings.setDeobfuscationParseKotlinMetadata(e.getStateChange() == 1);
            this.needReload();
        });
        JComboBox<ResourceNameSource> resNamesSource = new JComboBox<ResourceNameSource>(ResourceNameSource.values());
        resNamesSource.setSelectedItem(this.settings.getResourceNameSource());
        resNamesSource.addActionListener(e -> {
            this.settings.setResourceNameSource((ResourceNameSource)resNamesSource.getSelectedItem());
            this.needReload();
        });
        JComboBox<DeobfuscationMapFileMode> deobfMapFileModeCB = new JComboBox<DeobfuscationMapFileMode>(DeobfuscationMapFileMode.values());
        deobfMapFileModeCB.setSelectedItem(this.settings.getDeobfuscationMapFileMode());
        deobfMapFileModeCB.addActionListener(e -> {
            DeobfuscationMapFileMode newValue = (DeobfuscationMapFileMode)deobfMapFileModeCB.getSelectedItem();
            if (newValue != this.settings.getDeobfuscationMapFileMode()) {
                this.settings.setDeobfuscationMapFileMode(newValue);
                this.needReload();
            }
        });
        SettingsGroup deobfGroup = new SettingsGroup(NLS.str("preferences.deobfuscation"));
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_on"), deobfOn);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_min_len"), minLenSpinner);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_max_len"), maxLenSpinner);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_source_alias"), deobfSourceAlias);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_kotlin_metadata"), deobfKotlinMetadata);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_res_name_source"), resNamesSource);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_map_file_mode"), deobfMapFileModeCB);
        deobfGroup.end();
        List<JComponent> connectedComponents = Arrays.asList(minLenSpinner, maxLenSpinner, deobfSourceAlias, deobfKotlinMetadata);
        deobfOn.addItemListener(e -> this.enableComponentList(connectedComponents, e.getStateChange() == 1));
        this.enableComponentList(connectedComponents, this.settings.isDeobfuscationOn());
        return deobfGroup;
    }

    private SettingsGroup makeRenameGroup() {
        JCheckBox renameCaseSensitive = new JCheckBox();
        renameCaseSensitive.setSelected(this.settings.isRenameCaseSensitive());
        renameCaseSensitive.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.CASE, e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox renameValid = new JCheckBox();
        renameValid.setSelected(this.settings.isRenameValid());
        renameValid.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.VALID, e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox renamePrintable = new JCheckBox();
        renamePrintable.setSelected(this.settings.isRenamePrintable());
        renamePrintable.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.PRINTABLE, e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.rename"));
        group.addRow(NLS.str("preferences.rename_case"), renameCaseSensitive);
        group.addRow(NLS.str("preferences.rename_valid"), renameValid);
        group.addRow(NLS.str("preferences.rename_printable"), renamePrintable);
        return group;
    }

    private void enableComponentList(Collection<JComponent> connectedComponents, boolean enabled) {
        connectedComponents.forEach(comp -> comp.setEnabled(enabled));
    }

    private SettingsGroup makeProjectGroup() {
        JCheckBox autoSave = new JCheckBox();
        autoSave.setSelected(this.settings.isAutoSaveProject());
        autoSave.addItemListener(e -> this.settings.setAutoSaveProject(e.getStateChange() == 1));
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.project"));
        group.addRow(NLS.str("preferences.autoSave"), autoSave);
        return group;
    }

    private SettingsGroup makeAppearanceGroup() {
        JButton fontBtn = new JButton(NLS.str("preferences.select_font"));
        JButton smaliFontBtn = new JButton(NLS.str("preferences.select_smali_font"));
        EditorTheme[] editorThemes = EditorTheme.getAllThemes();
        JComboBox<EditorTheme> themesCbx = new JComboBox<EditorTheme>(editorThemes);
        for (EditorTheme theme : editorThemes) {
            if (!theme.getPath().equals(this.settings.getEditorThemePath())) continue;
            themesCbx.setSelectedItem(theme);
            break;
        }
        themesCbx.addActionListener(e -> {
            int i = themesCbx.getSelectedIndex();
            EditorTheme editorTheme = editorThemes[i];
            this.settings.setEditorThemePath(editorTheme.getPath());
            this.mainWindow.loadSettings();
        });
        JComboBox<String> lafCbx = new JComboBox<String>(LafManager.getThemes());
        lafCbx.setSelectedItem(this.settings.getLafTheme());
        lafCbx.addActionListener(e -> {
            this.settings.setLafTheme((String)lafCbx.getSelectedItem());
            this.mainWindow.loadSettings();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.appearance"));
        group.addRow(NLS.str("preferences.laf_theme"), lafCbx);
        group.addRow(NLS.str("preferences.theme"), themesCbx);
        final JLabel fontLabel = group.addRow(this.getFontLabelStr(), fontBtn);
        final JLabel smaliFontLabel = group.addRow(this.getSmaliFontLabelStr(), smaliFontBtn);
        fontBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JFontChooser fontChooser = new JFontChooser();
                fontChooser.setSelectedFont(JadxSettingsWindow.this.settings.getFont());
                int result = fontChooser.showDialog(JadxSettingsWindow.this);
                if (result == 0) {
                    Font font = fontChooser.getSelectedFont();
                    LOG.debug("Selected Font: {}", (Object)font);
                    JadxSettingsWindow.this.settings.setFont(font);
                    JadxSettingsWindow.this.mainWindow.loadSettings();
                    fontLabel.setText(JadxSettingsWindow.this.getFontLabelStr());
                }
            }
        });
        smaliFontBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JPreferredFontChooser fontChooser = new JPreferredFontChooser();
                fontChooser.setSelectedFont(JadxSettingsWindow.this.settings.getSmaliFont());
                int result = fontChooser.showDialog(JadxSettingsWindow.this);
                if (result == 0) {
                    Font font = fontChooser.getSelectedFont();
                    LOG.debug("Selected Font: {} for smali", (Object)font);
                    JadxSettingsWindow.this.settings.setSmaliFont(font);
                    JadxSettingsWindow.this.mainWindow.loadSettings();
                    smaliFontLabel.setText(JadxSettingsWindow.this.getSmaliFontLabelStr());
                }
            }
        });
        return group;
    }

    private String getFontLabelStr() {
        Font font = this.settings.getFont();
        String fontStyleName = FontUtils.convertFontStyleToString(font.getStyle());
        return NLS.str("preferences.font") + ": " + font.getFontName() + ' ' + fontStyleName + ' ' + font.getSize();
    }

    private String getSmaliFontLabelStr() {
        Font font = this.settings.getSmaliFont();
        String fontStyleName = FontUtils.convertFontStyleToString(font.getStyle());
        return NLS.str("preferences.smali_font") + ": " + font.getFontName() + ' ' + fontStyleName + ' ' + font.getSize();
    }

    private SettingsGroup makeDecompilationGroup() {
        JCheckBox useDx = new JCheckBox();
        useDx.setSelected(this.settings.isUseDx());
        useDx.addItemListener(e -> {
            this.settings.setUseDx(e.getStateChange() == 1);
            this.needReload();
        });
        JComboBox<DecompilationMode> decompilationModeComboBox = new JComboBox<DecompilationMode>(DecompilationMode.values());
        decompilationModeComboBox.setSelectedItem(this.settings.getDecompilationMode());
        decompilationModeComboBox.addActionListener(e -> {
            this.settings.setDecompilationMode((DecompilationMode)decompilationModeComboBox.getSelectedItem());
            this.needReload();
        });
        JComboBox<CodeCacheMode> codeCacheModeComboBox = new JComboBox<CodeCacheMode>(CodeCacheMode.values());
        codeCacheModeComboBox.setSelectedItem((Object)this.settings.getCodeCacheMode());
        codeCacheModeComboBox.addActionListener(e -> {
            this.settings.setCodeCacheMode((CodeCacheMode)((Object)((Object)codeCacheModeComboBox.getSelectedItem())));
            this.needReload();
        });
        String codeCacheModeToolTip = CodeCacheMode.buildToolTip();
        JCheckBox showInconsistentCode = new JCheckBox();
        showInconsistentCode.setSelected(this.settings.isShowInconsistentCode());
        showInconsistentCode.addItemListener(e -> {
            this.settings.setShowInconsistentCode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox resourceDecode = new JCheckBox();
        resourceDecode.setSelected(this.settings.isSkipResources());
        resourceDecode.addItemListener(e -> {
            this.settings.setSkipResources(e.getStateChange() == 1);
            this.needReload();
        });
        int threadsCountValue = this.settings.getThreadsCount();
        int threadsCountMax = Math.max(2, Math.max(threadsCountValue, Runtime.getRuntime().availableProcessors() * 2));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(threadsCountValue, 1, threadsCountMax, 1);
        JSpinner threadsCount = new JSpinner(spinnerModel);
        threadsCount.addChangeListener(e -> {
            this.settings.setThreadsCount((Integer)threadsCount.getValue());
            this.needReload();
        });
        JButton editExcludedPackages = new JButton(NLS.str("preferences.excludedPackages.button"));
        editExcludedPackages.addActionListener(event -> {
            String oldExcludedPackages = this.settings.getExcludedPackages();
            String result = JOptionPane.showInputDialog(this, NLS.str("preferences.excludedPackages.editDialog"), this.settings.getExcludedPackages());
            if (result != null) {
                this.settings.setExcludedPackages(result);
                if (!oldExcludedPackages.equals(result)) {
                    this.needReload();
                }
            }
        });
        JCheckBox autoStartJobs = new JCheckBox();
        autoStartJobs.setSelected(this.settings.isAutoStartJobs());
        autoStartJobs.addItemListener(e -> this.settings.setAutoStartJobs(e.getStateChange() == 1));
        JCheckBox escapeUnicode = new JCheckBox();
        escapeUnicode.setSelected(this.settings.isEscapeUnicode());
        escapeUnicode.addItemListener(e -> {
            this.settings.setEscapeUnicode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox replaceConsts = new JCheckBox();
        replaceConsts.setSelected(this.settings.isReplaceConsts());
        replaceConsts.addItemListener(e -> {
            this.settings.setReplaceConsts(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox respectBytecodeAccessModifiers = new JCheckBox();
        respectBytecodeAccessModifiers.setSelected(this.settings.isRespectBytecodeAccessModifiers());
        respectBytecodeAccessModifiers.addItemListener(e -> {
            this.settings.setRespectBytecodeAccessModifiers(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox useImports = new JCheckBox();
        useImports.setSelected(this.settings.isUseImports());
        useImports.addItemListener(e -> {
            this.settings.setUseImports(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox useDebugInfo = new JCheckBox();
        useDebugInfo.setSelected(this.settings.isDebugInfo());
        useDebugInfo.addItemListener(e -> {
            this.settings.setDebugInfo(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox inlineAnonymous = new JCheckBox();
        inlineAnonymous.setSelected(this.settings.isInlineAnonymousClasses());
        inlineAnonymous.addItemListener(e -> {
            this.settings.setInlineAnonymousClasses(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox inlineMethods = new JCheckBox();
        inlineMethods.setSelected(this.settings.isInlineMethods());
        inlineMethods.addItemListener(e -> {
            this.settings.setInlineMethods(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox extractFinally = new JCheckBox();
        extractFinally.setSelected(this.settings.isExtractFinally());
        extractFinally.addItemListener(e -> {
            this.settings.setExtractFinally(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox fsCaseSensitive = new JCheckBox();
        fsCaseSensitive.setSelected(this.settings.isFsCaseSensitive());
        fsCaseSensitive.addItemListener(e -> {
            this.settings.setFsCaseSensitive(e.getStateChange() == 1);
            this.needReload();
        });
        JComboBox<JadxArgs.UseKotlinMethodsForVarNames> kotlinRenameVars = new JComboBox<JadxArgs.UseKotlinMethodsForVarNames>(JadxArgs.UseKotlinMethodsForVarNames.values());
        kotlinRenameVars.setSelectedItem(this.settings.getUseKotlinMethodsForVarNames());
        kotlinRenameVars.addActionListener(e -> {
            this.settings.setUseKotlinMethodsForVarNames((JadxArgs.UseKotlinMethodsForVarNames)kotlinRenameVars.getSelectedItem());
            this.needReload();
        });
        JComboBox<CommentsLevel> commentsLevel = new JComboBox<CommentsLevel>(CommentsLevel.values());
        commentsLevel.setSelectedItem(this.settings.getCommentsLevel());
        commentsLevel.addActionListener(e -> {
            this.settings.setCommentsLevel((CommentsLevel)commentsLevel.getSelectedItem());
            this.needReload();
        });
        SettingsGroup other = new SettingsGroup(NLS.str("preferences.decompile"));
        other.addRow(NLS.str("preferences.threads"), threadsCount);
        other.addRow(NLS.str("preferences.excludedPackages"), NLS.str("preferences.excludedPackages.tooltip"), editExcludedPackages);
        other.addRow(NLS.str("preferences.start_jobs"), autoStartJobs);
        other.addRow(NLS.str("preferences.decompilationMode"), decompilationModeComboBox);
        other.addRow(NLS.str("preferences.codeCacheMode"), codeCacheModeToolTip, codeCacheModeComboBox);
        other.addRow(NLS.str("preferences.showInconsistentCode"), showInconsistentCode);
        other.addRow(NLS.str("preferences.escapeUnicode"), escapeUnicode);
        other.addRow(NLS.str("preferences.replaceConsts"), replaceConsts);
        other.addRow(NLS.str("preferences.respectBytecodeAccessModifiers"), respectBytecodeAccessModifiers);
        other.addRow(NLS.str("preferences.useImports"), useImports);
        other.addRow(NLS.str("preferences.useDebugInfo"), useDebugInfo);
        other.addRow(NLS.str("preferences.inlineAnonymous"), inlineAnonymous);
        other.addRow(NLS.str("preferences.inlineMethods"), inlineMethods);
        other.addRow(NLS.str("preferences.extractFinally"), extractFinally);
        other.addRow(NLS.str("preferences.fsCaseSensitive"), fsCaseSensitive);
        other.addRow(NLS.str("preferences.useDx"), useDx);
        other.addRow(NLS.str("preferences.skipResourcesDecode"), resourceDecode);
        other.addRow(NLS.str("preferences.useKotlinMethodsForVarNames"), kotlinRenameVars);
        other.addRow(NLS.str("preferences.commentsLevel"), commentsLevel);
        return other;
    }

    private SettingsGroup makePluginOptionsGroup() {
        SettingsGroup pluginsGroup = new SettingsGroup(NLS.str("preferences.plugins"));
        for (JadxPlugin plugin : this.mainWindow.getWrapper().getAllPlugins()) {
            if (!(plugin instanceof JadxPluginOptions)) continue;
            JadxPluginInfo pluginInfo = plugin.getPluginInfo();
            JadxPluginOptions optPlugin = (JadxPluginOptions)plugin;
            for (OptionDescription opt : optPlugin.getOptionsDescriptions()) {
                String title = "[" + pluginInfo.getPluginId() + "]  " + opt.description();
                if (opt.values().isEmpty()) {
                    JTextField textField = new JTextField();
                    textField.getDocument().addDocumentListener(new DocumentUpdateListener(event -> {
                        this.settings.getPluginOptions().put(opt.name(), textField.getText());
                        this.needReload();
                    }));
                    pluginsGroup.addRow(title, textField);
                    continue;
                }
                String curValue = (String)this.settings.getPluginOptions().get(opt.name());
                JComboBox<String> combo = new JComboBox<String>(opt.values().toArray(new String[0]));
                combo.setSelectedItem(curValue != null ? curValue : opt.defaultValue());
                combo.addActionListener(e -> {
                    this.settings.getPluginOptions().put(opt.name(), (String)combo.getSelectedItem());
                    this.needReload();
                });
                pluginsGroup.addRow(title, combo);
            }
        }
        return pluginsGroup;
    }

    private SettingsGroup makeOtherGroup() {
        JComboBox<LangLocale> languageCbx = new JComboBox<LangLocale>(NLS.getLangLocales());
        for (LangLocale locale : NLS.getLangLocales()) {
            if (!locale.equals(this.settings.getLangLocale())) continue;
            languageCbx.setSelectedItem(locale);
            break;
        }
        languageCbx.addActionListener(e -> this.settings.setLangLocale((LangLocale)languageCbx.getSelectedItem()));
        JComboBox<LineNumbersMode> lineNumbersMode = new JComboBox<LineNumbersMode>(LineNumbersMode.values());
        lineNumbersMode.setSelectedItem((Object)this.settings.getLineNumbersMode());
        lineNumbersMode.addActionListener(e -> {
            this.settings.setLineNumbersMode((LineNumbersMode)((Object)((Object)lineNumbersMode.getSelectedItem())));
            this.mainWindow.loadSettings();
        });
        JCheckBox jumpOnDoubleClick = new JCheckBox();
        jumpOnDoubleClick.setSelected(this.settings.isJumpOnDoubleClick());
        jumpOnDoubleClick.addItemListener(e -> this.settings.setJumpOnDoubleClick(e.getStateChange() == 1));
        JCheckBox update = new JCheckBox();
        update.setSelected(this.settings.isCheckForUpdates());
        update.addItemListener(e -> this.settings.setCheckForUpdates(e.getStateChange() == 1));
        JCheckBox cfg = new JCheckBox();
        cfg.setSelected(this.settings.isCfgOutput());
        cfg.addItemListener(e -> {
            this.settings.setCfgOutput(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox rawCfg = new JCheckBox();
        rawCfg.setSelected(this.settings.isRawCfgOutput());
        rawCfg.addItemListener(e -> {
            this.settings.setRawCfgOutput(e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.other"));
        group.addRow(NLS.str("preferences.language"), languageCbx);
        group.addRow(NLS.str("preferences.lineNumbersMode"), lineNumbersMode);
        group.addRow(NLS.str("preferences.jumpOnDoubleClick"), jumpOnDoubleClick);
        group.addRow(NLS.str("preferences.check_for_updates"), update);
        group.addRow(NLS.str("preferences.cfg"), cfg);
        group.addRow(NLS.str("preferences.raw_cfg"), rawCfg);
        return group;
    }

    private SettingsGroup makeSearchResGroup() {
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.search_res_title"));
        int prevSize = this.settings.getSrhResourceSkipSize();
        String prevExts = this.settings.getSrhResourceFileExt();
        SpinnerNumberModel sizeLimitModel = new SpinnerNumberModel(prevSize, 0, Integer.MAX_VALUE, 1);
        final JSpinner spinner = new JSpinner(sizeLimitModel);
        final JTextField fileExtField = new JTextField();
        group.addRow(NLS.str("preferences.res_skip_file"), spinner);
        group.addRow(NLS.str("preferences.res_file_ext"), fileExtField);
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int size = (Integer)spinner.getValue();
                JadxSettingsWindow.this.settings.setSrhResourceSkipSize(size);
            }
        });
        fileExtField.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                String ext = fileExtField.getText();
                JadxSettingsWindow.this.settings.setSrhResourceFileExt(ext);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        fileExtField.setText(prevExts);
        return group;
    }

    private void needReload() {
        this.needReload = true;
    }

    private static class SettingsGroup
    extends JPanel {
        private static final long serialVersionUID = -6487309975896192544L;
        private final GridBagConstraints c;
        private int row;

        public SettingsGroup(String title) {
            this.setBorder(BorderFactory.createTitledBorder(title));
            this.setLayout(new GridBagLayout());
            this.c = new GridBagConstraints();
            this.c.insets = new Insets(5, 5, 5, 5);
            this.c.weighty = 1.0;
        }

        public JLabel addRow(String label, JComponent comp) {
            return this.addRow(label, null, comp);
        }

        public JLabel addRow(String label, String tooltip, JComponent comp) {
            this.c.gridy = this.row++;
            JLabel jLabel = new JLabel(label);
            jLabel.setLabelFor(comp);
            jLabel.setHorizontalAlignment(2);
            this.c.gridx = 0;
            this.c.gridwidth = 1;
            this.c.anchor = 21;
            this.c.weightx = 0.8;
            this.c.fill = 0;
            this.add((Component)jLabel, this.c);
            this.c.gridx = 1;
            this.c.gridwidth = 0;
            this.c.anchor = 10;
            this.c.weightx = 0.2;
            this.c.fill = 2;
            if (tooltip != null) {
                jLabel.setToolTipText(tooltip);
                comp.setToolTipText(tooltip);
            }
            this.add((Component)comp, this.c);
            comp.addPropertyChangeListener("enabled", evt -> jLabel.setEnabled((Boolean)evt.getNewValue()));
            return jLabel;
        }

        public void end() {
            this.add(Box.createVerticalGlue());
        }
    }

    private static class JPreferredFontChooser
    extends JFontChooser {
        private static final String[] PREFERRED_FONTS = new String[]{"Monospaced", "Consolas", "Courier", "Courier New", "Lucida Sans Typewriter", "Lucida Console", "SimSun", "SimHei"};
        private String[] filteredFonts;

        private JPreferredFontChooser() {
        }

        @Override
        protected String[] getFontFamilies() {
            if (this.filteredFonts == null) {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                HashSet fontSet = new HashSet();
                Collections.addAll(fontSet, env.getAvailableFontFamilyNames());
                ArrayList<String> found = new ArrayList<String>(PREFERRED_FONTS.length);
                for (String font : PREFERRED_FONTS) {
                    if (!fontSet.contains(font)) continue;
                    found.add(font);
                }
                if (found.size() == PREFERRED_FONTS.length) {
                    this.filteredFonts = PREFERRED_FONTS;
                } else if (found.size() > 0) {
                    this.filteredFonts = new String[found.size()];
                    for (int i = 0; i < found.size(); ++i) {
                        this.filteredFonts[i] = (String)found.get(i);
                    }
                } else {
                    LOG.warn("Can't found any preferred fonts for smali, use all available.");
                    this.filteredFonts = env.getAvailableFontFamilyNames();
                }
            }
            return this.filteredFonts;
        }
    }
}

