### Copyright  (C) 2019 Intel Corporation. All rights reserved.
###
### The information and source code contained herein is the exclusive
### property of Intel Corporation and may not be disclosed, examined
### or reproduced in whole or in part without explicit written authorization
### from the company.
###
###  3/2019  Update Fortran-specific files

# Definition file for
#   host:    linux
#   target:  linux

include(def_util)
def_init_install_subsets()

if( NOT DEFINED TARGET_EFI2_X32)
  set( TARGET_EFI2_X32 FALSE )
endif()

#compiler header files common for 64/32 bit targets
if (DO_COPY_EFI2_TARGET_FILES OR DO_COPY_IA32_TARGET_FILES)
  set( compiler_header_files
        bfp754_conf.h
        bfp754_functionnames.h
        bfp754.h
        bfp754_macros.h
        bfp754_types.h
        complex
        complex.h
        dvec.h
        fenv.h
        float.h
        fvec.h
        hvec.h
        istrconv.h
        ivec.h
        limits.h
        math_common_define.h
        math_common_undefine.h
        math.h
        mathimf.h
        omp.h
        omp_lib.h
        sse2mmx.h
        tbk_traceback.h
        vec_complex.h
        xmm_func.h
        xmm_utils.h )

  if(BUILD_FORT)
    list(APPEND compiler_header_files
        ISO_Fortran_binding.h
        foriosdef.f90
        for_iosdef.for
        for_iosdef.h
        fordef.for
        fordef.h
        for_fpclass.for
        for_fpclass.h
        for_fpeflags.for
        for_fpeflags.h
        forreent.for
        forreent.h
        ieee_arithmetic.f90
        ieee_exceptions.f90
        ieee_features.f90
        ifcommonalloc.f90
        ifcore.f90
        ifestablish.f90
        iflport.f90
        iflposix.f90
        ifport.f90
        ifposix.f90
        iso_c_binding.f90
        iso_fortran_env.f90
        omp_lib.f90 )
  endif ()

  def_add_install_subset( cmplr_headers INC
        SRCDIR "efi2/linux_test/include"
        INSTDIR "compiler/include"
        ${compiler_header_files} )

  if (BUILD_FORT)
      set( fortran_mod_files
        foriosdef.mod
        ieee_arithmetic.modintr
        ieee_exceptions.modintr
        ieee_features.modintr
        ifcommonalloc.mod
        ifcore.mod
        ifestablish.mod
        iflport.mod
        iflposix.mod
        ifport.mod
        ifport_types.mod
        ifposix.mod
        iso_c_binding.modintr
        iso_fortran_env.modintr
        omp_lib_kinds.mod
        omp_lib.mod )

      def_add_install_subset( cmplr_mod64 INC
            SRCDIR "efi2/linux_test/include"
            INSTDIR "compiler/include/intel64"
            ${fortran_mod_files} )

   endif ()  # Fortran mod files

  set( perf_headers_files
        ippvalarray
        valarray )

  def_add_install_subset( perf_headers INC
        SRCDIR "efi2/linux_test/include/perf_headers/c++"
        INSTDIR "compiler/perf_headers/c++"
        ${perf_headers_files} )

endif() # (DO_COPY_EFI2_TARGET_FILES OR DO_COPY_IA32_TARGET_FILES)

if (DO_COPY_EFI2_TARGET_FILES)

  set( lib64_files
        init.o
        libbfp754.a
        libdecimal.a
        libimf.a
        libimf.so
        libintlc.so
        libintlc.so.5
        libiomp5.a
        libiomp5.dbg
        libiomp5.so
        libiompstubs5.a
        libiompstubs5.so
        libipgo.a
        libirc.a
        libirc_s.a
        libirc.so
        libirng.a
        libirng.so
        libistrconv.a
        libistrconv.so
        libmatmul.a
        libmpx.so
        libpdbx.a
        libpdbxinst.a
        libpdbx.so
        libpdbx.so.5
        libqkmalloc.so
        libsvml.a
        libsvml.so )

  if(BUILD_FORT)
    list(APPEND lib64_files
      for_main.o
      libicaf.so
      libifcore.a
      libifcore.so
      libifcore.so.5
      libifcore_pic.a
      libifcoremt.a
      libifcoremt.so
      libifcoremt.so.5
      libifcoremt_pic.a
      libifport.a
      libifport.so
      libifport.so.5
      )
  endif()

  def_add_install_subset( lib_intel64 LIB
        SRCDIR "efi2/linux_test/lib_lin"
        INSTDIR "compiler/lib/intel64_lin"
        ${lib64_files} )

  if( TARGET_EFI2_X32)
    set( lib64x32_files
        datainit-dynrunb.o
        datainit-dynrunb-pie.o
        datainit-dynrunbS.o
        datainit-dynrune.o
        libbeaddrinfo.a
        libbeaddrinfo_pic.a
        libbedatainit.a
        libbedatainit.so
        libbedatainit.so.5
        libbfp754.a
        libdecimal.a
        libimf.a
        libimf.so
        libintlc.so
        libintlc.so.5
        libipgo.a
        libirc.a
        libirc_s.a
        libirc.so
        libirng.a
        libirng.so
        libm.cat
        libpdbx.a
        libpdbxinst.a
        libpdbx.so
        libpdbx.so.5
        libsvml.a
        libsvml.so )

    def_add_install_subset( lib_x32 LIB
        SRCDIR "efi2/linux_test/lib_lin_x32"
        INSTDIR "compiler/lib/intel64_x32_lin"
        ${lib64x32_files} )

 endif(TARGET_EFI2_X32)

endif (DO_COPY_EFI2_TARGET_FILES)

if (DO_COPY_IA32_TARGET_FILES)

  set( lib32_files
        libbfp754.a
        libdecimal.a
        libimf.a
        libimf_pic.a
        libimf.so
        libintlc.so
        libintlc.so.5
        libiomp5.a
        libiomp5.dbg
        libiomp5.so
        libiompstubs5.a
        libiompstubs5.so
        libipgo.a
        libipgo_pic.a
        libirc.a
        libirc_pic.a
        libirc_s.a
        libirc.so
        libirc_s_pic.a
        libirng.a
        libirng.so
        libistrconv.a
        libistrconv.so
        libmatmul.a
        libpdbx.a
        libpdbxinst.a
        libpdbx.so
        libpdbx.so.5
        libsvml.a
        libsvml.so )

  if(BUILD_FORT)
    list(APPEND lib32_files
      for_main.o
      libicaf.so
      libifcore.a
      libifcore.so
      libifcore.so.5
      libifcore_pic.a
      libifcoremt.a
      libifcoremt.so
      libifcoremt.so.5
      libifcoremt_pic.a
      libifport.a
      libifport.so
      libifport.so.5 )
  endif()

  def_add_install_subset( lib_ia32 LIB
        SRCDIR "ia32/linux_RH7.1_test/lib_lin"
        INSTDIR "compiler/lib/ia32_lin"
        ${lib32_files} )

   if (BUILD_FORT)
      def_add_install_subset( cmplr_mod32 INC
            SRCDIR "ia32/linux_RH7.1_test/include"
            INSTDIR "compiler/include/ia32"
            ${fortran_mod_files} )
   endif ()  # Fortran mod files


endif(DO_COPY_IA32_TARGET_FILES)

def_add_install_targets()

