#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wide-word
version:              0.1.1.2
visibility:           public
id:                   wide-word-0.1.1.2-G8Xoq1PUr9v6oePafHwInI
key:                  wide-word-0.1.1.2-G8Xoq1PUr9v6oePafHwInI
license:              BSD-2-Clause
copyright:
    Copyright (c) 2017 Erik de Castro Lopo <erikd@mega-nerd.com>

maintainer:           erikd@mega-nerd.com
author:               Erik de Castro Lopo
stability:            provisional
homepage:             https://github.com/erikd/wide-word
synopsis:
    Data types for large but fixed width signed and unsigned integers

description:
    A library to provide data types for large (ie > 64 bits) but fixed width signed
    and unsigned integers with the usual typeclass instances to allow them to be used
    interchangeably with `Word64`.

    The types and operations are coded to be as fast as possible using strictness
    annotations, `INLINEABLE` pragmas and unboxed values and operations where
    appropriate.

category:             Data
abi:                  b2a9480cf73be0c5e40c723daf1f63fe
exposed:              True
exposed-modules:
    Data.WideWord Data.WideWord.Int128 Data.WideWord.Word128
    Data.WideWord.Word256

import-dirs:          /usr/lib/ghc-9.0.2/site-local/wide-word-0.1.1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/wide-word-0.1.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wide-word
hs-libraries:         HSwide-word-0.1.1.2-G8Xoq1PUr9v6oePafHwInI
depends:
    base-4.15.1.0 deepseq-1.4.5.0
    primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW

haddock-interfaces:   /usr/share/doc/haskell-wide-word/html/wide-word.haddock
haddock-html:         /usr/share/doc/haskell-wide-word/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

