#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wai-extra
version:              3.1.12.1
visibility:           public
id:                   wai-extra-3.1.12.1-9ZhhaouWVJ9KdcrPtBJdXj
key:                  wai-extra-3.1.12.1-9ZhhaouWVJ9KdcrPtBJdXj
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * Health check endpoint

    Add an empty health check endpoint.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Select

    Dynamically choose between Middlewares.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  e496c126d8decf045d87def643fff85c
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip
    Network.Wai.Middleware.HealthCheckEndpoint
    Network.Wai.Middleware.HttpAuth Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.Local Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.Select Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.Vhost Network.Wai.Parse Network.Wai.Request
    Network.Wai.Test Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:       Network.Wai.Middleware.RequestLogger.Internal
import-dirs:          /usr/lib/ghc-9.0.2/site-local/wai-extra-3.1.12.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/wai-extra-3.1.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wai-extra
hs-libraries:         HSwai-extra-3.1.12.1-9ZhhaouWVJ9KdcrPtBJdXj
depends:
    HUnit-1.6.2.0-2gufKd42xUzCpoVbpNtVHq
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL base-4.15.1.0
    base64-bytestring-1.2.1.0-iG6YBGhLkRJagBsFqRAI2
    bytestring-0.10.12.1 call-stack-0.4.0-GzzQb9Lrk0g4HpVkjTQ3aR
    case-insensitive-1.2.1.0-9P0gl8mW2it6Cg0EClpHns containers-0.6.4.1
    cookie-0.4.5-B1GcTZOCb6yBzxFcoqFiFA
    data-default-class-0.1.2.0-IxhEAzgy8931aXcEiJcyZO directory-1.3.6.2
    fast-logger-3.1.1-CYdwPQIA01ZLKxwb9xRHHH
    http-types-0.12.3-L4VBkj9wBbpJhmiMCXrA05
    http2-3.0.3-69WwrfvgcTHWlSbVEmcFt
    iproute-1.7.12-8kXD0W7cPNk40vduXhDMGB
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    resourcet-1.2.6-3amKdWDZReE3TYUO4zdEYT
    streaming-commons-0.2.2.5-E1SSGxuO5i7DyTGQczFgFd text-1.2.5.0
    time-1.9.3 transformers-0.5.6.2 unix-2.7.2.2
    vault-0.3.1.5-1kdlyNQeV32LWrYpRe1Io8
    wai-3.2.3-4BBvzsOByYiKnH9wzG1k6K
    wai-logger-2.4.0-D0lovsK5AjG9QhHoHMMSeA
    word8-0.1.3-AazxEC5xyKiELvx3OUlEW

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

