#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vector-algorithms
version:              0.9.0.1
visibility:           public
id:                   vector-algorithms-0.9.0.1-9xTmSJPLRpg8wi1rI1i3UR
key:                  vector-algorithms-0.9.0.1-9xTmSJPLRpg8wi1rI1i3UR
license:              BSD-3-Clause
copyright:
    (c) 2008,2009,2010,2011,2012,2013,2014,2015 Dan Doel
    (c) 2015 Tim Baumann

maintainer:
    Dan Doel <dan.doel@gmail.com>
    Erik de Castro Lopo <erikd@mega-nerd.com>

author:               Dan Doel
homepage:             https://github.com/erikd/vector-algorithms/
synopsis:             Efficient algorithms for vector arrays
description:
    Efficient algorithms for sorting vector arrays. At some stage
    other vector algorithms may be added.

category:             Data
abi:                  49e939e2e39bc173aff0053675076915
exposed:              True
exposed-modules:
    Data.Vector.Algorithms Data.Vector.Algorithms.AmericanFlag
    Data.Vector.Algorithms.Heap Data.Vector.Algorithms.Insertion
    Data.Vector.Algorithms.Intro Data.Vector.Algorithms.Merge
    Data.Vector.Algorithms.Optimal Data.Vector.Algorithms.Radix
    Data.Vector.Algorithms.Search Data.Vector.Algorithms.Tim

hidden-modules:       Data.Vector.Algorithms.Common
import-dirs:          /usr/lib/ghc-9.0.2/site-local/vector-algorithms-0.9.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/vector-algorithms-0.9.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector-algorithms
hs-libraries:         HSvector-algorithms-0.9.0.1-9xTmSJPLRpg8wi1rI1i3UR
include-dirs:
    /usr/lib/ghc-9.0.2/site-local/vector-algorithms-0.9.0.1/include

depends:
    base-4.15.1.0 bitvec-1.1.3.0-HgW47Zi9ZSvL0LtZNp8wiP
    bytestring-0.10.12.1 primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:
    /usr/share/doc/haskell-vector-algorithms/html/vector-algorithms.haddock

haddock-html:         /usr/share/doc/haskell-vector-algorithms/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

