#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 uuid
version:              1.3.15
visibility:           public
id:                   uuid-1.3.15-COTLJewp0LkDpLqVZeAi7X
key:                  uuid-1.3.15-COTLJewp0LkDpLqVZeAi7X
license:              BSD-3-Clause
copyright:            (c) 2008-2014 Antoine Latter
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:
    For creating, comparing, parsing and printing Universally Unique Identifiers

description:
    This library is useful for creating, comparing, parsing and
    printing Universally Unique Identifiers.

    See <http://en.wikipedia.org/wiki/UUID> for the general idea.

category:             Data
abi:                  9e0347247c2b8c432d47b8e2600c2763
exposed:              True
exposed-modules:
    Data.UUID Data.UUID.Util Data.UUID.V1 Data.UUID.V3 Data.UUID.V4
    Data.UUID.V5

hidden-modules:       Data.UUID.Named Data.Word.Util
import-dirs:          /usr/lib/ghc-9.0.2/site-local/uuid-1.3.15
library-dirs:         /usr/lib/ghc-9.0.2/site-local/uuid-1.3.15
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uuid
hs-libraries:         HSuuid-1.3.15-COTLJewp0LkDpLqVZeAi7X
depends:
    base-4.15.1.0 binary-0.8.8.0 bytestring-0.10.12.1
    cryptohash-md5-0.11.101.0-J8eSEiis8kU7P8wEkXcNec
    cryptohash-sha1-0.11.101.0-JEtkXlImqJm2HHCf1KVLi1
    entropy-0.4.1.10-CwQzC5Ky39pHQuKDZJMypk
    network-info-0.2.1-9GScy3IMZku1XH8B3cDTYU
    random-1.2.1.1-LHneN0qmdBg2HhYYKMDrs5 text-1.2.5.0 time-1.9.3
    uuid-types-1.0.5-Icgszg4dLRWTkInDrIcfE

haddock-interfaces:   /usr/share/doc/haskell-uuid/html/uuid.haddock
haddock-html:         /usr/share/doc/haskell-uuid/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

