#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tzdata
version:              0.2.20221028.0
visibility:           public
id:                   tzdata-0.2.20221028.0-9zDO9ch0tQ98AwgnqG7gOB
key:                  tzdata-0.2.20221028.0-9zDO9ch0tQ98AwgnqG7gOB
license:              Apache-2.0
maintainer:           Janus Troelsen <ysangkok@gmail.com>
author:               Mihaly Barasz, Gergely Risko
stability:            experimental
homepage:             https://github.com/ysangkok/haskell-tzdata
synopsis:             Time zone database (as files and as a module)
description:
    The goal of this package is to distribute the standard Time Zone
    Database in a cabal package, so that it can be used in Haskell
    programs uniformly on all platforms.

    This package currently ships the @2022f@ version of the time zone
    database.  The version of the time zone database shipped is always
    reflected in the version of this package: @x.y.YYYYMMDD.z@, then
    @YYYYMMDD@ is the official release date of time zone database.

    This version contains the "fat" variant of the time zone files (which is not
    the default for the upstream since @2020b@) to facilitate the transition. The
    next major version (@0.3@) will ship the "slim" variant.

    See: <http://www.iana.org/time-zones> for more info about the time
    zone database.

    See also the @tz@ package <http://hackage.haskell.org/package/tz> or
    the @timezone-olson@ and @timezone-series@ packages that provide
    facilities to /use/ the data shipped here. (The @tz@ package
    automatically installs this package.)

category:             Data
abi:                  bbcd4cad779c39e15f50a6559554c2aa
exposed:              True
exposed-modules:      Data.Time.Zones.DB Data.Time.Zones.Files
hidden-modules:       Paths_tzdata
import-dirs:          /usr/lib/ghc-9.0.2/site-local/tzdata-0.2.20221028.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tzdata-0.2.20221028.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tzdata
hs-libraries:         HStzdata-0.2.20221028.0-9zDO9ch0tQ98AwgnqG7gOB
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-tzdata/html/tzdata.haddock
haddock-html:         /usr/share/doc/haskell-tzdata/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

