#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 turtle
version:              1.6.1
visibility:           public
id:                   turtle-1.6.1-Beyvft2jlIC1aaUwuLoswq
key:                  turtle-1.6.1-Beyvft2jlIC1aaUwuLoswq
license:              BSD-3-Clause
copyright:            2015 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.

    Features include:

    * Batteries included: Command an extended suite of predefined utilities

    * Interoperability: You can still run external shell commands

    * Portability: Works on Windows, OS X, and Linux

    * Exception safety: Safely acquire and release resources

    * Streaming: Transform or fold command output in constant space

    * Patterns: Use typed regular expressions that can parse structured values

    * Formatting: Type-safe @printf@-style text formatting

    * Modern: Supports @text@

    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide

    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.

category:             System
abi:                  05be886f85410e2d35ccd83808be1ca3
exposed:              True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial

hidden-modules:       Turtle.Internal
import-dirs:          /usr/lib/ghc-9.0.2/site-local/turtle-1.6.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/turtle-1.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-turtle
hs-libraries:         HSturtle-1.6.1-Beyvft2jlIC1aaUwuLoswq
depends:
    ansi-wl-pprint-0.6.9-J38Hi5Z6ALfKDwm9oxcbks
    async-2.2.4-9EoKZTgytm43s60GeTAIZR base-4.15.1.0
    bytestring-0.10.12.1 clock-0.8.3-6odPqrwh5n8Jat4lpxq8Cr
    containers-0.6.4.1 directory-1.3.6.2 exceptions-0.10.4
    filepath-1.4.2.1 foldl-1.4.12-3CCgO75sGh4GI4BiONan6b
    hostname-1.0-4HkhnKdpx7vFbnzzYgAxYQ
    managed-1.0.9-D57Q6tda4Oi5Cz7tXkGkaQ
    optional-args-1.0.2-BWFqbdCL20SBMSniG5XGdE
    optparse-applicative-0.17.0.0-5RAB8jXJau3LDHQVpRHOkD
    process-1.6.13.2 stm-2.5.0.0
    streaming-commons-0.2.2.5-E1SSGxuO5i7DyTGQczFgFd
    temporary-1.3-HXIdO020OG29nAlGx7vsUT text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.6-ItrkFOIKc9mI0qPePSsUjW

haddock-interfaces:   /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html:         /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

