#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 th-lift-instances
version:              0.1.20
visibility:           public
id:                   th-lift-instances-0.1.20-5NHl0zPpjKhEmiENmzVd0c
key:                  th-lift-instances-0.1.20-5NHl0zPpjKhEmiENmzVd0c
license:              BSD-3-Clause
copyright:            Copyright (C) 2013-2020 Benno Fünfstück
maintainer:           Benno Fünfstück <benno.fuenfstueck@gmail.com>
author:               Benno Fünfstück
stability:            experimental
homepage:             http://github.com/bennofs/th-lift-instances/
synopsis:             Lift instances for template-haskell for common data types.
description:
    Most data types in the haskell platform do not have Lift instances.
    This package provides orphan instances for containers, text, bytestring and vector.
    It also provides compat instances for older versions of @template-haskell@

    Note that <https://hackage.haskell.org/package/th-lift th-lift> package provides
    Template Haskell based derivation of @Lift@ instances (when you cannot use @DeriveLift@ extension),
    and <https://hackage.haskell.org/package/th-orphans th-orphans> package provides instances for TH datatypes.

category:             Template Haskell
abi:                  4e5dbc454c93141fc0aa1cabd364a0bf
exposed:              True
exposed-modules:      Instances.TH.Lift
import-dirs:          /usr/lib/ghc-9.0.2/site-local/th-lift-instances-0.1.20
library-dirs:         /usr/lib/ghc-9.0.2/site-local/th-lift-instances-0.1.20
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-th-lift-instances
hs-libraries:         HSth-lift-instances-0.1.20-5NHl0zPpjKhEmiENmzVd0c
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    template-haskell-2.17.0.0 text-1.2.5.0
    th-lift-0.8.2-47INKJD6iIF1IlUc8HcOrC transformers-0.5.6.2
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:
    /usr/share/doc/haskell-th-lift-instances/html/th-lift-instances.haddock

haddock-html:         /usr/share/doc/haskell-th-lift-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

