#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 stm-containers
version:              1.2
visibility:           public
id:                   stm-containers-1.2-4lfbC67z3eIEm9HTi1WuKs
key:                  stm-containers-1.2-4lfbC67z3eIEm9HTi1WuKs
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/stm-containers
synopsis:             Containers for STM
description:
    This library is based on an STM-specialized implementation of
    Hash Array Mapped Trie.
    It provides efficient implementations of @Map@, @Set@
    and other data structures,
    which starting from version @1@ perform even better than their counterparts from \"unordered-containers\",
    but also scale well on concurrent access patterns.

    For details on performance of the library, which are a bit outdated, see
    <http://nikita-volkov.github.io/stm-containers/ this blog post>.

category:             Data Structures, STM, Concurrency
abi:                  eafd4a6b0647f508874cc07012015ef0
exposed:              True
exposed-modules:
    StmContainers.Bimap StmContainers.Map StmContainers.Multimap
    StmContainers.Set

hidden-modules:       StmContainers.Prelude
import-dirs:          /usr/lib/ghc-9.0.2/site-local/stm-containers-1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/stm-containers-1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-stm-containers
hs-libraries:         HSstm-containers-1.2-4lfbC67z3eIEm9HTi1WuKs
depends:
    base-4.15.1.0 deferred-folds-0.9.18.2-qYxd64sckF4qZdWLKou0X
    focus-1.0.3-Dz934cAjgo1ByYhPJgMGeI
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    list-t-1.0.5.3-tK2QUi49dHIaKNlfHjzoW
    stm-hamt-1.2.0.8-BcPy05dtwDn8ksmdB2lW5a transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-stm-containers/html/stm-containers.haddock

haddock-html:         /usr/share/doc/haskell-stm-containers/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

