#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 some
version:              1.0.4.1
visibility:           public
id:                   some-1.0.4.1-3oTC5bddeLcpEd54xiVBi
key:                  some-1.0.4.1-3oTC5bddeLcpEd54xiVBi
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    James Cook <mokus@deepbondi.net>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/some
synopsis:             Existential type: Some
description:
    This library defines an existential type '\''Some'\''.

    @
    data Some f where
    \    Some :: f a -> Some f
    @

    in few variants, and utilities to work with it.

    If you are unsure which variant to use, use the one in "Data.Some" module.

category:             Data, Dependent Types
abi:                  91e0cb2a204c3d8a39862e5fce11f720
exposed:              True
exposed-modules:
    Data.GADT.Compare Data.GADT.DeepSeq Data.GADT.Show Data.Some
    Data.Some.Church Data.Some.GADT Data.Some.Newtype

hidden-modules:       Data.GADT.Internal
import-dirs:          /usr/lib/ghc-9.0.2/site-local/some-1.0.4.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/some-1.0.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-some
hs-libraries:         HSsome-1.0.4.1-3oTC5bddeLcpEd54xiVBi
depends:              base-4.15.1.0 deepseq-1.4.5.0
haddock-interfaces:   /usr/share/doc/haskell-some/html/some.haddock
haddock-html:         /usr/share/doc/haskell-some/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

