#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semialign
version:              1.2.0.1
visibility:           public
id:                   semialign-1.2.0.1-BNKrR9Ml2CXKwv64Fd8kGF
key:                  semialign-1.2.0.1-BNKrR9Ml2CXKwv64Fd8kGF
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  7b8737f15cc3c0231e20ce26f2bd2344
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.0.2/site-local/semialign-1.2.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/semialign-1.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.2.0.1-BNKrR9Ml2CXKwv64Fd8kGF
depends:
    base-4.15.1.0 containers-0.6.4.1
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    indexed-traversable-0.1.2-55rCITp0bj2K4TSTU28RrG
    indexed-traversable-instances-0.1.1.1-FBkYLpT4LalDTz44MwmQjh
    semigroupoids-5.3.7-HwCM6hSIfxCIEi8aYGOr6m
    tagged-0.8.6.1-79gYUUazit6EfoPS33FHdR
    these-1.1.1.1-Gw2H7nY5XI7gYndk3FRxI transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

