#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 resolv
version:              0.1.2.0
visibility:           public
id:                   resolv-0.1.2.0-3tHv348yQ3HIC4BwxE4QAq
key:                  resolv-0.1.2.0-3tHv348yQ3HIC4BwxE4QAq
license:              GPL-2.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel
synopsis:
    Domain Name Service (DNS) lookup via the libresolv standard library routines

description:
    This package implements an API for accessing
    the [Domain Name Service (DNS)](https://tools.ietf.org/html/rfc1035)
    resolver service via the standard @libresolv@ system library (whose
    API is often available directly via the standard @libc@ C library) on
    Unix systems.

    This package also includes support for decoding message record types
    as defined in the following RFCs:

    - [RFC 1035](https://tools.ietf.org/html/rfc1035): Domain Names - Implementation And Specification
    - [RFC 1183](https://tools.ietf.org/html/rfc1183): New DNS RR Definitions
    - [RFC 2782](https://tools.ietf.org/html/rfc2782): A DNS RR for specifying the location of services (DNS SRV)
    - [RFC 2915](https://tools.ietf.org/html/rfc2915): The Naming Authority Pointer (NAPTR) DNS Resource Record
    - [RFC 3596](https://tools.ietf.org/html/rfc3596): DNS Extensions to Support IP Version 6
    - [RFC 4034](https://tools.ietf.org/html/rfc4034): Resource Records for the DNS Security Extensions
    - [RFC 4255](https://tools.ietf.org/html/rfc4255): Using DNS to Securely Publish Secure Shell (SSH) Key Fingerprints
    - [RFC 4408](https://tools.ietf.org/html/rfc4408): Sender Policy Framework (SPF) for Authorizing Use of Domains in E-Mail, Version 1
    - [RFC 5155](https://tools.ietf.org/html/rfc5155): DNS Security (DNSSEC) Hashed Authenticated Denial of Existence
    - [RFC 6844](https://tools.ietf.org/html/rfc6844): DNS Certification Authority Authorization (CAA) Resource Record
    - [RFC 6891](https://tools.ietf.org/html/rfc6891): Extension Mechanisms for DNS (EDNS(0))
    - [RFC 7553](https://tools.ietf.org/html/rfc7553): The Uniform Resource Identifier (URI) DNS Resource Record

    For Windows, the package [windns](https://hackage.haskell.org/package/windns)
    provides a compatible subset of this package'\''s API.

category:             Network
abi:                  299f0dd0d9d9bfdbfc1c9c1e5ac7e3fe
exposed:              True
exposed-modules:      Network.DNS
hidden-modules:       Network.DNS.Message Network.DNS.FFI Compat
import-dirs:          /usr/lib/ghc-9.0.2/site-local/resolv-0.1.2.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/resolv-0.1.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-resolv
hs-libraries:         HSresolv-0.1.2.0-3tHv348yQ3HIC4BwxE4QAq
depends:
    base-4.15.1.0 base16-bytestring-1.0.2.0-JAhsVwuAYUHf0LicTQmUd
    binary-0.8.8.0 bytestring-0.10.12.1 containers-0.6.4.1

haddock-interfaces:   /usr/share/doc/haskell-resolv/html/resolv.haddock
haddock-html:         /usr/share/doc/haskell-resolv/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

