#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 reflection
version:              2.1.6
visibility:           public
id:                   reflection-2.1.6-BJdzOLrQPM410aC3yfrNGl
key:                  reflection-2.1.6-BJdzOLrQPM410aC3yfrNGl
license:              BSD-3-Clause
copyright:
    2009-2013 Edward A. Kmett,
    2012 Elliott Hird,
    2004 Oleg Kiselyov and Chung-chieh Shan

maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:
    Edward A. Kmett, Elliott Hird, Oleg Kiselyov and Chung-chieh Shan

stability:            experimental
homepage:             http://github.com/ekmett/reflection
synopsis:
    Reifies arbitrary terms into types that can be reflected back into terms

description:
    This package addresses the /configuration problem/ which is
    propagating configurations that are available at run-time, allowing
    multiple configurations to coexist without resorting to mutable
    global variables or '\''System.IO.Unsafe.unsafePerformIO'\''.

    That package is an implementation of the ideas presented in the
    paper \"Functional Pearl: Implicit Configurations\" by Oleg Kiselyov
    and Chung-chieh Shan (<http://okmij.org/ftp/Haskell/tr-15-04.pdf original paper>).
    However, the API has been streamlined to improve performance.

    Austin Seipp'\''s tutorial <https://www.schoolofhaskell.com/user/thoughtpolice/using-reflection Reflecting values to types and back> provides a summary of the
    approach taken by this library, along with more motivating examples.

category:             Data, Reflection, Dependent Types
abi:                  7d244df96fc319ab02e96b1d6b8ef683
exposed:              True
exposed-modules:      Data.Reflection
import-dirs:          /usr/lib/ghc-9.0.2/site-local/reflection-2.1.6
library-dirs:         /usr/lib/ghc-9.0.2/site-local/reflection-2.1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-reflection
hs-libraries:         HSreflection-2.1.6-BJdzOLrQPM410aC3yfrNGl
depends:              base-4.15.1.0 template-haskell-2.17.0.0
haddock-interfaces:   /usr/share/doc/haskell-reflection/html/reflection.haddock
haddock-html:         /usr/share/doc/haskell-reflection/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

