#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgresql-binary
version:              0.12.5
visibility:           public
id:                   postgresql-binary-0.12.5-BjnwCSfqQLG9uVoBmLlkJ1
key:                  postgresql-binary-0.12.5-BjnwCSfqQLG9uVoBmLlkJ1
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql hasql>
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  a8900f6e2b6805d9225ee96ba5f26b64
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-9.0.2/site-local/postgresql-binary-0.12.5
library-dirs:         /usr/lib/ghc-9.0.2/site-local/postgresql-binary-0.12.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-postgresql-binary
hs-libraries:         HSpostgresql-binary-0.12.5-BjnwCSfqQLG9uVoBmLlkJ1
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT base-4.15.1.0
    binary-parser-0.5.7.2-7HNZzsg3bp7DsqHHmSUaKU bytestring-0.10.12.1
    bytestring-strict-builder-0.4.5.6-14KCOk3Zzo2FBldBfWH02P
    containers-0.6.4.1 network-ip-0.3.0.3-6i95wFG90kD1PcbMAupDyq
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7 text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    uuid-1.3.15-COTLJewp0LkDpLqVZeAi7X
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

