#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pango
version:              0.13.8.2
visibility:           public
id:                   pango-0.13.8.2-BLGTw6ZzT3c6YEfgDoSiU4
key:                  pango-0.13.8.2-BLGTw6ZzT3c6YEfgDoSiU4
license:              LGPL-2.1-only
copyright:            (c) 2001-2010 The Gtk2Hs Team
maintainer:           gtk2hs-users@lists.sourceforge.net
author:               Axel Simon, Duncan Coutts
stability:            stable
homepage:             http://projects.haskell.org/gtk2hs/
synopsis:             Binding to the Pango text rendering engine.
description:
    This package provides a wrapper around the Pango C library that
    allows high-quality rendering of Unicode text. It can be used
    either with Cairo to output text in PDF, PS or other
    documents or with Gtk+ to display text on-screen.

category:             Graphics
abi:                  ddb74aa40f12aa661fecfab6d80ab685
exposed:              True
exposed-modules:
    Graphics.Rendering.Pango Graphics.Rendering.Pango.Attributes
    Graphics.Rendering.Pango.BasicTypes Graphics.Rendering.Pango.Cairo
    Graphics.Rendering.Pango.Context Graphics.Rendering.Pango.Enums
    Graphics.Rendering.Pango.Font Graphics.Rendering.Pango.Layout
    Graphics.Rendering.Pango.Markup Graphics.Rendering.Pango.Rendering
    Graphics.Rendering.Pango.Structs Graphics.Rendering.Pango.Types

hidden-modules:
    Graphics.Rendering.Pango.GlyphStorage
    Graphics.Rendering.Pango.Description

import-dirs:          /usr/lib/ghc-9.0.2/site-local/pango-0.13.8.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/pango-0.13.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pango
hs-libraries:         HSpango-0.13.8.2-BLGTw6ZzT3c6YEfgDoSiU4
extra-libraries:
    pangocairo-1.0 cairo pango-1.0 gobject-2.0 glib-2.0 harfbuzz

include-dirs:
    /usr/include/cairo /usr/include/lzo /usr/include/libpng16
    /usr/include/freetype2 /usr/include/harfbuzz /usr/include/glib-2.0
    /usr/lib/glib-2.0/include /usr/include/sysprof-4
    /usr/include/pixman-1 /usr/include/pango-1.0 /usr/include/libmount
    /usr/include/blkid /usr/include/fribidi

includes:             hspango.h
depends:
    array-0.5.4.0 base-4.15.1.0 cairo-0.13.8.2-5ej5gttQEUYEzkJECOd4uO
    containers-0.6.4.1 directory-1.3.6.2
    glib-0.13.8.2-8GnoispwAgZJGuZrzN18wE mtl-2.2.2 pretty-1.1.3.6
    process-1.6.13.2 text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-pango/html/pango.haddock
haddock-html:         /usr/share/doc/haskell-pango/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

