#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pandoc-lua-marshal
version:              0.1.7
visibility:           public
id:                   pandoc-lua-marshal-0.1.7-BB8a9XvKqjjJhS66346itC
key:                  pandoc-lua-marshal-0.1.7-BB8a9XvKqjjJhS66346itC
license:              MIT
copyright:            © 2017-2022 Albert Krewinkel, John MacFarlane
maintainer:           Albert Krewinkel <albert@zeitkraut.de>
author:               Albert Krewinkel, John MacFarlane
homepage:             https://github.com/pandoc/pandoc-lua-marshal
synopsis:             Use pandoc types in Lua
description:
    This package provides functions to marshal and unmarshal
    pandoc document types to and from Lua.

    The values of most types are pushed to pandoc as "userdata"
    objects that wrap a stable pointer to the Haskell value;
    these objects come with methods to access and modify their
    properties.

    Sequences are pushed as normal Lua tables, but are
    augmented with convenience functions.

category:             Foreign
abi:                  8b7347938b06db172668bc32feb1b107
exposed:              True
exposed-modules:
    Text.Pandoc.Lua.Marshal.AST Text.Pandoc.Lua.Marshal.Alignment
    Text.Pandoc.Lua.Marshal.Attr Text.Pandoc.Lua.Marshal.Block
    Text.Pandoc.Lua.Marshal.Cell Text.Pandoc.Lua.Marshal.Citation
    Text.Pandoc.Lua.Marshal.CitationMode
    Text.Pandoc.Lua.Marshal.Content Text.Pandoc.Lua.Marshal.Filter
    Text.Pandoc.Lua.Marshal.Format Text.Pandoc.Lua.Marshal.Inline
    Text.Pandoc.Lua.Marshal.List Text.Pandoc.Lua.Marshal.ListAttributes
    Text.Pandoc.Lua.Marshal.MathType Text.Pandoc.Lua.Marshal.MetaValue
    Text.Pandoc.Lua.Marshal.Pandoc Text.Pandoc.Lua.Marshal.QuoteType
    Text.Pandoc.Lua.Marshal.Row Text.Pandoc.Lua.Marshal.SimpleTable
    Text.Pandoc.Lua.Marshal.TableFoot Text.Pandoc.Lua.Marshal.TableHead
    Text.Pandoc.Lua.Marshal.TableParts

hidden-modules:
    Text.Pandoc.Lua.Marshal.Shared Text.Pandoc.Lua.Topdown
    Text.Pandoc.Lua.SpliceList Text.Pandoc.Lua.Walk

import-dirs:          /usr/lib/ghc-9.0.2/site-local/pandoc-lua-marshal-0.1.7
library-dirs:         /usr/lib/ghc-9.0.2/site-local/pandoc-lua-marshal-0.1.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc-lua-marshal
hs-libraries:         HSpandoc-lua-marshal-0.1.7-BB8a9XvKqjjJhS66346itC
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    exceptions-0.10.4 hslua-2.2.1-44kucnvr9vu7w7UJh4vcRs
    hslua-marshalling-2.2.1-EeEmfmTmrwkJWLfmnZtave
    lua-2.2.1-676haWSef0b1nirtoVSkjm
    pandoc-types-1.22.2.1-1T6Kd9AZiZ6EUNN63A2kLH
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q text-1.2.5.0

haddock-interfaces:
    /usr/share/doc/haskell-pandoc-lua-marshal/html/pandoc-lua-marshal.haddock

haddock-html:         /usr/share/doc/haskell-pandoc-lua-marshal/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

