#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lua
version:              2.2.1
visibility:           public
id:                   lua-2.2.1-676haWSef0b1nirtoVSkjm
key:                  lua-2.2.1-676haWSef0b1nirtoVSkjm
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2022 Albert Krewinkel

maintainer:           Albert Krewinkel <albert+hslua@zeitkraut.de>
author:               Albert Krewinkel
homepage:             https://hslua.org/
synopsis:             Lua, an embeddable scripting language
description:
    This package provides bindings and types to bridge
    Haskell and <https://www.lua.org/ Lua>.

    The full Lua interpreter version 5.4.4 is included.
    Alternatively, a system-wide Lua installation can be
    linked instead.

category:             Foreign
abi:                  7f08b36020b02d4c2d6339f4987f1105
exposed:              True
exposed-modules:
    Lua Lua.Auxiliary Lua.Call Lua.Constants Lua.Ersatz
    Lua.Ersatz.Auxiliary Lua.Ersatz.Functions Lua.Lib Lua.Primary
    Lua.Types Lua.Userdata

import-dirs:          /usr/lib/ghc-9.0.2/site-local/lua-2.2.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/lua-2.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lua
hs-libraries:         HSlua-2.2.1-676haWSef0b1nirtoVSkjm
extra-libraries:      lua m
includes:             lua.h luaconf.h lauxlib.h lualib.h
depends:              base-4.15.1.0
ld-options:           "-Wl,-E"
haddock-interfaces:   /usr/share/doc/haskell-lua/html/lua.haddock
haddock-html:         /usr/share/doc/haskell-lua/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

