#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp
version:              1.2.0.1
visibility:           public
id:                   lsp-1.2.0.1-BIbkux9XRcr8eYHTTrWW6o
key:                  lsp-1.2.0.1-BIbkux9XRcr8eYHTTrWW6o
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  a44080e3499597c8b41cafb4c6afd0a8
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.0.2/site-local/lsp-1.2.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/lsp-1.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-1.2.0.1-BIbkux9XRcr8eYHTTrWW6o
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    async-2.2.4-9EoKZTgytm43s60GeTAIZR
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    bytestring-0.10.12.1 containers-0.6.4.1
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW
    dependent-map-0.4.0.0-CtWKqh3WdYc1AtPMs9Qp2i exceptions-0.10.4
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    hslogger-1.3.1.0-KzlhBMOSSdaFDR3rkwktqA
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM
    lsp-types-1.3.0.1-A9OBFtru06V7IJgWtqPrq4 mtl-2.2.2
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    random-1.2.1.1-LHneN0qmdBg2HhYYKMDrs5
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7
    sorted-list-0.2.1.0-6jcghXYTAOG6xcHgKgM12R stm-2.5.0.0 text-1.2.5.0
    time-1.9.3 transformers-0.5.6.2
    unliftio-core-0.2.0.1-HjGpVpPktr5Bc3kYrL6LtS
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    uuid-1.3.15-COTLJewp0LkDpLqVZeAi7X

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

