#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lattices
version:              2.0.3
visibility:           public
id:                   lattices-2.0.3-v5U1h2GQe2G7JTFTrFSDy
key:                  lattices-2.0.3-v5U1h2GQe2G7JTFTrFSDy
license:              BSD-3-Clause
copyright:
    (C) 2010-2015 Maximilian Bolingbroke, 2016-2019 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Maximilian Bolingbroke <batterseapower@hotmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             http://github.com/phadej/lattices/
synopsis:
    Fine-grained library for constructing and manipulating lattices

description:
    In mathematics, a lattice is a partially ordered set in which every two
    elements @x@ and @y@ have a unique supremum (also called a least upper bound, join, or @x /\\ y@)
    and a unique infimum (also called a greatest lower bound, meet, or @x \\/ y@).

    This package provide type-classes for different lattice types, as well
    as a class for the partial order.

category:             Math
abi:                  580ba113fec1464011034c4ca26183b5
exposed:              True
exposed-modules:
    Algebra.Heyting Algebra.Heyting.Free Algebra.Heyting.Free.Expr
    Algebra.Lattice Algebra.Lattice.Divisibility
    Algebra.Lattice.Dropped Algebra.Lattice.Free
    Algebra.Lattice.Free.Final Algebra.Lattice.Levitated
    Algebra.Lattice.Lexicographic Algebra.Lattice.Lifted
    Algebra.Lattice.M2 Algebra.Lattice.M3 Algebra.Lattice.N5
    Algebra.Lattice.Op Algebra.Lattice.Ordered Algebra.Lattice.Stacked
    Algebra.Lattice.Unicode Algebra.Lattice.Wide
    Algebra.Lattice.ZeroHalfOne Algebra.PartialOrd
    Algebra.PartialOrd.Instances

import-dirs:          /usr/lib/ghc-9.0.2/site-local/lattices-2.0.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/lattices-2.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lattices
hs-libraries:         HSlattices-2.0.3-v5U1h2GQe2G7JTFTrFSDy
depends:
    QuickCheck-2.14.2-JoFwhdHSVnjCwZaPGQEEzD base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu containers-0.6.4.1
    deepseq-1.4.5.0 ghc-prim-0.7.0
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    integer-logarithms-1.0.3.1-5kS6jNbEsIJGKjr4VAkZqE
    semigroupoids-5.3.7-HwCM6hSIfxCIEi8aYGOr6m
    tagged-0.8.6.1-79gYUUazit6EfoPS33FHdR transformers-0.5.6.2
    universe-base-1.1.3-9L2jHTazOaVBrJVpaBD7dP
    universe-reverse-instances-1.1.1-FM5SrhfTnlr2k7ZWwys8p8
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r

haddock-interfaces:   /usr/share/doc/haskell-lattices/html/lattices.haddock
haddock-html:         /usr/share/doc/haskell-lattices/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

