#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 language-haskell-extract
version:              0.2.4
visibility:           public
id:                   language-haskell-extract-0.2.4-3cIcmNToA72BofA3eQaKFk
key:                  language-haskell-extract-0.2.4-3cIcmNToA72BofA3eQaKFk
license:              BSD-3-Clause
maintainer:           Oscar Finnsson
author:               Oscar Finnsson & Emil Nordling
stability:            stable
homepage:             http://github.com/finnsson/template-helper
synopsis:
    Module to automatically extract functions from the local code.

description:
    @language-haskell-extract@ contains some useful helper functions on top of Template Haskell.

    @functionExtractor@ extracts all functions after a regexp-pattern.

    > foo = "test"
    > boo = "testing"
    > bar = $(functionExtractor "oo$")

    will automagically extract the functions ending with @oo@ such as

    > bar = [("foo",foo), ("boo",boo)]

    This can be useful if you wish to extract all functions beginning with test (for a test-framework)
    or all functions beginning with wc (for a web service).

    @functionExtractorMap@ works like @functionsExtractor@ but applies a function over all function-pairs.

    This functions is useful if the common return type of the functions is a type class.

    Example:

    > secondTypeclassTest =
    >   do let expected = ["45", "88.8", "\"hej\""]
    >          actual = $(functionExtractorMap "^tc" [|\n f -> show f|] )
    >      expected @=? actual
    >
    > tcInt :: Integer
    > tcInt = 45
    >
    > tcDouble :: Double
    > tcDouble = 88.8
    >
    > tcString :: String
    > tcString = "hej"

category:             Template Haskell
abi:                  151289d644275e4c5c66526b080c2111
exposed:              True
exposed-modules:      Language.Haskell.Extract
import-dirs:
    /usr/lib/ghc-9.0.2/site-local/language-haskell-extract-0.2.4

library-dirs:
    /usr/lib/ghc-9.0.2/site-local/language-haskell-extract-0.2.4

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.2/language-haskell-extract-0.2.4

hs-libraries:         HSlanguage-haskell-extract-0.2.4-3cIcmNToA72BofA3eQaKFk
depends:
    base-4.15.1.0 regex-posix-0.96.0.1-3tnfXrSqQrb7MJMFtuTwG8
    template-haskell-2.17.0.0

haddock-interfaces:
    /usr/share/doc/haskell-language-haskell-extract/html/language-haskell-extract.haddock

haddock-html:         /usr/share/doc/haskell-language-haskell-extract/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

