#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hOpenPGP
version:              2.9.8
visibility:           public
id:                   hOpenPGP-2.9.8-J6eXTyeJXKVANGuUe5m9BU
key:                  hOpenPGP-2.9.8-J6eXTyeJXKVANGuUe5m9BU
license:              MIT
copyright:            2012-2022  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  3185e9645108022fb98897254f4e2db9
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hOpenPGP-2.9.8
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hOpenPGP-2.9.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.9.8-J6eXTyeJXKVANGuUe5m9BU
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    asn1-encoding-0.9.6-61DqZt9ATxr5H1gQwYWfOX
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    base16-bytestring-1.0.2.0-JAhsVwuAYUHf0LicTQmUd
    bifunctors-5.5.13-JsL8XwnIyaF7mMrittTFB9 binary-0.8.8.0
    binary-conduit-1.3.1-GkW9Ee3nqv1ETl2LEFYHyH bytestring-0.10.12.1
    bz2-1.0.1.0-HcsxGEitCQdFt9fUxJ8QNU
    conduit-1.3.4.3-8itn5Qj41ZSLgRSjBhzqyF
    conduit-extra-1.3.6-LDUhnbBFGIILMmOycgbU6i containers-0.6.4.1
    crypto-cipher-types-0.0.9-8dNq76lIVvq61pUzJfYm3b
    cryptonite-0.30-1Rfjg2UxJ0tAQrwWuK0NlN
    errors-2.3.0-F4rUJSCR8jkHhnELGOml9T
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    incremental-parser-0.5.0.4-7fGafYg9kur62TqaVxqAEq
    ixset-typed-0.5.1.0-CqcscuFLRkcLVY5L1kB3Me
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM
    memory-0.17.0-3DbDQrj54CLAPAnWUJBJ4b
    monad-loops-0.4.3-C4VZ1LczQKA9hVl8DS9fX
    nettle-0.3.0-8qVdvaF51A3AJM581PImaL
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    openpgp-asciiarmor-0.1.2-FSZuha9f1Tc2yw1aQqu0JY
    prettyprinter-1.7.1-Kh082I8LQyjLFudtJnG2xP
    resourcet-1.2.6-3amKdWDZReE3TYUO4zdEYT
    split-0.2.3.5-1ZFbiAR4sQhKaqqBevLjN8 text-1.2.5.0 time-1.9.3
    time-locale-compat-0.1.1.5-1snbmhWP0619voIlJd9qOd
    transformers-0.5.6.2 unliftio-core-0.2.0.1-HjGpVpPktr5Bc3kYrL6LtS
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    zlib-0.6.3.0-vb12epxNFtI6q1EYqoP1g

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

