#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 happstack-server
version:              7.8.0.1
visibility:           public
id:                   happstack-server-7.8.0.1-IRRObdKuHjLAz96BLQwqnW
key:                  happstack-server-7.8.0.1-IRRObdKuHjLAz96BLQwqnW
license:              BSD-3-Clause
maintainer:           Happstack team <happs@googlegroups.com>
author:               Happstack team, HAppS LLC
homepage:             http://happstack.com
synopsis:             Web related tools and services.
description:
    Happstack Server provides an HTTP server and a rich set of functions for routing requests, handling query parameters, generating responses, working with cookies, serving files, and more. For in-depth documentation see the Happstack Crash Course <http://happstack.com/docs/crashcourse/index.html>

category:             Web, Happstack
abi:                  fa3e98893c94f34aea741403750d1e59
exposed:              True
exposed-modules:
    Happstack.Server Happstack.Server.Auth Happstack.Server.Compression
    Happstack.Server.Cookie Happstack.Server.Error
    Happstack.Server.FileServe
    Happstack.Server.FileServe.BuildingBlocks Happstack.Server.I18N
    Happstack.Server.Internal.Compression
    Happstack.Server.Internal.Cookie Happstack.Server.Internal.Handler
    Happstack.Server.Internal.Listen
    Happstack.Server.Internal.LogFormat
    Happstack.Server.Internal.LowLevel
    Happstack.Server.Internal.MessageWrap
    Happstack.Server.Internal.Monads
    Happstack.Server.Internal.Multipart
    Happstack.Server.Internal.RFC822Headers
    Happstack.Server.Internal.Socket
    Happstack.Server.Internal.TimeoutIO
    Happstack.Server.Internal.TimeoutManager
    Happstack.Server.Internal.TimeoutSocket
    Happstack.Server.Internal.Types Happstack.Server.Monads
    Happstack.Server.Response Happstack.Server.Routing
    Happstack.Server.RqData Happstack.Server.SURI
    Happstack.Server.SimpleHTTP Happstack.Server.Types
    Happstack.Server.Validation

hidden-modules:
    Happstack.Server.Internal.Clock Happstack.Server.Internal.LazyLiner
    Happstack.Server.SURI.ParseURI Paths_happstack_server

import-dirs:          /usr/lib/ghc-9.0.2/site-local/happstack-server-7.8.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/happstack-server-7.8.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-happstack-server
hs-libraries:         HShappstack-server-7.8.0.1-IRRObdKuHjLAz96BLQwqnW
depends:
    base-4.15.1.0 base64-bytestring-1.2.1.0-iG6YBGhLkRJagBsFqRAI2
    blaze-html-0.9.1.2-AIRGwJuJakcDOfrsYtfKDl bytestring-0.10.12.1
    containers-0.6.4.1 directory-1.3.6.2 exceptions-0.10.4
    extensible-exceptions-0.1.1.4-FO4Sw13oBkvBW8j4vnJTpA
    filepath-1.4.2.1 hslogger-1.3.1.0-KzlhBMOSSdaFDR3rkwktqA
    html-1.0.1.2-BYpT6zvcyak8RR9ba7PA72
    monad-control-1.0.3.1-21gUZpZbgH5KO3QvMCPaGC mtl-2.2.2
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    old-locale-1.0.0.7-B94o3sNLYrV8oE3WO2rqHh parsec-3.1.14.0
    process-1.6.13.2 sendfile-0.7.11.4-BG9FWKdHjypBCvo0S4Z1zV
    syb-0.7.2.2-JvKYfJw95RM7Y4GXhTvfdV
    system-filepath-0.4.14-GK5ruxmjn0w7DfEOVa7EyC text-1.2.5.0
    threads-0.5.1.7-7P00BrB2rWo3JqSswIerec time-1.9.3
    transformers-0.5.6.2 transformers-base-0.4.6-2M49J28Ed0L2XQvH4AySxP
    transformers-compat-0.7.2-ZzSHjvD4flB2ChCq5TVbH unix-2.7.2.2
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj xhtml-3000.2.2.1
    zlib-0.6.3.0-vb12epxNFtI6q1EYqoP1g

haddock-interfaces:
    /usr/share/doc/haskell-happstack-server/html/happstack-server.haddock

haddock-html:         /usr/share/doc/haskell-happstack-server/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

