#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 gauge
version:              0.2.5
visibility:           public
id:                   gauge-0.2.5-7iNfJZka6apEB1NJ8fJOM4
key:                  gauge-0.2.5-7iNfJZka6apEB1NJ8fJOM4
license:              BSD-3-Clause
copyright:            2009-2016 Bryan O'\''Sullivan and others
maintainer:           Vincent Hanquez <vincent@snarc.org>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             https://github.com/vincenthz/hs-gauge
synopsis:             small framework for performance measurement and analysis
description:
    This library provides a powerful but simple way to measure software
    performance.  It provides both a framework for executing and
    analysing benchmarks and a set of driver functions that makes it
    easy to build and run benchmarks, and to analyse their results.

category:             Development, Performance, Testing, Benchmarking
abi:                  f3c969701edd5898264486183a04f161
exposed:              True
exposed-modules:
    Gauge Gauge.Analysis Gauge.Benchmark Gauge.Main Gauge.Main.Options

hidden-modules:
    Gauge.IO.Printf Gauge.Measurement Gauge.Monad Gauge.ListMap
    Gauge.Time Gauge.Optional Gauge.CSV Gauge.Format
    Gauge.Source.RUsage Gauge.Source.GC Gauge.Source.Time
    System.Random.MWC Paths_gauge Statistics.Distribution
    Statistics.Distribution.Normal Statistics.Function
    Statistics.Internal Statistics.Math.RootFinding Statistics.Matrix
    Statistics.Matrix.Algorithms Statistics.Matrix.Mutable
    Statistics.Matrix.Types Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Transform Statistics.Types Statistics.Types.Internal
    Numeric.MathFunctions.Comparison Numeric.MathFunctions.Constants
    Numeric.SpecFunctions Numeric.SpecFunctions.Internal Numeric.Sum

import-dirs:          /usr/lib/ghc-9.0.2/site-local/gauge-0.2.5
library-dirs:         /usr/lib/ghc-9.0.2/site-local/gauge-0.2.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-gauge
hs-libraries:         HSgauge-0.2.5-7iNfJZka6apEB1NJ8fJOM4
depends:
    base-4.15.1.0 basement-0.0.15-IvZTyCKoUdE3jMkDdiQhQ0
    deepseq-1.4.5.0 directory-1.3.6.2 process-1.6.13.2
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-gauge/html/gauge.haddock
haddock-html:         /usr/share/doc/haskell-gauge/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

