#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 flexible-defaults
version:              0.0.3
visibility:           public
id:                   flexible-defaults-0.0.3-A26tXgXmKKKBKByH35G8E5
key:                  flexible-defaults-0.0.3-A26tXgXmKKKBKByH35G8E5
license:              LicenseRef-PublicDomain
maintainer:           Peter Simons <simons@cryp.to>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/peti/flexible-defaults
synopsis:
    Generate default function implementations for complex type classes.

description:
    Template Haskell code to implement default implementations
    for type-class functions based on which functions are
    already implemented.  Currently extremely crude but
    still fairly effective.

    When defining a type class with many functions, each
    of which can be implemented based on arbitrary subsets
    of the others, the standard default-implementation
    concept breaks down quite badly.  This library provides
    a system by which more complex rules can be described
    for choosing default implementations based on which
    ones the user supplies.  These implementations can
    additionally be given \"suitability scores\", so that
    when multiple possible choices could be made, the
    library can choose the \"best\" one.

category:             Code Generation, Template Haskell
abi:                  e458654eaa356bfb75c67b1a716f0f51
exposed:              True
exposed-modules:      Language.Haskell.TH.FlexibleDefaults
hidden-modules:
    Language.Haskell.TH.FlexibleDefaults.DSL
    Language.Haskell.TH.FlexibleDefaults.Solve

import-dirs:          /usr/lib/ghc-9.0.2/site-local/flexible-defaults-0.0.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/flexible-defaults-0.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-flexible-defaults
hs-libraries:         HSflexible-defaults-0.0.3-A26tXgXmKKKBKByH35G8E5
depends:
    base-4.15.1.0 containers-0.6.4.1 template-haskell-2.17.0.0
    th-extras-0.0.0.6-7uJUsrwXk6YFFI718o03JA transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-flexible-defaults/html/flexible-defaults.haddock

haddock-html:         /usr/share/doc/haskell-flexible-defaults/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

