#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 filepattern
version:              0.1.3
visibility:           public
id:                   filepattern-0.1.3-3fsG8ARQqYy5BZ3PCsMq7x
key:                  filepattern-0.1.3-3fsG8ARQqYy5BZ3PCsMq7x
license:              BSD-3-Clause
copyright:            Neil Mitchell 2011-2022
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:
    Neil Mitchell <ndmitchell@gmail.com>, Evan Rutledge Borden <evan@evan-borden.com>

homepage:             https://github.com/ndmitchell/filepattern#readme
synopsis:             File path glob-like matching
description:
    A library for matching files using patterns such as @\"src\/**\/*.png\"@ for all @.png@ files
    recursively under the @src@ directory. Features:

    * All matching is /O(n)/. Most functions precompute some information given only one argument.

    * See "System.FilePattern" and @?==@ simple matching and semantics.

    * Use @match@ and @substitute@ to extract suitable
    strings from the @*@ and @**@ matches, and substitute them back into other patterns.

    * Use @step@ and @matchMany@ to perform bulk matching
    of many patterns against many paths simultaneously.

    * Use "System.FilePattern.Directory" to perform optimised directory traverals using patterns.

    Originally taken from the <https://hackage.haskell.org/package/shake Shake library>.

category:             Development, FilePath
abi:                  e071aa841f45e3b5b74111587a9af3d1
exposed:              True
exposed-modules:      System.FilePattern System.FilePattern.Directory
hidden-modules:
    System.FilePattern.Core System.FilePattern.ListBy
    System.FilePattern.Monads System.FilePattern.Step
    System.FilePattern.Tree System.FilePattern.Wildcard

import-dirs:          /usr/lib/ghc-9.0.2/site-local/filepattern-0.1.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/filepattern-0.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-filepattern
hs-libraries:         HSfilepattern-0.1.3-3fsG8ARQqYy5BZ3PCsMq7x
depends:
    base-4.15.1.0 directory-1.3.6.2 extra-1.7.12-DPTGYhuNp118MPDFhQYU8g
    filepath-1.4.2.1

haddock-interfaces:   /usr/share/doc/haskell-filepattern/html/filepattern.haddock
haddock-html:         /usr/share/doc/haskell-filepattern/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

