#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 crypto-api-tests
version:              0.3
visibility:           public
id:                   crypto-api-tests-0.3-BQ5ZS99VWlC6rIbqcAjD74
key:                  crypto-api-tests-0.3-BQ5ZS99VWlC6rIbqcAjD74
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:               Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability:            stable
homepage:             http://trac.haskell.org/crypto-api/wiki
synopsis:             A test framework and KATs for cryptographic operations.
description:
    A test framework for hash and cipher operations using
    the crypto-api interface.  Known answer tests (KATs)
    for common cryptographic algorithms are included.
    Patches welcome (both adding KATs for more algorithms
    or property tests for classes of algorithms).

category:             Data, Cryptography
abi:                  eca8d663dc5a3d09213e1249a7f9dd6a
exposed:              True
exposed-modules:
    Test.AES Test.Crypto Test.HMAC Test.MD5 Test.ParseNistKATs Test.SHA
    Test.TwoFish

hidden-modules:       Paths_crypto_api_tests
import-dirs:          /usr/lib/ghc-9.0.2/site-local/crypto-api-tests-0.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/crypto-api-tests-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-crypto-api-tests
hs-libraries:         HScrypto-api-tests-0.3-BQ5ZS99VWlC6rIbqcAjD74
depends:
    HUnit-1.6.2.0-2gufKd42xUzCpoVbpNtVHq
    QuickCheck-2.14.2-JoFwhdHSVnjCwZaPGQEEzD base-4.15.1.0
    bytestring-0.10.12.1 cereal-0.5.8.3-KCibhvvTsuv86wVgcPkD6
    crypto-api-0.13.3-H2rQjLwJg166An3m7THxYG directory-1.3.6.2
    filepath-1.4.2.1 test-framework-0.8.2.0-36r6qqGtDARGnASHTc6so5
    test-framework-hunit-0.3.0.2-3dApyYfyDzfF7PKbq1jVAB
    test-framework-quickcheck2-0.3.0.5-7w2F2hggYVO4F8reBtVmvH

haddock-interfaces:
    /usr/share/doc/haskell-crypto-api-tests/html/crypto-api-tests.haddock

haddock-html:         /usr/share/doc/haskell-crypto-api-tests/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

