#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 configurator
version:              0.3.0.0
visibility:           public
id:                   configurator-0.3.0.0-Gg48IkEhPxc7dghS0nXEYy
key:                  configurator-0.3.0.0-Gg48IkEhPxc7dghS0nXEYy
license:              BSD-3-Clause
copyright:
    Copyright 2011 MailRank, Inc.
    Copyright 2011-2014 Bryan O'\''Sullivan

maintainer:           Bryan O'\''Sullivan <bos@serpentine.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             http://github.com/bos/configurator
synopsis:             Configuration management
description:
    A configuration management library for programs and daemons.

    Features include:

    * Automatic, dynamic reloading in response to modifications to
    configuration files.

    * A simple, but flexible, configuration language, supporting several
    of the most commonly needed types of data, along with
    interpolation of strings from the configuration or the system
    environment (e.g. @$(HOME)@).

    * Subscription-based notification of changes to configuration
    properties.

    * An @import@ directive allows the configuration of a complex
    application to be split across several smaller files, or common
    configuration data to be shared across several applications.

    For details of the configuration file format, see
    <http://hackage.haskell.org/packages/archive/configurator/latest/doc/html/Data-Configurator.html>.

category:             Configuration, Data
abi:                  ddd01e3f63960e54c449661e567982f2
exposed:              True
exposed-modules:      Data.Configurator Data.Configurator.Types
hidden-modules:
    Data.Configurator.Instances Data.Configurator.Parser
    Data.Configurator.Types.Internal

import-dirs:          /usr/lib/ghc-9.0.2/site-local/configurator-0.3.0.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/configurator-0.3.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-configurator
hs-libraries:         HSconfigurator-0.3.0.0-Gg48IkEhPxc7dghS0nXEYy
depends:
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    bytestring-0.10.12.1 directory-1.3.6.2
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F text-1.2.5.0
    unix-compat-0.6-ItrkFOIKc9mI0qPePSsUjW
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r

haddock-interfaces:
    /usr/share/doc/haskell-configurator/html/configurator.haddock

haddock-html:         /usr/share/doc/haskell-configurator/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

